/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef sfwerrorhandler_h
#define sfwerrorhandler_h

#ifndef __SYMBIAN32__
#define NPN_SETEXCEPTION(object, errcode, errmessage) \
        NPN_SetException(object, errmessage);  \
        object->setLastErrCode(errcode); \
        object->setLastErrDescription(errmessage);
#else
#define NPN_SETEXCEPTION(object, errcode, errmessage)\
        object->setLastErrCode(errcode); \
        object->setLastErrDescription(errmessage);
#endif

#define SET_ERROR(object, errcode, errmessage) \
        object->setLastErrCode(errcode); \
        object->setLastErrDescription(errmessage);

#define CLEAR_ERRORS(object) \
    object->setLastErrCode(0); \
    object->setLastErrDescription("");


namespace WRT {
    class SFWErrorHandler
    {
    public:
        SFWErrorHandler() {m_lastErrCode = 0; m_lastErrDesc = "";};
        inline int getLastErrCode() {return m_lastErrCode;};
        inline QString getLastErrDescription() {return m_lastErrDesc;};

    protected:
        inline void setLastErrCode(int aErrCode) {m_lastErrCode = aErrCode;};
        inline void setLastErrDescription(QString aErrDesc) {m_lastErrDesc = aErrDesc;};

    private:
        int m_lastErrCode;                    // code of last error occurred
        QString m_lastErrDesc;                // description of last error occurred
    };
}

#endif /*sfwerrorhandler_h*/
