/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef servicebase_h
#define servicebase_h

#include "serviceinterfaceinfo.h"

//interface id
static const char* KIServiceBaseId = "com.nokia.IServiceBase/1.0";

//ServiceBase interface id
static const ServiceInterfaceInfo KIServiceBaseInfo =
{
    KIServiceBaseId, 0
};

/*!
    The base class for service interfaces.
    All of interfaces supported by service object must derive from this interface.
    Service class must derive from this interface or IServiceBase derived interface.
*/
class IServiceBase
{
public:
    /*!
        Interface getter helper
        Get another interface from available interface implemented by the same
        service provider.

        @param aInterfaceInfo interface info
        @param[out] aInterface Address of the pointer that is the interface
                    pointer to the object or NULL.
    */
    template <class T>
    void getInterface(const ServiceInterfaceInfo& aInterfaceInfo, T** aInterface)
    {
        getInterface(aInterfaceInfo, (void**)aInterface);
    }

    /*!
        Interface getter
        Get another interface from available interface implemented by the same
        service provider.

        @param aInterfaceInfo interface info
        @param[out] aInterface Address of the pointer that is the interface
                    pointer to the object or NULL.
    */
    virtual void getInterface(const ServiceInterfaceInfo& aInterfaceInfo, void** aInterface) = 0;

    /*!
        Increment the reference count
    */
    virtual void addRef() = 0;

    /*!
        Release the interface.
        decrement the reference count
    */
    virtual void release() = 0;

    /*!
        Get service object to which the interface pointer points.

        @return pointer to the object
    */
    virtual QObject* getServiceObject() = 0;
};

Q_DECLARE_INTERFACE(IServiceBase, KIServiceBaseId);

#endif //servicebase_h
