/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRT_USERCONDITION_H
#define __WRT_USERCONDITION_H

#include "condition.h"
#include "capability.h"

namespace WRT {

    // FORWARD DECLARATIONS
    class UserConditionHandler;
    class UserConditionSerializer;

    /**
    * \enum UserGrant
    * Flags used for the user grant status
    */
    enum UserGrant{
        EUserGrantNone = 0,
        EUserGrantGranted = 1,
        EUserGrantDenied = 2,
        EUserGrantBlanket = 4,
        EUserGrantSession = 8,
        EUserGrantOneShot = 16,
        EUserGrantCapsMask = 31,
        EUserGrantDefaultBlanket = 32,
        EUserGrantDefaultSession = 64,
        EUserGrantDefaultOneShot = 128, // This wastes one bit but makes calculation easier
        EUserGrantDefaultMask = 224,
        EUserGrantPersistMask = 253
    };


    class UserCondition : public Condition
    {

    public:
        UserCondition(const QString &capability,
                      unsigned int flags,
                      const UserConditionHandler *handler,
                      UserConditionSerializer *serializer);

        //===========================================================
        // From Condition
        //===========================================================
        virtual bool isMet(const QString &serviceName);
        virtual void reset();
        virtual bool persist();

        //===========================================================
        // Own interface methods
        //===========================================================
        void add(const QString &capability);
        void update(unsigned int flags, unsigned int grants);

    private:
        CapabilityList m_capabilities; // TBD: Fix a lot of copying here?
        unsigned int m_flags;
        const UserConditionHandler *m_userConditionHandler;
        UserConditionSerializer *m_userConditionSerializer;
        unsigned int m_granted;
    };

}
#endif  //__WRT_USERCONDITION_H
