/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRT_TRUSTSESSION_H
#define __WRT_TRUSTSESSION_H

#include <QString>
#include <QVariant>
#include "secmgrdefs.h"

#if defined(QT_MAKE_SECURITY_DLL)
#define TRUST_API Q_DECL_EXPORT
#else
#define TRUST_API Q_DECL_IMPORT
#endif


namespace WRT {

  // FORWARD DECLARATIONS

  class TrustSessionPrivate;

  class TRUST_API TrustSession{
    friend class TrustSessionPrivate;
  public:
    TrustSession();
    TrustSession(const QString &policy);
    ~TrustSession();
    bool setPolicyFile(const QString &policy);
    bool setPolicyFile(const QByteArray &policy);
    QString domainFor(TrustCriteriaType type, const QString &value);
    QString domainFor(const QString &name, const QString &value);
  private:
    TrustSessionPrivate *m_privateTrustSession;
  };
}
#endif  // __WRT_TRUSTSESSION_H
