# ============================================================================
# Name : security.pro
# Part of : CWRT
# Description : Project definition file for project securitymanager
#  Version     : %version: 1 %
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
TEMPLATE = lib
TARGET = WrtSecurityManager
CONFIG += qt dll link_prl create_prl
LIBS += -lWrtSecureStorage
ROOT_DIR = $$PWD/../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

HEADERS += secpolicy.h \
    secsession.h \
    secsession_p.h \
    policyparser.h \
    policyserializer.h \
    xmlpolicyserializer.h \
    capability.h \
    condition.h \
    usercondition.h \
    userconditionhandler.h \
    userconditionserializer.h \
    trustparser.h \
    trustprophandler.h \
    originhandler.h \
    apppathhandler.h \
    processhandler.h \
    certificatehandler.h \
    trustsession.h \
    trustsession_p.h \
    secmgrdefs.h \
    secure_defs.h
SOURCES += secpolicy.cpp \
    secsession.cpp \
    policyparser.cpp \
    xmlpolicyserializer.cpp \
    usercondition.cpp \
    trustparser.cpp \
    originhandler.cpp \
    apppathhandler.cpp \
    processhandler.cpp \
    certificatehandler.cpp \
    trustsession.cpp

DEFINES += QT_MAKE_SECURITY_DLL BUILDING_SEC_MGR
INCLUDEPATH += . ../inc ../securestorage

    EXPORT_FILES = trustsession.h \
        secsession.h \
        secmgrdefs.h \
        capability.h \
        condition.h \
        usercondition.h \
        userconditionhandler.h \
        securitymanager.h

    maemo5|maemo6 {
        # Installing security headers so that debianization can pick the right headers.
        headers.files += $$EXPORT_FILES
        headers.path += $$CWRT_INSTALL_PUBLIC_HEADERS_DIR/security
        INSTALLS += headers
    }

unix:!symbian {
    headers_security.files = \
        $$PWD/apppathhandler.h \
        $$PWD/capability.h \
        $$PWD/certificatehandler.h \
        $$PWD/condition.h \
        $$PWD/originhandler.h \
        $$PWD/policyparser.h \
        $$PWD/policyserializer.h \
        $$PWD/processhandler.h \
        $$PWD/secmgrdefs.h \
        $$PWD/secpolicy.h \
        $$PWD/secsession.h \
        $$PWD/secure_defs.h \
        $$PWD/securitymanager.h \
        $$PWD/trustparser.h \
        $$PWD/trustprophandler.h \
        $$PWD/trustsession.h \
        $$PWD/usercondition.h \
        $$PWD/userconditionhandler.h \
        $$PWD/userconditionserializer.h \
        $$PWD/xmlpolicyserializer.h
    headers_security.path = $$CWRT_INSTALL_INC_DIR/wrt/security

    INSTALLS += headers_security
}
