#
# ============================================================================
#  Name        : securestorage.pro
#  Part of     : ECWRT
#  Description : Project definition file for project securestorage
#  Version     : %version: 15 %
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

TEMPLATE = lib
maemo {
    TARGET = WrtSecureStorage
} else {
    TARGET = wrtsecurestorage
}
QT        -= gui
QT        += xml
CONFIG += link_prl create_prl

HEADERS   += storage.h

DEFINES += QT_MAKE_SECURESTORAGE_DLL

ROOT_DIR = $$PWD/../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)

LIBS += -lWrtServiceIpcClient

INCLUDEPATH += $$CWRT_INCLUDE

EXPORT_FILES = storage.h

EXPORT_DESTDIR = ~/.local/share/data/Nokia/wrt/security/

INCLUDEPATH += platform/qt/
HEADERS     += platform/qt/defaultstorage.h

SOURCES     += platform/qt/storage.cpp \
               platform/qt/defaultstorage.cpp

EXPORT_FILES += .\platform\qt\securestorage.h
INCLUDEPATH += platform/qt/
HEADERS     += platform/qt/securestoragedefs.h \
               platform/qt/securestorage.h \
               platform/qt/securestoragemetadata.h

SOURCES     += platform/qt/securestorage.cpp \
               platform/qt/securestoragemetadata.cpp

policyXml.path = $$CWRT_POLICY_DIR
policyXml.files = browser_access_policy.xml browser_trust_policy.xml
INSTALLS += policyXml

include($$WRT_DIR/cwrt-export.pri)
