/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRT_SECURESTORAGESERVER_H
#define __WRT_SECURESTORAGESERVER_H

#include <QObject>
#include "serviceipcobserver.h"

namespace WRT
    {
    // FORWARD DECLARATIONS
    class ServiceFwIPCServer;
    class ServiceIPCRequest;
    class SecureStorageServerSession;

    class SecureStorageServer : public QObject,
                                public MServiceIPCObserver
        {
        Q_OBJECT

    public: // METHODS
        SecureStorageServer( QObject* aParent = NULL );
        virtual ~SecureStorageServer();

    private:
        // METHODS
        bool handleRequest(ServiceIPCRequest *aRequest);
        void handleCancelRequest(ServiceIPCRequest *aRequest);
        void handleClientConnect( ClientInfo *aNewClient );
        void handleClientDisconnect( ClientInfo *aClient );
        SecureStorageServerSession *findSession(const QString &aId);
        SecureStorageServerSession *findOrCreateSession(const QString &aId);

    private Q_SLOTS:
        void closeServer();

    private:
        // member variables
        ServiceFwIPCServer *m_server;
        QList<SecureStorageServerSession*> m_storageSessions;
        };
    }

#endif  // __WRT_SECURESTORAGESERVER_H
