/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTPAGE_H__
#define __WRTPAGE_H__

#include <QWidget>
#include <QWebPage>
#include "runtimeglobal.h"

namespace WRT {

class WrtPagePrivate;

class RUNTIME_EXPORT WrtPage : public QWebPage
{
    Q_OBJECT
public:
    WrtPage(QWidget *parent=0);
    virtual ~WrtPage();

    void setPageGroupName(const QString&);

public:
    virtual QWebPage* createWindow(QWebPage::WebWindowType);
    virtual void javaScriptConsoleMessage(const QString& messageSource, const QString& messageLevel, const QString& message, int lineNumber, const QString& sourceID);
    // new QT has changed the signature of the method
    virtual void javaScriptConsoleMessage(const QString& message, int lineNumber, const QString& sourceID);
    virtual void enableLocalStorage(const QString & path = QString());
    virtual qint64 enableOfflineWebApplicationCache(const QString & path, const qint64 & quota = 0);

Q_SIGNALS:
    void createWindow(WrtPage* page);
    void jsConsoleMessage(const QString& messageSource, const QString& messageLevel, const QString& message, int lineNumber, const QString& sourceID);

    void captureTrace(QWebFrame* frame, QString context, QByteArray value);
    
#ifdef Q_OS_SYMBIAN
    void popupMessageVisible(bool visible);
#endif

public slots:
    //TODO always let js run for now. This allows sunspider testsuite to finish. But it will break the infinite loop test case.
    //TODO change to true after performance is improved and each sunspider test can finish in 10s.
    //The return value is changed to true to satisfy the infinite loop test case. But the test result is not interact users.
    //Instead, the infinite loop was stopped without asking if the user wants to stop. This is webkit behavior.
    bool shouldInterruptJavaScript() {
        return true;
    }

#ifdef Q_OS_MAEMO6
   virtual void javaScriptAlert ( QWebFrame * frame, const QString & msg );
   virtual bool javaScriptConfirm ( QWebFrame * frame, const QString & msg );
   virtual bool javaScriptPrompt ( QWebFrame * frame, const QString & msg, const QString & defaultValue, QString * result );
   signals:
   void showJavaScriptAlert(QWebFrame*,const QString& msg);
   bool showJavaScriptConfirm(QWebFrame*, const QString& msg);
   bool showJavaScriptPrompt( QWebFrame * frame, const QString & msg, const QString & defaultValue, QString * result );
#else
#ifdef CWRT_BUILDING_TENONE
   virtual QString chooseFile(QWebFrame *originatingFrame, const QString& oldFile);
   virtual void javaScriptAlert ( QWebFrame * frame, const QString & msg );
   virtual bool javaScriptConfirm ( QWebFrame * frame, const QString & msg );
   virtual bool javaScriptPrompt ( QWebFrame * frame, const QString & msg, const QString & defaultValue, QString * result );
#endif
#endif

protected:
    virtual QString userAgentForUrl(const QUrl& url) const;

private:
    WrtPagePrivate* d;

private:
    friend class WrtNetworkAccessManager;
};

}
#endif
