/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTCONTROLLER_P_H__
#define __WRTCONTROLLER_P_H__

#include <QWidget>
#ifdef CWRT_BUILDING_TENONE
#include "hbwidget.h"
#endif
#include "wrtglobal.h"

class QGraphicsView;
class QGraphicsScene;
class QGraphicsWebView;

namespace WRT {

class WrtPage;
class WebNavigation;

class WrtControllerPrivate
{
public:
#ifdef CWRT_BUILDING_TENONE
    WrtControllerPrivate(HbWidget *parent, WebKitView webkitView = WRT::WebView);
#else
    WrtControllerPrivate(QWidget *parent, WebKitView webkitView = WRT::WebView);
#endif
    WrtControllerPrivate(QWidget* parent, WrtPage* wrtPage, WebKitView webkitView = WRT::WebView);
    ~WrtControllerPrivate();

    WrtPage* m_wrtPage;
    QWidget* m_webWidget;
    QGraphicsWebView* m_graphicsWebView;
    WebNavigation* m_webNavigation;
};

}
#endif
