/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "wrtcontroller_p.h"
#include "wrtcontroller.h"

#include <qwebframe.h>
#include <qwebview.h>
#include <qgraphicswebview.h>
#include "wrtwebview.h"
#include "wrtgraphicswebview.h"
#include "wrtpage.h"
#include "webnavigation.h"


namespace WRT {

#ifdef CWRT_BUILDING_TENONE
WrtControllerPrivate::WrtControllerPrivate(HbWidget *parent, WebKitView webkitView) :
#else
WrtControllerPrivate::WrtControllerPrivate(QWidget *parent, WebKitView webkitView) :
#endif
m_wrtPage(0)
, m_webWidget(0)
, m_graphicsWebView(0)
, m_webNavigation(0)
{
    switch (webkitView) {

    case WRT::GraphicsWebView: {
        m_graphicsWebView = new WrtGraphicsWebView();
        m_wrtPage = new WrtPage();
        m_graphicsWebView->setPage(m_wrtPage);
        m_webNavigation = new WebNavigation(m_graphicsWebView, m_wrtPage);
        break;
        }

    case WRT::WebView: {
#ifdef CWRT_BUILDING_TENONE
        Q_ASSERT(0);
#else
        m_webWidget = new WrtWebView();
        m_wrtPage = new WrtPage(m_webWidget);
        static_cast<QWebView*>(m_webWidget)->setPage(m_wrtPage);
        m_wrtPage->setView(m_webWidget);
        static_cast<QWebView*>(m_webWidget)->setFocus();
        static_cast<QWebView*>(m_webWidget)->setZoomFactor(1.0);
        QPalette pal = static_cast<QWebView*>(m_webWidget)->palette();
        // @TODO: this is a workaround because of QtWebkit bug:
        // @see http://bugreports.qt.nokia.com/browse/QTBUG-6188 and
        // https://bugs.webkit.org/show_bug.cgi?id=31834
        // base brush can't set to QWebView without breaking input field styling on S60
        // Original code
        // pal.setBrush(QPalette::Base, Qt::white);
        // static_cast<QWebView*>(m_webWidget)->setPalette(pal);
        // Original code end
        // Temporarily workaround
        pal.setBrush(QPalette::Window, Qt::white);
        static_cast<QWebView*>(m_webWidget)->setPalette(pal);
        pal.setBrush(QPalette::Base, Qt::white);
        m_wrtPage->setPalette(pal);
        // Temporarily workaround end
        m_webNavigation = new WebNavigation(m_webWidget, m_wrtPage);
#endif
        break;
        }

    };
}

WrtControllerPrivate::WrtControllerPrivate(QWidget* parent, WrtPage* wrtPage, WebKitView webkitView) :
m_webWidget(0)
, m_graphicsWebView(0)
, m_webNavigation(0)
{
    switch (webkitView) {

    case WRT::GraphicsWebView: {
        m_graphicsWebView = new WrtGraphicsWebView();
        m_wrtPage = wrtPage;
        m_graphicsWebView->setPage(m_wrtPage);
        m_webNavigation = new WebNavigation(m_graphicsWebView, m_wrtPage);
        break;
        }

    case WRT::WebView: {
        m_webWidget = new WrtWebView();
        m_wrtPage = wrtPage;
        static_cast<QWebView*>(m_webWidget)->setPage(m_wrtPage);
        m_wrtPage->setView(m_webWidget);
        static_cast<QWebView*>(m_webWidget)->setFocus();
        static_cast<QWebView*>(m_webWidget)->setZoomFactor(1.0);
        QPalette pal = static_cast<QWebView*>(m_webWidget)->palette();
        // @TODO: this is a workaround because of QtWebkit bug:
        // @see http://bugreports.qt.nokia.com/browse/QTBUG-6188 and
        // https://bugs.webkit.org/show_bug.cgi?id=31834
        // base brush can't set to QWebView without breaking input field styling on s60
        // Original code
        // pal.setBrush(QPalette::Base, Qt::white);
        // static_cast<QWebView*>(m_webWidget)->setPalette(pal);
        // Original code end
        // Temporarily workaround
        pal.setBrush(QPalette::Window, Qt::white);
        static_cast<QWebView*>(m_webWidget)->setPalette(pal);
        pal.setBrush(QPalette::Base, Qt::white);
        m_wrtPage->setPalette(pal);
        // Temporarily workaround end
        m_webNavigation = new WebNavigation(m_webWidget, m_wrtPage);
        break;
        }

    };
}

WrtControllerPrivate::~WrtControllerPrivate()
{
    if (m_wrtPage)
        m_wrtPage->disconnect();
    delete m_webNavigation;
    delete m_webWidget;
    delete m_graphicsWebView;
}

#ifdef CWRT_BUILDING_TENONE
WrtController::WrtController(HbWidget *parent,  WebKitView webkitView) :
d(new WrtControllerPrivate(parent, webkitView))
{
    connect(this, SIGNAL(pauseNavigation()), d->m_webNavigation, SLOT(pauseNavigation()));
    connect(this, SIGNAL(resumeNavigation()), d->m_webNavigation, SLOT(resumeNavigation()));
}
#else
WrtController::WrtController(QWidget *parent,  WebKitView webkitView) :
d(new WrtControllerPrivate(parent, webkitView))
{
}
#endif

WrtController::WrtController(QWidget* parent, WrtPage* wrtPage, WebKitView webkitView) :
d(new WrtControllerPrivate(parent, wrtPage, webkitView))
{
}

WrtController::~WrtController()
{
    delete d;
}

WrtPage* WrtController::wrtPage()
{
    return d->m_wrtPage;
}

QWidget* WrtController::webWidget()
{
    return d->m_webWidget;
}

QGraphicsWebView* WrtController::graphicsWebView()
{
    return d->m_graphicsWebView;
}

void WrtController::enableContextMenu(bool enable)
{
    if (d->m_webWidget){
        static_cast<WrtWebView*>(d->m_webWidget)->enableContextMenu(enable);
    }
    else if (d->m_graphicsWebView){
        static_cast<WrtGraphicsWebView*>(d->m_graphicsWebView)->enableContextMenu(enable);
    }
}

}

