/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBCURSORNAVIGATION_H
#define WEBCURSORNAVIGATION_H


#include <QApplication>
#include <QObject>
#include <QEvent>
#include <QKeyEvent>
#include <QTimer>
#include <QPixmap>

class QWebPage;

namespace WRT {

    class WebCursorNavigation : public QObject
    {
    Q_OBJECT
    public:
        WebCursorNavigation(QObject* object, QWebPage* webPage);
        virtual ~WebCursorNavigation();

    protected slots:
        void keypressTimeout();
        void scrollTimeout();

    protected:
        void keyPressEvent(QKeyEvent* ev);
        void keyReleaseEvent(QKeyEvent* ev);

        bool eventFilter(QObject *object, QEvent *event);
        bool scroll(int direction);
        void moveCursor(int direction);
        QPoint getCursorPosition();
        void setCursorPosition(const QPoint& point);
        int getNearestEdge(int scrollRange,int direction);

    private:
        QObject* m_viewObject;
        QWebPage* m_webPage;
        int m_flipcounter;
        int m_direction;
        int m_lastdirection;
#ifdef QT_KEYPAD_NAVIGATION
        Qt::NavigationMode m_navigationMode;
#endif
        QTimer m_keypressTimer;
        QTimer m_scrollTimer;

    };

}

#endif
