/**
 * A wrapper JS class for SFW iterator
 * @class SFWIter
 */

/**
 * Constructs an instance of SFWIter class
 * 
 * @constructor {public} SFWIter 
 * @param {object} iter an iterator on a collection
 */
function SFWIter(iter)
{
    this._iter = iter;
}

/**
 * Returns true if there are more items in the collection 
 * @function {bool} hasNext 
 */
SFWIter.prototype.hasNext = function() {
    return this._iter.hasNext();
}

/**
 * Returns next item in the collection if not at the end of collection, null otherwise
 * 
 * @function {object} next
 * @returns next item in the collection
 */
SFWIter.prototype.next = function() {
    if (this._iter.hasNext()) {
        return this._iter.next();
    } else {
        return null;
    }
}

/**
 * Reset the iterator position to the start of collection 
 * 
 * @function {void} begin
 */
SFWIter.prototype.begin = function(){
    this._iter.reset();
}