/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
nokia.device.Sysinfo = function PSSysinfoInterface(){

    var DeviceException = nokia.device.DeviceException;
    var error = new DeviceException(0, 'dummy');
    /*
     * Internal
     * qt sysinfo interface object.
     */

    var qtSysInfoIf = nokia._services.load("nokia.device.sysinfo", "com.nokia.ISysInfo", "1.0");
    qtSysInfoIf.addEventListener("asyncCallback(int,int,const QMap<QString,QVariant>&)", sysInfo_getChannel_cb);
    qtSysInfoIf.addEventListener("asyncCallbackStChannel(int,int,const QMap<QString,QVariant>&)", sysInfo_startChannel_cb);

    /*
     * SysInfo getChannel callback handler
     */
    function sysInfo_getChannel_cb(errCode, transId, result){
        //alert('getlistcb'+transId);
        var retObj = asyncCallbackMap.get(transId);
        //alert('retObj '+retObj);
        asyncCallbackMap.remove(transId);

        if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
        var callback = retObj.success_cb;
        var errorCallback = retObj.error_cb;
        //alert('callback :error '+errCode+'scb : '+callback);
        //serviceObject.removeEventListener(transId);
        if (errCode != 0) {
            errorCallback(new DeviceException( errCode, "Error in async operation" ) );
            return;
        }
        //alert('calling users cb'+callback);
        callback(result);
    }

    /*
     * SysInfo startChannel callback handler
     */
    function sysInfo_startChannel_cb(errCode, transId, result){
        //alert('getlistcb'+transId);
        var retObj = asyncCallbackMap.get(transId);
        //alert('retObj '+retObj);

        if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
        var callback = retObj.success_cb;
        var errorCallback = retObj.error_cb;
        if (errCode != 0) {
            errorCallback( new DeviceException( errCode , "Error in async operation" ) );
            return;
        }
        //alert('calling users cb'+callback);
        callback(result);
    }

    /*
     * Internal
     * Counter to hold number of getChannel calls
     */
    var asyncCount = 0;

    /*
     * Internal
     * Object to map connection id to transaction id for getChannel
     */
    Connection.prototype = new Object();
    Connection.prototype.constructor = Connection;

    /*
     * Internal
     * Constructor for Connection
     */
    function Connection(connectionId, transId, callback){
        this.connectionId = connectionId;
        this.transId = transId;
        this.callback = callback;
    }

    /*
     * Internal
     * Array holding Connection objects for getChannel
     */
    var connArr = new Array();

    /*
     * Internal
     * Counter to hold number of startChannel calls
     */
    var notifCount = 0;

    /*
     * Internal
     * Object to map connection id to transaction id for startChannel
     */
    Notification.prototype = new Object(); //inheritance occurs here
    Notification.prototype.constructor = Notification;

    /*
     * Internal
     * Constructor for Notification
     */
    function Notification(connectionId, transId, callback, channel){
        this.connectionId = connectionId;
        this.transId = transId;
        this.callback = callback;
        this.channel = channel;
    }

    /*
     * Internal
     * Array holding Connection objects for startChannel
     */
    //var notifArr = new Array();

    /*
     * Internal
     * Object mapping country name to ISO-3166 standard
     */
     var countryArr = {
     "Afghanistan":"AF", "Algeria":"DZ", "Andorra":"AD", "Angola":"AO", "Anguilla":"AI",
     "Antigua & Barbuda":"AG", "Argentina":"AR", "Armenia":"AM", "Aruba":"AW", "Australia":"AU",
     "Austria":"AT", "Azerbaijan":"AZ", "Azores":"Azores", "Bahamas":"BS", "Bahrain":"BH",
     "Bangladesh":"BD", "Barbados":"BB", "Belarus":"BY", "Belgium":"BE", "Belize":"BZ",
     "Benin":"BJ", "Bermuda":"BM", "Bhutan":"BT", "Bolivia":"BO", "Bosnia and Herzegovina":"BA",
     "Botswana":"BW", "Brazil":"BR", "British Indian Ocean Territory":"IO",
     "British Virgin Islands":"VG", "Brunei":"BN", "Bulgaria":"BG", "Burkina Faso":"BF",
     "Burundi":"BI", "Cambodia":"KH", "Cameroon":"CM", "Canada":"CA",
     "Canary Islands":"Canary Islands", "Cape Verde":"CV", "Cayman Islands":"KY",
     "Central African Republic":"CF", "Chad":"TD", "Chile":"CL", "China":"CN",
     "Christmas Island":"CX", "Cocos (Keeling) Islands":"CC", "Colombia":"CO", "Comoros":"KM",
     "Cook Islands":"CK", "Costa Rica":"CR", "C�te d'Ivoire":"CI", "Croatia":"HR", "Cuba":"CU",
     "Curacao":"Curacao", "Cyprus":"CY", "Czech Republic":"CZ", "Democratic Republic of the Congo":"CD",
     "Denmark":"DK", "Djibouti":"DJ", "Dominica":"DM", "Dominican Republic":"DO",
     "Easter Island":"Easter Island", "Ecuador":"EC", "Egypt":"EG", "El Salvador":"SV",
     "Equatorial Guinea":"GQ", "Eritrea":"ER", "Estonia":"EE", "Ethiopia":"ET", "Falkland Islands":"FK",
     "Faroe Islands":"FO", "Fiji":"FJ", "Finland":"FI", "France":"FR", "French Guiana":"GF",
     "French Polynesia":"PF", "Gabon":"GA", "Galapagos Islands":"Galapagos Islands", "Gambia":"GM",
     "Georgia":"GE", "Germany":"DE", "Ghana":"GH", "Gibraltar":"GI", "Greece":"GR", "Greenland":"GL",
     "Grenada":"GD", "Guadeloupe":"GP", "Guam":"GU", "Guatemala":"GT", "Guinea":"GN",
     "Guinea-Bissau":"GW", "Guyana":"GY", "Haiti":"HT", "Honduras":"HN", "Hong Kong":"HK",
     "Hungary":"HU", "Iceland":"IS", "India":"IN", "Indonesia":"ID", "Iran":"IR", "Iraq":"IQ",
     "Israel":"IL", "Italy":"IT", "Jamaica":"JM", "Japan":"JP", "Jerusalem":"Jerusalem",
     "Jordan":"JO", "Kazakhstan":"KZ", "Kenya":"KE", "Kerguelen":"Kerguelen", "Kiribati":"KI",
     "Kiritimati (Christmas Island)":"CX", "Kuwait":"KW", "Kyrgyzstan":"KG", "Laos":"LA",
     "Latvia":"LV", "Lebanon":"LB", "Lesotho":"LS", "Liberia":"LR", "Libya":"LY", "Liechtenstein":"LI",
     "Lithuania":"LT", "Luxembourg":"LU", "Macau":"MO", "Macedonia":"MK", "Madagascar":"MG",
     "Madeira":"Madeira", "Malawi":"MW", "Malaysia":"MY", "Maldives":"MV", "Mali":"ML",
     "Malta":"MT", "Marquesas Islands":"Marquesas Islands", "Marshall Islands":"MH",
     "Martinique":"MQ", "Mauritania":"MR", "Mauritius":"MU", "Mayotte":"YT", "Mexico":"MX",
     "Micronesia":"FM", "Moldova":"MD", "Monaco":"MC", "Mongolia":"MN", "Montenegro":"ME",
     "Montserrat":"MS", "Morocco":"MA", "Mozambique":"MZ", "Myanmar":"MM", "Namibia":"NA",
     "Nauru":"NR", "Nepal":"NP", "Netherlands":"NL", "New Caledonia":"NC", "New Zealand":"NZ",
     "Nicaragua":"NI", "Niger":"NE", "Nigeria":"NG", "Niue":"NU", "Norfolk Island":"NF",
     "North Korea":"KP", "Northern Ireland":"IE", "Northern Mariana Islands":"MP", "Norway":"NO",
     "Oman":"OM", "Pakistan":"PK", "Palau":"PW", "Panama":"PA", "Papua New Guinea":"PG", "Paraguay":"PY",
     "Peru":"PE", "Philippines":"PH", "Phoenix Islands":"Phoenix Islands", "Pitcairn":"PN", "Poland":"PL",
     "Portugal":"PT", "Puerto Rico":"PR", "Qatar":"QA", "Republic of Ireland":"IE", "Republic of the Congo":"CG",
     "Reunion":"RE", "Romania":"RO", "Russia":"RU", "Rwanda":"RW", "Saint Helena":"SH",
     "Saint Kitts & Nevis":"KN", "Saint Lucia":"LC", "Saint Pierre and Miquelon":"PM",
     "Saint Vincent and Granadines":"VC", "Samoa":"WS", "San Marino":"SM", "Sao Tome & Principe":"ST",
     "Saudi Arabia":"SA", "Senegal":"SN", "Serbia":"RS", "Seychelles":"SC", "Sierra Leone":"SL",
     "Singapore":"SG", "Slovakia":"SK", "Slovenia":"SI", "Solomon Islands":"SB", "Somalia":"SO",
     "South Africa":"ZA", "South Georgia":"GS", "South Korea":"KR", "Spain":"ES", "Sri Lanka":"LK",
     "Sudan":"SD", "Suriname":"SR", "Swaziland":"SZ", "Sweden":"SE", "Switzerland":"CH", "Syria":"SY",
     "Tahiti":"Tahiti", "Taiwan":"TW", "Tajikistan":"TJ", "Tanzania":"TZ", "Thailand":"TH", "Timor-Leste":"TL",
     "Togo":"TG", "Tokelau Islands":"TK", "Tonga":"TO", "Trinidad and Tobago":"TT", "Tunisia":"TN",
     "Turkey":"TR", "Turkmenistan":"TM", "Turks and Caicos Islands":"TC", "Tuvalu":"TV",
     "Uganda":"UG", "Ukraine":"UA", "United Arab Emirates":"AE", "United Kingdom":"GB", "Uruguay":"UY",
     "USA":"US", "Uzbekistan":"UZ", "Vanuatu":"VU", "Vatican":"VA", "Venezuela":"VE", "Vietnam":"VN",
     "Wallis and Futuna Islands":"WF", "Western Sahara":"EH", "Yemen":"YE", "Zambia":"ZM", "Zimbabwe":"ZW"
     };

    /*
     * Internal
     * sysInfoObject object which implements ISysInfo interface of SysInfoService
     */
    function SysInfo(qtSysInfoIf){
        this._sysInfoObject = qtSysInfoIf;
    }

    /*
     * Internal
     * Temporary service object to be held for removing async signal from callback
     */
    var tempSysInfo;
    return {
        /**
        * @constant {String}
        * interfaceName.
        */
        interfaceName: "sysinfo",
        /**
        * @constant {Number}
        * version.
        */
        version: nokia.device._interfaces['sysinfo'],
        /**
        * Gets the list of system information channels supported on the device.
        * This is a synchronous function.
        * @return {array} Channel descriptors(as maps) for the available channels }
        */
        getChannelList : function(){
          var __sp_channel_descriptors = [{
            name: 'Charging',
            data: [{
              name: 'chargingStatus',
              range: 'true or false',
              description: 'Charging(true) ,Not charging(false)'
            }],
            style: ["Sync", "Oneshot", "Notification"]
          }, {
            name: 'BluetoothOn',
            data: [{
              name: 'btOn',
              range: 'true or false',
              description: 'BluetoothOn(true) ,BluetoothOff(false)'
            }],
            style: ["Sync", "Oneshot", "Notification"]
          }, {
            name: 'PhoneLanguage',
            data: [{
              name: 'phoneLanguage',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'ProductType',
            data: [{
              name: 'productType',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'FirmwareVersion',
            data: [{
              name: 'firmwareVersion',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'BatteryLevel',
            data: [{
              name: "batteryLevel ",
              range: '0-100',
              description: 'Percent battery charge'
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'SignalStrength',
            data: [{
              name: "signalStrength",
              range: '0-100',
              description: 'Signal Strength in Percentage'
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'Network',
            data: [{
              name: "networkName ",
              description: "Network name"
            }, {
              name: "networkStatus",
              range: "Available,Current,Forbidden",
              description: ""
            }, {
              name: "networkMode",
              range: "ModeGsm,ModeCdma,ModeWcdma",
              description: ""
            }, {
              name: "mobileCountryCode",
              range: "",
              description: ""
            }, {
              name: "mobileNetworkCode",
              range: "",
              description: ""
            }, {
              name: "locationStatus",
              range: "True, False",
              description: ""
            }, {
              name: "areaCode",
              range: "",
              description: ""
            }, {
              name: "cellID",
              range: "",
              description: ""
            }],
            style: ["Async", "Oneshot", "Notification"]
          } , {
            name: 'IMEI',
            data: [{
              name: "imei",
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          } ,  {
            name: 'DisplayOrientation',
            data: [{
              name: "displayOrientation",
              range: "Landscape,Portrait",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'CellularNetworkStatus',
            data: [{
              name: "cellularNetworkStatus",
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'DeviceInputMethod',
            data: [{
              name: "deviceInputMethod",
              range: "Touch,NonTouch,Hybrid",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'HomeNetwork',
            data: [{
              name: "networkName ",
              description: "Network name"
            }, {
              name: "networkStatus",
              range: "Available,Current,Forbidden",
              description: ""
            }, {
              name: "networkMode",
              range: "ModeGsm,ModeCdma,ModeWcdma",
              description: ""
            }, {
              name: "mobileCountryCode",
              range: "",
              description: ""
            }, {
              name: "mobileNetworkCode",
              range: "",
              description: ""
            }, {
              name: "locationStatus",
              range: "True, False",
              description: ""
            }, {
              name: "areaCode",
              range: "",
              description: ""
            }, {
              name: "cellID",
              range: "",
              description: ""
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'DisplayResolution',
            data: [{
              name: "height",
              range: "",
              description: ""
            }, {
              name: "width",
              range: "",
              description: ""
            }],
            style: ["Sync", "Notification"]
          }, {
            name: 'PhoneManufacturer',
            data: [{
              name: "phoneManufacturer",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PhoneModel',
            data: [{
              name: "phoneModel",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PlatformName',
            data: [{
              name: "platformName",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'BacklightState',
            data: [{
              name: "backLightOn",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'KeypadLightState',
            data: [{
              name: "keypadLightOn",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'ActiveProfile',
            data: [{
              name: "msgRingtoneVolume",
              range: "1-10",
                  description: ""
            }, {
              name: "ringtoneVolume",
              range: "1-10",
              description: ""
            }, {
              name: "vibrationActive",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PhoneColorDepth',
            data: [{
              name: "phoneColorDepth",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'ClipBoard',
            data: [{
              name: "clipBoardData",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'WirelessConnSupport',
            data: [{
              name: "connTypes",
              range: "",
              description: "string list"
            }],
            style: ["Sync"]
          }, {
            name: 'SupportedVideoDecoders',
            data: [{
              name: "capability",
              data: [{
                name: "manufacturer",
                description: ""
              },{
                name: "identifier",
                description: ""
              },{
                name: "maxBitrate",
                description: ""
              },{
                name: "accelerated",
                description: ""
              },{
                name: "version",
                description: ""
              }],
              description: "string list"
            }],
            style: ["Sync"]
          }, {
            name: 'DataNetworkInfo',
            data: [{
              name: "connectionList",
              data: [{
                name: "connectionType",
                description: ""
              },{
                name: "connectionStatus",
                description: ""
              },{
                name: "connectionName",
                description: ""
              }],
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'WebRuntimeInfo',
            data: [{
              name: "WebRuntimeInfo",
              data: [{
                name: "name",
                description: ""
              },{
                name: "vendor",
                description: ""
              },{
                name: "version ",
                description: ""
              }],
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }];
          return __sp_channel_descriptors;
        },
     /**
     * Sets the properties of the specified channel.
     * This is a synchronous function.
     * @param {string} aChannel - Name of the channel as specified in the channel
     *                            descriptor.The channel is DisplayWallpaper
     * @param {list} inputData - input data list of the set.
     * @return {object} error object
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    setChannel : function(aChannel, inputData) {
        switch (aChannel) {
        case "DisplayWallpaper":{
            if ( inputData.wallpaperFileurl == null )
                throw new DeviceException(error.MISSING_ARG_ERR, "Wallpaper url is missing");
            if ( typeof inputData.wallpaperFileurl != 'string' )
                throw new DeviceException(error.INVALID_ARG_ERR, "Wallpaper url is not of string type");
            if (inputData.wallpaperFileurl.slice(0, 7) != "file://")
                throw new DeviceException(error.INVALID_ARG_ERR, "Wallpaper url does not conform with file schema");

            var srcFileName = inputData.wallpaperFileurl.slice(7).replace(/\057/g, "\\");
            var inputMap = {
                wallpaperFileurl:srcFileName
            };
            var retVal = qtSysInfoIf.setChannelSync(aChannel, inputMap);
            //If error,then throw error
            if ( retVal.errCode != 0 ){
               throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
            break;
        }
        case "Vibrate":{

          var vibraValues ={
            vibraDurationSecs : 0,
            Intensity: null
          };

          if ((inputData == null)  || (inputData == "string")) {
            throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "inputdata is invalid");
          }

          if (typeof(inputData) == "object") {
            if ((inputData.enable == undefined)||(inputData.enable == true)) {
              if (inputData.duration) {
                if (typeof(inputData.duration) != "number") {
                  throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "duration is not an integer");
                }
                vibraValues.vibraDurationSecs = inputData.duration;
                if (inputData.intensity) {
                  if (typeof(inputData.intensity) != "number") {
                    throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "intensity is not an integer");
                  }
                  vibraValues.Intensity = inputData.intensity;
                }
              }
            }
            else if (inputData.enable == false) {
              vibraValues.vibraDurationSecs = -1;
            }
            else {
              throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "enable is not an valid input");
            }

            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else if (!inputData){
            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else if (typeof(inputData) != "object"){
            if ((isNaN(inputData))){
              throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "inputData is not an valid input");
            }
            else {
              vibraValues.vibraDurationSecs = inputData;
            }
            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else {
            throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "invalid arg");
          }
          return retVal;
        }
        break;
        case "ClipBoard": {
                    if (inputData.clipBoardData == null)
                        throw new DeviceException(error.MISSING_ARG_ERR, "Clipboard data is missing");
                    if ( typeof inputData.clipBoardData != 'string' )
                        throw new DeviceException(error.INVALID_ARG_ERR, "Clipboard data is not a number");

                    var retVal = qtSysInfoIf.setChannelSync(aChannel, inputData);
                    //If error,then throw error
                    if ( retVal.errCode != 0 ){
                        throw new DeviceException( retVal.errCode, retVal.errMessage );
                    }
                }
          break;
        default:
          { //Error cases
            if (aChannel == null) {
              throw new DeviceException(error.MISSING_ARG_ERR, "Channel is missing");
            }
            else {
              if (typeof aChannel != "string") {
                throw new DeviceException(error.INVALID_ARG_ERR, "Channel is of invalid type");
              }
              else {
                throw new DeviceException(error.INVALID_ARG_ERR, "setChannel is not supported for this channel");
              }
            }
          }
      }
      //alert("at end retVal:"+retVal);
      return retVal;
    },
     /**
     * Gets the properties of the specified channel.
     * This method supports synchronous and asynchronous based on style information of <i>channel descriptor</i>.
     * This is a synchronous/asynchronous function.
     * @param {string} aChannel - Name of the channel as specified in the <i>channel
     *                        descriptor</i>.The synchronous channels are Charging,
     *                        PhoneLanguage,BluetoothOn,ProductType and FirmwareVersion.
     *                        The asynchronous channels are BatteryLevel,Network
     *                            and SignalStrength.
     * @param {function} [successCB] - callback function invoked if async call
     *                       is completed and successful.<br><ul>function signature <b>function (Sysinfo data)</b></ul>
     * @param {function} [errorCB(DeviceError)] - callback function invoked if async call is
     *                     completed and not successful.
     *
     * <br><br>
     * <b>Status Codes</b> are the codes returned in errorCallback functionErrorCallback for channels that support asynchronous behavior.<br>
     * <br>
     *                          Code 101 (DATA_NOT_FOUND_ERR): If there is no active asynchronous request corresponding to the specified transactionId.
     *                          <br>
     *
     * @return {Sysinfo Data/number} Properties of the channel(if synchronous)
     *               or transaction id(if asynchronous)
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     *                           Code 101 (DATA_NOT_FOUND_ERR): The specified channel is not available.
     */
    getChannel : function(aChannel, successCB, errorCB) {
      tempSysInfo = qtSysInfoIf;
      if (aChannel=="Network" || aChannel=="SignalStrength" ||  aChannel=="BatteryLevel")
      {
        if (successCB==null)
        {
          aChannel=aChannel+"Sync";
        }
      }
        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":
            case "Network":
            case "HomeNetwork": { //Async channels

                //If callback is null then throw exception
                if ( ( successCB == null ) ){
                    throw new DeviceException( error.MISSING_ARG_ERR, "Success callback parameter missing" );
                }

                //If callback is not a function then throw an exception
                if ( typeof successCB != "function" ){
                    throw new DeviceException( error.INVALID_ARG_ERR, "Success callback parameter is not a function" );
                }

          if ( errorCB && ( typeof errorCB != "function" ) ) {
            throw new DeviceException( error.INVALID_ARG_ERR, "Error callback parameter is not a function" );
          }

                //Call to provider
          var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.getChannelAsync(aChannel);

                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
              throw new DeviceException( retVal.errCode, retVal.errMessage );
                }
                return retVal;
            }
            break;
        case "Charging":
        case "PhoneLanguage":
        case "BluetoothOn":
        case "ProductType":
        case "FirmwareVersion":
        case "IMEI":
        case "IMSI":
        case "CellularNetworkStatus":
        case "DisplayOrientation":
        case "DeviceInputMethod":
        case "CountryName":
        case "AvailableMemory":
        case "TotalMemory" :
        case "DisplayResolution":
        case "PhoneManufacturer":
        case "PhoneModel":
        case "PlatformName":
        case "SignalStrengthSync":
        case "NetworkSync":
        case "BatteryLevelSync":
        case "BacklightState":
        case "KeypadLightState":
        case "ActiveProfile":
        case "PhoneColorDepth":
        case "ClipBoard":
        case "WirelessConnSupport":
        case "SupportedVideoDecoders":
        case "DataNetworkInfo":
        case "PublicId" :{ //Sync channels
          //Call provider

          if (aChannel=="SignalStrengthSync")
            aChannel="SignalStrength";
              if (aChannel=="NetworkSync")
            aChannel="Network";
          if (aChannel=="BatteryLevelSync")
            aChannel="BatteryLevel";

          var retVal = qtSysInfoIf.getChannelSync(aChannel);

          //If error,then throw error
          if ( retVal.errCode != undefined ){
            throw new DeviceException( retVal.errCode, retVal.errMessage );
          }

          if ( aChannel == "CountryName" ) {
            if ((navigator.platform == symbianPlatform) || (navigator.platform == s60Platform)) {
               retVal.countryName = countryArr[retVal.countryName];
             }

            }

                  if ( aChannel == "DisplayResolution" ) {
                     retVal.height = parseInt(retVal.height);
                     retVal.width = parseInt(retVal.width);
                }
          //If not error, then return system data
          return retVal;
        }
        break;
        case "ListDriveInfo":{//Sync channel , but output handled differently

          var listDrives = "ListDrives";

          var retVal = qtSysInfoIf.getChannelSync(listDrives);

          //alert('after QT call'+retVal);

          if ( retVal.errCode != undefined ){
            //handle error
            alert('error from QT list drives'+ retVal.errCode +'  '+ retVal.errMessage );
          }

          var retArr = new Array();
          var listOfDrives = retVal.listOfDrives;

          for (i = 0;i < 4 ; i++)
          {
            //alert('drive letter : ' +listOfDrives[i]);
            var inpMap = {
              DriveName : listOfDrives[i]
            }
            var retInfo = qtSysInfoIf.getChannelSync(aChannel,inpMap);
            //alert('After QT call ');
            retArr[i] = retInfo;

          }
          return retArr;

        }
        case "DataNetworkInfo":{
            return {name: "Qt WRT", vendor: "Nokia", version: nokia.device.version}
        }
        break;
            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing");
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type" );
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "getChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }
    },

     /**
     * Registers for notifications from a particular channel.
     * This is an asynchronous method. If the notification for a particular
     * channel has already been registered, and subsequently a call made again,
     * then the new handler will replace the older call(s).
     * @param {function} successCB - callback function called on successful async completion
     * @param {string} aChannel - an string value
     * @param {int/object} aTrigger(optional) - trigger param
     * @param {function} errorCB - callback function called on un-successful async completion
     * @return {void}
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    startChannel : function(successCB, aChannel, aTrigger, errorCB) {

        //If callback is null then throw exception
        if ( successCB == null ){
        throw new DeviceException( error.MISSING_ARG_ERR, "Success callback parameter missing" );
            }

      //If callback is not a function then throw an exception
      if ( typeof successCB != "function" ){
        throw new DeviceException( error.INVALID_ARG_ERR, "Success callback parameter is not a function" );
            }

      if ( errorCB && ( typeof errorCB != "function" ) ){
        throw new DeviceException( error.INVALID_ARG_ERR, "Error callback parameter is not a function" );
            }


        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":{
          if ( aTrigger != undefined ){
            //If trigger is not a number,throw exception
            if ( typeof aTrigger != "number" ){
              throw new DeviceException( error.INVALID_ARG_ERR, "Trigger is not a number");
            }
            if ( ( aTrigger != -1 ) && (( aTrigger < 0 )) || ( aTrigger >= 100 )){

            throw new DeviceException( error.DATA_OUT_OF_RANGE_ERR, "Trigger Value is out of Range");
            }

          }
          else {
            //Trigger not defined
            aTrigger = -1;
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,aTrigger);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }
                return 0;
        }
        break;
        case "BluetoothOn":
        case "Charging":
          case "Network":
        case "FlipStatus":
        case "DisplayResolution":
                case "DataNetworkInfo":
                case "CellularNetworkStatus": {
          //If trigger is undefined, then proceed with -1
          if ( ( aTrigger != undefined ) && ( typeof aTrigger == "number" ) ) {
            //If trigger is a number, then its not supported for these channels - throw exception
            throw new DeviceException( error.INVALID_ARG_ERR, "Trigger not supported for this channel");
          }
          else {
            aTrigger = 0;
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,aTrigger);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }
                return 0;
            }
            break;
            case "CriticalMemory":{
          var inputData=aTrigger;
          if ( inputData == undefined ){
              throw new DeviceException( error.INVALID_ARG_ERR, "Cant find input data");
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,inputData);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
                    asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }

                return 0;
        }
        break;

            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing" );
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type" );
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "startChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }

    },

     /**
     * Stops the notifications (started by startChannel) for the channel specified.
     * This is a synchronous method.
     * @function {public var} stopChannel
     * @param {string} aChannel - an string value
     * @return {void}
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    stopChannel : function(aChannel){
        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":
        case "BluetoothOn":
        case "Charging":
            case "Network":
        case "CriticalMemory":
        case "FlipStatus":
        case "DisplayResolution":
        case "DataNetworkInfo": {
                var retVal = qtSysInfoIf.stopChannel(aChannel);
                    asyncCallbackMap.remove(transactionIdstChannel);
                //If provider call fails, then throw error
                if ( retVal.errCode != undefined ){
                    throw new DeviceException( retVal.errCode, retVal.errMessage );
                }

            return retVal;
            }
            break;
            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing");
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type");
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "stopChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }
    },

    /**
     * Cancels async requests made in getChannel
     * @param {int} aTransactionId - integer transaction id
       * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a number.<br>
     */
    cancel : function(aTransactionId){
      var found = true;
      if ( aTransactionId == null ) {
        throw new DeviceException( error.MISSING_ARG_ERR, "Transaction id param is missing");
            }
        else if ( typeof aTransactionId != "number" ) {
        throw new DeviceException( error.INVALID_ARG_ERR, "Transaction id is non a number");
        }
      else {
        var cancelObj = asyncCallbackMap.get(aTransactionId);
        if (!cancelObj){
          found = false;
        }
        if ( found ) {
            qtSysInfoIf.cancel(aTransactionId);
          asyncCallbackMap.remove(aTransactionId);
        }
        else {
          throw new DeviceException( error.INVALID_ARG_ERR, "Transaction id not found");
        }
      }

    }
        }; //End return
}
