/**
 * @author
 */
/**
 * @class
 */
nokia.device.Sensors = function PSSensorsInterface(){

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    var error = new DeviceException(0, 'dummy');
    
    
    
    function __sensor_cb(trans, error, sensorData){
    
        var obj = asyncCallbackMap.get(trans);
        
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            try {
                //Invoke consumer callback with iterator.
                callback(sensorData);
            } 
            catch (e) {
                alert(e);
            }
            
        }
        
        
    }
    
    /*
     * Internal
     * qt sensor interface object.
     */

       var qtSensorsIf = nokia._services.load("nokia.device.sensors", "com.nokia.ISensor", "1.0");
        qtSensorsIf.addEventListener("asyncCallback(int,int,QVariant)", __sensor_cb);
    
    /*
     * Internal
     * Object to map connection id to transaction id for startChannel
     */
    Notification.prototype = new Object();
    Notification.prototype.constructor = Notification;
    
    /*
     * Internal
     * Constructor for Notification
     */
    function Notification(channel, connectionId){
        this.connectionId = connectionId;
        this.channel = channel;
    }
    
    /*
     * Internal
     * Array holding Connection objects for startChannel
     */
    var notifArr = new Array();
    
    /*
     * Internal
     * Counter to hold number of startChannel calls
     */
    var notifCount = 0;
    
    return {
        /**
         * @constant {String}
         * interfaceName.
         */
        interfaceName: "sensors",
        /**
         * @constant {Number}
         * version.
         */
        version: nokia.device._interfaces['sensors'],
        /**
         * Gets the list of system information channels supported on the device.
         * This is a synchronous function.
         * @return {array} list of available channels .
         */
        getChannels: function(){
            var ret = qtSensorsIf.getChannels();
            return ret;
        },
        
        /**
         * Registers for notifications from a particular channel.
         * This is an asynchronous method.
         * @param {function} __succes_cb - callback function called on successful async completion
         * @param {string} __channel - an string value
         * @param {function} __fail_cb - callback function called on un-successful async completion
         * @return connectionID
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i>
         * <ul>
         * <li>
         * SERVICE_IN_USE_ERR : This error occurs when user try to start a channel for notification more than once.
         * </li>
         * </ul>
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined</li>
         <li>channel is undefined</i></ul><br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>channel name is of wrong type </li></ul><br>
         *                           code 3 (NOT_SUPPORTED_ERR ): <li>when specified channel name is not supported </li>
         */
        startChannel: function(__succes_cb, __channel, __fail_cb){
        
        
            if (!__succes_cb) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Callback is missing");
            
            if ((typeof __succes_cb) != "function") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Callback is of invalid type");
            
            if (__fail_cb && ((typeof __fail_cb) != "function")) 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "InValid error Callback");
            
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            
            
            
            var tid = -1;
            try {
            
                tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
                var ret = qtSensorsIf.startChannel(__channel, tid);
                if (ret["errorCode"] != 0) {
                    if (ret["errorCode"] == error.SERVICE_IN_USE_ERR) {
                        asyncCallbackMap.remove(tid);
                        setTimeout(function(){
                            __fail_cb(new DeviceAPIError(ret["errorCode"], ret["errorMessage"]));
                        }, 1000);
                        
                        return tid;
                    }
                    else {
                    
                        throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                    }
                }
                //Append notification info to array
                notifArr[notifCount++] = new Notification(__channel, tid);
                
            } 
            catch (er) {
                asyncCallbackMap.remove(tid);
                throw (er);
            }
            
            return tid;
        },
        
        /**
         * Stops the notifications (started by startChannel) for the channel specified.
         * This is a synchronous method.
         * @function {public var} stopChannel
         * @param {string} __channel - an string value
         * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.<br>
         *                           Code 4 (DATA_NOT_FOUND_ERR): This error occurs if the specified channel has already stopped giving notifications.
         */
        stopChannel: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.stopChannel(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
                //Get the connection id to be removed from list and remove it
                for (i in notifArr) {
                    if (__channel == notifArr[i].channel) {
                        var spliced = notifArr[i];
                        notifArr.splice(i, 1);
                        notifCount = notifArr.length;
                        break;
                    }
                }
                //Once done,remove the listener and invoke user callback
                
                asyncCallbackMap.remove(spliced.connectionId);
            } 
            
            catch (er) {
                throw (er);
            }
            
            return ret.errorCode;
        },
        
        /**
         * Gets the scalefactor value for the specified channel .
         * This is a synchronous method.
         * @function {public var} getScaleFactor
         * @param {string} __channel - an string value
         * @return {double}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.
         */
        getScaleFactor: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.getScaleFactor(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
            } 
            
            catch (er) {
                throw (er);
            }
            return ret.scaleFactor;
        },
        
        /**
         * Gets the channel value for the specified channel .
         * This is a synchronous method.
         * @function {public var} getChannelEvent
         * @param {string} __channel - an string value
         * @return {Object}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.
         */
        getChannelEvent: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.getChannelData(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
            } 
            catch (er) {
                throw (er);
            }
            return ret.channelData;
        }
    }
    
};
