/**
 * @author lgaur
 */
/**
 * @class
 */

nokia.device.Media = function PSMediaInterface(){
    
	var DeviceException = nokia.device.DeviceException;

    var error = new DeviceException(0,'dummy');
	
	/*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	iterator is the eventItem Iterator
     */
    function getList_cb(trans,error,iter){        
        var obj = asyncCallbackMap.get(trans);
        asyncCallbackMap.remove(trans);        
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (error) {
                if (errorCallback) {
                    errorCallback(new DeviceException(error, "Media : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback(iter);
            }
        }		
	
		
		
    }
	
	function getThumbnail_cb(arg1, arg2, arg3){
		
		var obj = asyncCallbackMap.get(arg1);		 
		 asyncCallbackMap.remove(arg1);
		 if (obj) {
		 	var __succes_cb = obj.success_cb;
			var __fail_cb = obj.error_cb;
		 	if (arg2 == 0 || arg2 == error.URI_ALREADY_EXISTS_ERR) {
		 	
		 		if (arg3) {
		 		
		 			__succes_cb(arg3);
		 		}
		 		else {
		 		
		 		
		 		
		 			if ((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function")) {
		 				__fail_cb(new DeviceException(arg2, "Media:getThumbnail:thumbnail uri is not present"));
		 			}
		 		}
		 		
		 		
		 	}
		 	else {
		 	
		 		if ((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function")) {
		 		
		 			__fail_cb(new DeviceException(arg2, "Media:getThumbnail:Operation Failed"));
		 		}
		 	}
		 }
		 
	}
	
	
	function addMusic_cb(trans,error)	{
					
					
		var obj = asyncCallbackMap.get(trans);
        asyncCallbackMap.remove(trans);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (error) {
                if (errorCallback) {
                    errorCallback(new DeviceException(error, "Media : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback();
            }
        }		
	
	
				}
	
    /*
    * Internal
    * qt media interface object.
    */
    var qtMediaIf = nokia._services.load("nokia.device.media", "com.nokia.IMedia", "1.0"); 		
		qtMediaIf.addEventListener("getListCallback(int , int , QObject* )", getList_cb);		
		qtMediaIf.addEventListener("getThumbnailCallback(int,int,QString)", getThumbnail_cb);
		qtMediaIf.addEventListener("addMusicToCollectionCallback(int,int)", addMusic_cb);
    
    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "media",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['media'],
        /**
         * Gets list of media files/ instances matching the supplied pattern.
         * This is an asynchronous API.
         *
         * Returns unique transaction id.
         * @param {Function}
         *         callback - The supplied function will be called asynchronously with an
         *         iterator of objects matching the Media file data schema.
         *         Media urls should refer to locations that are accessible to the
         *         browser or runtime engine invoking this operation.
         *         Function signature:
         *         callback({@link Iterator} of {@link MediaFileData}</i>).
         * @param {MediaFileMatchingPattern}
         *         [match] Specifies a matching filter for the media files to return. The supplied argument may be one of:
         *         <ul>
         *         <li> null or unspecified then all media files will be returned</li>
         *         <li> {@link MediaFileMatchingPattern}. can be used to specify required matching pattern.</li>
         *         </ul>
         * @param {SortOrder}
         *         [order] Sorting order. The value must be one of
         *            <a href=#ASCENDING>ASCENDING</a> or <a href=#DESCENDING>DESCENDING</a>.
         *            ASCENDING is the default.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * SERVICE_BUSY_ERR: Unable to take request now, try again later.
         * </li>
         * <li>
         * </ul>
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>mediaFileMatchingPattern  does not conform to {@link MediaFileMatchingPattern}</li>
         *                              <li>sortingOrder is not one of <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a></li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
    getList: function(__succes_cb, __match, __sort_order, __fail_cb){ 

            var connectId=-1;
            var gcret=0;
        
			if(__succes_cb == undefined || __succes_cb == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param successCallback is missing');
				}

			
        	if((typeof __succes_cb) != "function" )
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid Callback");

        	if(__fail_cb && ((typeof __fail_cb) != "function" ))
        	{
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid error Callback");
        	}

        	if((__match == undefined) || (__match == null))	
        		__match = {type:"all"};
        		
        	if((typeof __match) != "object"){
        		        	throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" + __match);	}
        	else
        		{
		
       		if( ( __match.type == undefined || __match.type == null) )
        		   throw new DeviceException(error.MISSING_ARG_ERR, "Missing Argument: type " + __match.type);
				   					
        		if( ('field' in __match) && ( __match.field == undefined || __match.field == null) )
        		   throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: field " + __match.field);
						
        		if( ('dateRange' in __match) && ( __match.dateRange == undefined || __match.dateRange == null) ){
        		 throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: date range " + __match.dateRange);}
			
			if(('dateRange' in __match) &&( __match.dateRange.start == undefined || __match.dateRange.start == null))
				throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: start in date Range " + __match.dateRange.start);

			if(('dateRange' in __match) && ( __match.dateRange.end == undefined || __match.dateRange.end == null))
				throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: start in date Range " + __match.dateRange.end);
			        		 

            if( ('sortBy' in __match) && ( __match.sortBy == undefined || __match.sortBy == null) ){

        		 throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: sortby" + __match.sortBy);}
        			        			
        		}
			        	
        	
        	if((__sort_order == undefined) || (__sort_order == null))
        		__sort_order = 0;
        	
		
        
    		if((typeof  __sort_order) != "number")
				{
				throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" +  __sort_order) ;
				
			}else if(__sort_order < 0 || __sort_order > 1 )
				{
			
				throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" +  __sort_order) ;
				}
	    	
			 
	
        	/*function __mediagetlist_cb(trans,error,iter)
        	{	
        		
        		if(trans==connectId)
        		{
        			try{
        				qtMediaIf.removeEventListener(trans);
        				
        				//Invoke consumer callback
        				if(error != 0)
        				{
        				    __fail_cb(new DeviceException(error, "getList::operation failed"));
        				}
        			    else
        			        __succes_cb(iter);
        			        
        			   }
        		    catch(er){
					
        		    }			
        		}
        	}*/
        	var tid = -1;
            try{
            	tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
				//alert(" after asyncCallbackMap"+tid);
        		//connectId = qtMediaIf.addEventListener("getListCallback(int , int , QObject* )",__mediagetlist_cb);				
        		
        		
        		//if(connectId<0)
        			//throw  new DeviceException(error.INVALID_ARG_ERR, "Connect Failed:"+connectId);
            	
				
            	gcret=qtMediaIf.getList( tid, __match,__sort_order );            	 
				if(gcret["errorCode"] != 0)
            	{			
					 
            	    throw new DeviceException(gcret["errorCode"], gcret["errorMessage"]);
            	}
        	}
        	catch(er){
        	    asyncCallbackMap.remove(tid);
        		throw new DeviceException(er.code, er.message);
        	}
        		
        	//return connectId;
			return tid;
    },

        /**
         * This method is used to get a thumbnail of the image or video.
         * This is an Asynchronous method.
         *
         * Returns unique transaction id.
         * @param {Function} callback
         *       a user-supplied callback function with the signature
         *       callback(String <i>data</i>).
         *       data is uri for the thumbnail image,
         *       The supplied function will be called asynchronously.
         * @param {ThumbnailInfo} thumbnailinfo
         *        Specifies the thumbnailInfo object which contains the uri of image or video file and size of thumbnail
         *        tobe generated.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - could be:
         * <ul><li>URI_NOT_FOUND_ERR: image or video file provided doesn't exist.</li>
         * <li>INVALID_URI_ERR: Specified uri is invalid. i.e doesn't conform to uri schema</li>
         * </ul>
         *
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined.</li><li>thumbnailInfo is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>thumbnailInfo  does not conform to {@link ThumbnailInfo} data scheme</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
    */
    getThumbnail : function(__succes_cb,thumbnailInfo, __fail_cb) {
    	
			
        	var connectId=-1;
          var gcret=0;
        	
        		if( (__succes_cb == undefined ) || (__succes_cb == null ) )
          		{
					
          			throw  new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:Callback is missing");	
        				
          		
          		}
          	else if(typeof __succes_cb != "function")	//here we check if the type of callback is function. This case is useful when arbitrary values are passed to callback
          		{
				
        			throw  new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:Callback is invalid");	
          		}
        	
			
			if((__fail_cb != undefined) &&__fail_cb && ((typeof __fail_cb) != "function" ))
        	{
			
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid error Callback");
        	}
			
			
        /*	var invoker = function(arg1, arg2, arg3) {
			
					var thumbUrl= null;
        	qtMediaIf.removeEventListener(connectId);
          if(arg2 == 0 || arg2 == error.URI_ALREADY_EXISTS_ERR )
          {
            
          if(arg3){
 
              __succes_cb(arg3); 
            }
          else
          	{
				
	         	 
	
        	if((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function"))
			 	   {
           		__fail_cb(new DeviceException(arg2,"Media:getThumbnail:thumbnail uri is not present")); 
           	   }
        	}
          	
         
         }
          else
        	{
        			
        	if((__fail_cb != undefined)&&(__fail_cb != null) &&(typeof(__fail_cb) == "function"))
        	   {
			   	
           		__fail_cb(new DeviceException(arg2,"Media:getThumbnail:Operation Failed")); 
           	   }
        		}
     }*/
          
        
        	
        	
        // Input validation
        	
        		var inputParam = new Object();
        	if (thumbnailInfo) {
		
				if (typeof thumbnailInfo != "object") {
					throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo is of invalid type object");
				}
				
				
				if (thumbnailInfo.uri) {
				
					if (typeof thumbnailInfo.uri != "string") {
				
						throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:uri is not of type string");
					}
					inputParam.uri = thumbnailInfo.uri;
					
				}
				else {
					// Throw error
					throw new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:uri is missing");
					
				}
				
				if (('size' in thumbnailInfo) && (thumbnailInfo.size == undefined || thumbnailInfo.size == null)) {
				
					
					throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: size " + thumbnailInfo.size);
				}
			
				
				
				
				if(('size' in thumbnailInfo) && (typeof thumbnailInfo.size != "object")){
				
					throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:size is not of type Object");
				}
				
				if ( thumbnailInfo.size ) {
										
					
					if ((typeof thumbnailInfo.size.width == "undefined") && (typeof thumbnailInfo.size.height == "undefined")) {
					
						throw new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:thumbnailInfo should have atleast width or height");
					}
					else {
						
						
						if( ('width' in thumbnailInfo.size) && (typeof thumbnailInfo.size.width != "number")){
					
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:width is of not number type");
						}
						//alert("Whether height is there: " + ('height' in thumbnailInfo.size) );
						if( ('height' in thumbnailInfo.size) && (typeof thumbnailInfo.size.height != "number")){
//							//alert("prob in height");
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:height is of not number type");
						}
					
						var thumbnailsize = new Object();
						//alert("width : "+ thumbnailInfo.size.width );

						if (('width' in thumbnailInfo.size) && (typeof thumbnailInfo.size.width == "number") ) // Need to put check on this
						{
							//alert("Width is:"+ thumbnailInfo.size.width );
							if ((thumbnailInfo.size.width > 0)) {
								thumbnailsize.width = thumbnailInfo.size.width;
							}else
							{
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:width is invalid value");	
							}
						}
					//	alert("Height : "+ thumbnailInfo.size.height );
					//	alert("Check : " + (thumbnailInfo.size.height >0));
						if (('height' in thumbnailInfo.size) && (typeof thumbnailInfo.size.height == "number") ){
							
							if(thumbnailInfo.size.height >0){
								thumbnailsize.height = thumbnailInfo.size.height;
							}else
							{
							//	alert("Exception for height");
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:height is invalid value");	
							}
							
						}
				
						inputParam.size = thumbnailsize;
						///alert("InputParam:  "+inputParam);
					}
					
				}
	
			
			}
        	else{
        		throw  new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:thumbnailInfo is missing");	
        		}	
				//alert(typeof thumbnailInfo.size);
        	//for thumbanilsize
        
        // adding to listener
		//alert("addEventListener calling : " +qtMediaIf);
        	
        	//alert("addEventListener Called");
			//alert("Connect Id " + connectId);
			
			//connectId = qtMediaIf.addEventListener("getThumbnailCallback(int,int,QString)",invoker);
        /*	if(connectId<0)
        	{
        		alert("connect id faield");
        		throw  new DeviceException(1, "Connect Failed:"+connectId);
        				
        	}*/
        	
        	// Input validation done
        	// 
			var tid = -1;
        	 try {    
            //__device_debug("Getting media list");
      //  alert("CAlling getThumbnail api from JS code");
	    
	 		  tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
			  //alert("after async call = "+tid);
              gcret = qtMediaIf.getThumbnail(tid ,inputParam);        	 
       
        	//alert("getthumbnail is called  " + gcret);
           	if(gcret["errorCode"] != 0)
            	{
            	    throw new DeviceException(gcret["errorCode"], gcret["errorMessage"]);
            	}
         
          }
          catch (er) {
		 
			   asyncCallbackMap.remove(tid);
          		throw new DeviceException(er.errorCode, er.errorMessage);
          }  		
		// alert("Returning user transId");
        //return connectId;
		return tid;

    },

    /**
     * This API is used to add a music file to the music collection database on the device.
		 * This is an Asynchronous API
     * Returns unique transaction id.
         * @param {Function} sCB
         *       a user-supplied callback function with the signature
         *       callback().
         *       The supplied function will be called asynchronously.
         * @param {String} uri
         *        Specifies path to the musis file.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - could be:
         * <ul><li>URI_NOT_FOUND_ERR: image or video file provided doesn't exist.</li>
         * <li>INVALID_URI_ERR: Specified uri is invalid. i.e doesn't conform to uri schema</li>
         * </ul>
         *
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined.</li><li>thumbnailInfo is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
     */
    addMusicToCollection : function(sCB, uri, eCB){
	            var connectid;
				//input validations..
				if(sCB == undefined || sCB == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param successCallback is missing');
				}
				else if((typeof sCB) != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR,'successCallback is not a function');
				}
					
				if((typeof uri) == "undefined" || uri == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter uri is missing');
				}	
				else if((typeof uri) != "string"){
					throw new DeviceException(error.INVALID_ARG_ERR,'uri param must be a string');
				}
					
				if((typeof eCB) == "undefined" || eCB == null){
					eCB = null;
				}	
				else if( eCB&& (typeof eCB) != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR,'errorCallback is not a function');
				}

				/*
				 * intermediate callback function 
				 * @param	error 	is DeviceException errror code.
				 * @param	trans	is the trasactionId
				 */
				/*function addMusic_cb(trans,error)	{	
					if( trans == connectid )
					{
						//////alert("in cb");
						qtMediaIf.removeEventListener(connectid);	
						if(error){
							if( eCB ){
							eCB(new DeviceException(error,'error occured.'));		
							}
						}
						else
						{
						sCB();	
						}
					}
				}*/
				
           try{
		   		//alert("Interface : " + qtMediaIf);
        		//connectid = qtMediaIf.addEventListener("addMusicToCollectionCallback(int,int)",addMusic_cb);
        		
        
        		//if(connectid<0)
        			//throw  new DeviceException(error.INVALID_ARG_ERR, "Connect Failed:"+connectId);
            	//alert("Calling api");
				var tid = -1;
			    tid = asyncCallbackMap.add(sCB,eCB);
            	ret = qtMediaIf.addMusicToCollection(tid,uri);				
            	//alert("Called gettList api");
				if(ret["errorCode"]!=0){		    	    
		    	    throw new DeviceException(ret.errorCode,ret.errorMessage);
		    	}
        	}
        	catch(er){
				//alert("Exception: " +er.code );
        	    //qtMediaIf.removeEventListener(connectid);
				 asyncCallbackMap.remove(tid);
        		throw new DeviceException(er.code, er.message);
        	}	
			//return transactionId.
			//return connectid;
			return tid;    	
    },
    
        /**
         * This method helps user to add streaming uri to media gallery.
         * Streaming uri is link to the server from where streaming
         * is done. This is synchronous method.
         * @param {String} uri
         *            Streaming Uri link.
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): uri is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid (only Streaming protocol is supported).
         */
        addStreamUri: function(uri){
            throw  new DeviceException(error.NOT_SUPPORTED_ERR, "addStreamUri Not Supported");
              },

        /**
         * This method helps user to delete a streaming uri from gallery.
         * This is a synchronous method. Stream uri is link to the server
         * from where streaming is done.
         * @alias MediaService.deleteStreamUri
         * @param {String} uri
         *            Streaming Uri link.
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): uri is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid (only Streaming protocol is supported).<br>
         *                              Code 101 (DATA_NOT_FOUND_ERR): uri does not exist in the gallery.
				*/
        deleteStreamUri : function(uri)
        {
            throw  new DeviceException(error.NOT_SUPPORTED_ERR, "deleteStreamUri Not Supported");
        },
        /**
         * This method is used to get a temporary resized image of the original image
         * This is a synchronous method.
         * @param {String} uri
         *       The URI of the image file to be resized.
         * @param {Object} resizeOptions
         *        width: Specifies the width of the resized image in pixels.
         *        height: Specifies the height of the resized image in pixels.
         *        [aspectRatioOption]: Specifies if aspect ratio should be maintained. 
         *        If 0, the image is scaled freely, the aspect ratio is not preserved. 
         *        If 1, the image is scaled to a rectangle as large as possible inside the size 
         *        as given, preserving the aspect ratio.
         *        If 2, the image is scaled to a rectangle as small as possible outside the size 
         *        as given, preserving the aspect ratio.
         *        The default value is 0.
         * @param {String} [destUri]
         *       The URI of the resized image provided by user. If not provided, the resized image is stored in temporary directory.
         *
         * @return {String} The URI of the resized image.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>uri is undefined.</li><li>resizeOptions is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>uri is not a string</li>
         *                              <li>resizeOptions is not a object</li>
         *                              <li>resizeOptions.width is not a number</li>
         *                              <li>resizeOptions.height is not a number</li>
         *                              <li>resizeOptions.aspectRatioOption is outside the defined values</li>
         *                              <li>destUri is not a string</li>
         *                              </ul>
         *                              Code 3 (URI_NOT_FOUND_ERR): <ul><li>The specified uri was not found</li></ul><br>
         *                              Code 4 (NOT_SUPPORTED_ERR): <ul><li>The specified file format is not supported</li></ul><br>
         *                              Code 5 (INVALID_URI_ERR): <ul><li>URI is improper</li></ul><br>
         *                              Code 6 (NOT_ALLOWED_ERR): <ul><li>Permission not granted</li></ul><br>
         *                              Code 6 (GENERAL_ERR): <ul><li>Any other processing error</li></ul><br>
		 */        
        
        resizeImage : function(uri,resizeOptions,destUri){
		//input validations.
				if(!uri){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter uri is missing');
				}	
				else if((typeof uri) != "string"){
					throw new DeviceException(error.INVALID_ARG_ERR,'uri param must be a string');
				}
				if(!resizeOptions){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter resizeOptions is missing');
				}	
				else if((typeof resizeOptions) != "object"){
					throw new DeviceException(error.INVALID_ARG_ERR,'resizeOptions param must be a object');
				}
				if(!resizeOptions.width){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter width is missing');
				}	
				else if((typeof resizeOptions.width) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'width param must be a number');
				}
				if(!resizeOptions.height){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter height is missing');
				}	
				else if((typeof resizeOptions.height) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'height param must be a number');
				}
				if(resizeOptions.aspectRatioOption && (typeof resizeOptions.aspectRatioOption) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'aspectRatioOption param must be a number');
				}
				if(resizeOptions.aspectRatioOption && resizeOptions.aspectRatioOption != 0 && resizeOptions.aspectRatioOption != 1 && resizeOptions.aspectRatioOption != 2){
					throw new DeviceException(error.INVALID_ARG_ERR,'aspectRatioOption param must be within defined values');
				}
				if (destUri && (typeof uri) != "string") {
					throw new DeviceException(error.INVALID_ARG_ERR, 'destUri param must be a string');
				}
				if(!destUri){
					destUri = "";
				}
		    ret = qtMediaIf.resizeImage(uri,resizeOptions,destUri);
			
			if(ret["errorCode"] == -1){
            	throw new DeviceException(error.URI_NOT_FOUND_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -5){
				throw new DeviceException(error.NOT_SUPPORTED_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -6){
				throw new DeviceException(error.INVALID_URI_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -46){
				throw new DeviceException(error.NOT_ALLOWED_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -2){
				throw new DeviceException(error.GENERAL_ERR, ret["errorMessage"]);
			}
			return ret["returnValue"];				
		},       
        /**
         * This method helps user to refresh/sync media database.
         * This is a synchronous method.
         * @param {String}
         *            [uri] Uri for file protocol.
         * @return {void}
         * @exception {DeviceException} Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid ((Only file protocol is supported).<br>
         *                              Code 101 (DATA_NOT_FOUND_ERR): uri does not exist in the gallery.
				*/        
        refreshMediaDb : function(uri)
        {
          //  throw  new DeviceException(error.NOT_SUPPORTED_ERR, "refreshMediaDb Not Supported");
       },

    
    /**
     * Cancels an asynchronous request identified by transactionId.
     * This is synchronous API.
     *
     * @param {number} transactionId
     *           Identifier of the ongoing asynchronous request to be canceled.
     * @return {void}
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
     *                           Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request corresponds to the specified trasactionid.
     */
    cancel: function(transactionId){
    	
				if(transactionId == undefined || transactionId == null || (typeof transactionId !== "number")){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param transactionId is missing');
				}

				if(typeof transactionId != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'mandatory param transactionId is missing');
				}
				else{
				
						return qtMediaIf.cancel(transactionId);
				
				}

	}
 
    };
}
