/**
 * @author thunga
 */
    //ensure CJSE & QT SFW namespace are created.
    if ((typeof nokia) == 'undefined') {
       /**
        * @namespace
        */
        nokia = {};
        /**
        * @namespace
        */
        nokia.device = {};
        nokia._services = {};
    }
    else {
        if ((typeof nokia._services) == 'undefined') {
            nokia._services = {};
        }
        if((typeof nokia._services) == 'undefined'){
            nokia.device = {};
        }
    }

nokia._services = (function(){
    var error = null;
    /*
     * Implemention of nokia._services.load method 
     * 
     * @function {public object} _sfw_service_load
     * @param {string} serviceName service name of requested service
     * @param {string} interfaceName interface name of requested service
     * @param {string} version version of requested service
     * @returns service object
     */
    function _sfw_service_load(serviceName, interfaceName, version){
        //ensure qt nokia._services is been intialised.
      /*  function init_callback(){
            // Setup the nokia.factory
            nokia.factory = document.getElementById("serviceFactory");
        };
        nokia._services.init(init_callback);
        */
        var DeviceException = nokia.device.DeviceException;
        if(!error)
            error = new DeviceException('dummy',0);
        createFactoryObject();
        
        try {
            var so = nokia.factory.getServiceObject(serviceName, interfaceName);
            return so;
        }
        catch (e) {
            sfw_debug(serviceName + " " + interfaceName + " not available:"+e);
            throw new DeviceException(error.DATA_NOT_FOUND_ERR,"failed to load requested service interface, enabler not found or access restricted");
        }
    }
    
    /*
     * Implemention of the nokia._services.listServices method
     * 
     * @function {public array} _sfw_service_list
     * @returns list of registered services
     */
    function _sfw_service_list()
    {
        try {
            createFactoryObject();
            var l = nokia.factory.getServiceProviders(); 
            return l;  
        }
        catch (e){
            sfw_debug("Test service not available");
            return null;
        }
    }

    /*
     * 
     */
    function _sfw_service_init(callback) {
        try {
            createFactoryObject();
            
            // Automatically callback to client after 1 MS
            setTimeout(callback, 1 );
        }
        catch(ex) {
            sfw_debug(ex);
        }
    }
    
    /*
     * @var {bool} sfw_debug_on is ture if in debug mode
     */
    var sfw_debug_on = false;
    
    /*
     * @function {public void} sfw_debug if sfw_debug_on = true alert the input message
     * @param {string} message 
     */
    function sfw_debug(message)
    {
        if (sfw_debug_on) {
            alert(message);
        }
    }

    /*
     * Sleep for milliseconds
     * 
     * @function {public void} pausecomp
     */
    function pausecomp(millis) {
        var date = new Date();
        var curDate = null;
        do { 
            curDate = new Date(); 
        } while(curDate-date < millis);
    }
    
// Fix to improve performance in Converting QVariants to NP Objects.    
    
function __newObject(){
   return new Object();
};

function __newArray(){
   return new Array();
};

function __newDate(){
   return new Date();
};
    
    /*
     * Creates a factory object and embeds it to html file
     * 
     * @function {public object} createFactoryObject
     * @returns factory plugin 
     */
    function createFactoryObject() {
        var factory = document.getElementById("serviceFactory");
        //plugin is not embeded yet
        if (!factory) { 
            //embed plugin in a div node to html file
            var newdiv = document.createElement('div');
            newdiv.id = "factoryDiv";
            newdiv.innerHTML = '<embed  id="serviceFactory" type="application/x-sfw-plugin" height="0" hidden=true > </embed>';
            if(document.body)
               document.body.insertBefore(newdiv, document.body.firstChild);
            else
               document.getElementsByTagName('html').item(0).appendChild( newdiv );
        
            // Setup the nokia.factory
            nokia.factory = document.getElementById("serviceFactory");
	    // Call this again to execute else case
	    setTimeout(createFactoryObject, 1 );
        }
        else {
            // If the client already has the plugin embedded
            nokia.factory=factory;
            nokia.factory.SFW_CreateJSObject(__newObject,__newArray,__newDate);
        }
    }
    return{
        load : _sfw_service_load,
        listServices: _sfw_service_list,
        init:_sfw_service_init,
        version: "0.1",
        info: "Service Framework",
        factory: null       
    };
})();


//Map CJSE F/W methods to this namespace.
/**
 * The Nokia FRAMEWORK API 2.0 consists of a collection of methods, that can be
 * used to query and load available services and interfaces. 
 *
 * @namespace
 */
nokia.device = (function(){

   var cjse_interfaces = [];

    function _ps_list_interfaces(){
        function __FWIter(arr)  {
            this._arr = arr;
            this._pos = 0;
            this._valid = true;
            
            this.hasNext = function() {
                return (this._valid && this._pos < this._arr.length)
            };
            
            this.next = function() {
                if(this._valid && (this._pos < this._arr.length)){
                    return this._arr[this._pos++];
                }
                else{
                    return null;
                }
            };
            
            this.close = function(){
                delete this._arr;
                this._valid = false;
            }
        }

        if(!cjse_interfaces.length || !nokia.device._interfaces){
            var services = nokia._services.listServices();
            nokia.device._interfaces = {};
            for(i=0;i<services.length;i++)
            {
                if(services[i].toLowerCase().lastIndexOf('nokia.device.') != -1){
                    var cjse_interface = services[i].split('nokia.device.')[1];
                    var version = 0;
                    var version_txt = nokia.factory.getServiceVersion(services[i]);
                    var splits = version_txt.split('.');
                    if(splits.length>1) {
                        version = parseFloat(splits[0].concat('.'+splits[1]));
                    }else   {
                        version = parseFloat(version_txt);
                    }
                    
                    cjse_interfaces.push({name:cjse_interface,version:version});
                    nokia.device._interfaces[cjse_interface] = version;
                }
            }
        }
    
        return new __FWIter(cjse_interfaces);  
    }
    
    return{
        /**
        * @memberOf nokia.device
        * @description interfaces internal 
        */
        _interfaces: null,

        /**
         * @memberOf nokia.device
         * @constant 
         * @description Nokia FRAMEWORK API version number 
         */
        version: 2.1,
        /**
         * @memberOf nokia.device
         * @function 
         * Method loads an instance of a device service interface.
         * @param {string}    serviceName A fully qualified name or a regular 
         * expression to match against the service name.
         * @param {string}    interfaceName A fully qualified name or a regular 
         * expression to match against the interface name.
         * @param {string}    version string representing the 
         * interface version number. Matches if the supported version is equal 
         * to or larger than the supplied version.
         * @return {object}   serviceObject 'so'
         */
        load : function(interfaceName, version){
        var DeviceException = nokia.device.DeviceException;
        var error = new DeviceException('dummy',0);

        if(interfaceName){
            if(typeof interfaceName != 'string'){
                throw new DeviceException(error.INVALID_ARG_ERR, 'nokia.device.load:Invalid type interfaceName');
            }
        }else{
            throw new DeviceException(error.MISSING_ARG_ERR, 'nokia.device.load:interfaceName param expected');
        }
        if(version){
            if(typeof version != 'number'){
                throw new DeviceException(error.INVALID_ARG_ERR, 'nokia.device.load:Invalid type version');
            }
        }

        if (!nokia.device._interfaces){
           _ps_list_interfaces();
        }

       var so =  _load_ps_interface(interfaceName);
       return so;


            function _load_ps_interface(interfaceName){
                var interfaceToClass = { "contacts":"Contacts","calendar":"Calendar","media":"Media","filesystem": "FileSystem","commlog": "CommLog","camera": "Camera","geolocation": "Geolocation", "messaging": "Messaging","sysinfo": "Sysinfo","sensors": "Sensors","landmarks": "Landmarks", "telephony": "Telephony","connectionmgt": "ConnectionManagement","appmgt": "AppMgt","audioplayer": "AudioPlayer"};
                if(nokia.device[interfaceToClass[interfaceName]]){
                    return (nokia.device[interfaceName] = nokia.device[interfaceName] || new nokia.device[interfaceToClass[interfaceName]]());
                }
                else{
                    throw new DeviceException(error.DATA_NOT_FOUND_ERR,"failed to load requested service interface, interface not found");
                }
            }
        },
        /**
         * @memberOf nokia.device
         * @function
         * Method gets the list of the available interfaces of a given service.
         * @param {string}            interfaceName
         * @return{Iterator of InterfaceInfo}   array of InterfaceInfo  object's.
         */
        listInterfaces: _ps_list_interfaces,
        /**
         * @memberOf nokia.device
         * @function
         * Method gets the list of the available interfaces of a given service.
         * @param {string}            interfaceName
         * @return{Iterator of InterfaceInfo}   array of InterfaceInfo  object's.
         */
        getSystemProperties: function (){
        return {
                uriPath:{
                    // maximum limitation is 255 charectors
                    max:255
                }
            };
        },
        /**
         * @memberOf nokia.device
         * @function
         * Method gets javascript library version.
         * @return{Number}   Library version.
         */
        getLibraryVersion: function (){
            return 3.0;
        }
    };
})();


/**
 * A class for exceptions that Nokia JS APIs may throw,
 * DeviceException is a subclass of Error. DeviceException extends Error by adding the code property.
 * @class
 * The code proeperty of DeviceException instances store a numeric value, an error code, that represents
 * the cause of the exception. The numberic values are associated with codified strings, that may
 * be present in the message property of a DeviceException instance. 
 * <ul>
 * <li>Code range 1-49, is reserved for generic non-recoverable errors.</li>
 * <li>Code range 50-99, is reserved for domain specific non-recoverable errors. 
 *     An error code in one domain might have a different meaning in another domain.</li> 
 * <li>Code range 100-499 is reserved for generic recoverable errors.</li>
 * <li>Code range &gt;= 500 is reserved for domain specific recoverable errors. An error code in 
 *     one domain might have a different meaning in another domain.</li>
 * </ul>
 *
 * The following two tables display the error codes.
 * <br><br>
 * <b>Generic non-recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>MISSING_ARG_ERR</td><td>1</td><td>If a mandatory argument in a method is missing.</td></tr>
 * <tr><td>INVALID_ARG_ERR</td><td>2</td><td>If argument pass is of different type as is expected.</td></tr>
 * <tr><td>NOT_SUPPORTED_ERR</td><td>3</td><td>In case method not available in this Interface.<br><br>
 * In case a data schema element is platform specific and a platform doesn’t support.</td></tr>
 * </table>     

 * <b>Generic recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>TIMEOUT_ERR</td><td>100</td><td>This error can use when underlying implementation 
 *         could not give response with in a given time. Eg. getLocation method</td></tr>
 * <tr><td>DATA_NOT_FOUND_ERR</td><td>101</td><td>Referred data entry not found. Check UID.</td></tr>
 * <tr><td>DATA_ALREADY_EXISTS_ERR</td><td>102</td><td>Referred data entry exists already (duplicate item)</td></tr>
 * <tr><td>SERVICE_BUSY_ERR</td><td>103</td><td>Service is busy. Unable to take request now, try again later.</td></tr>
 * <tr><td>SERVICE_IN_USE_ERR</td><td>104</td><td>If user tries to register for notifications more that once. 
 *          calling traceLocation twice with calling clearTrace</td></tr>
 * <tr><td>DATA_OUT_OF_RANGE_ERR</td><td>105</td><td>If Invalid value is passed typically out of range value.</td></tr>
 * <tr><td>NOT_ALLOWED_ERR</td><td>106</td><td>If user doesn’t have permission to access specified content.
 *         Eg. DRM file or files inside private folders.</td></tr>
 * <tr><td>SIZE_EXCEEDED_ERR</td><td>107</td><td>Data exceeded allowed limits set by a platform 
 *         or by a configuration. Typically data overflow error.</td></tr>
 * <tr><td>INVALID_URI_ERR</td><td>108</td><td>Specified uri is invalid. i.e. doesn’t conform to uri schema</td></tr>
 * <tr><td>URI_NOT_FOUND_ERR</td><td>109</td><td>Specified uri refers to non existing resource.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>110</td><td>Specified uri refers to existing resource. 
 *         Typically this error code used to protect destination resource not been overwritten.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>111</td><td>Specified uri refers to existing resource. 
 *         In case device runs out of mememory while performing the operation.</td></tr>
 * </table> 
 * @param {number} code A code number for the cause of the exception.
 * @param {string} message A free-form message explaining why this exception is thrown.
 * @return DeviceException 
 */
nokia.device.DeviceException = function(code,message)    {

        /**
        * The name of the Error, will always be DeviceAPIError
        */
        this.name    = 'DeviceException';
        /**
        * A message describing the error in a human-readable way.
        */
        this.message = message;
        /**
         * Exception cause as a code number. Values in the range 1-99 indicate
         * non-recoverable errors, and values >= 100 indicate recoverable errors.
         */
        this.code    = code;
        this.MISSING_ARG_ERR            = 1;
        this.INVALID_ARG_ERR            = 2;
        this.NOT_SUPPORTED_ERR          = 3;
        this.TIMEOUT_ERR                = 100;
        this.DATA_NOT_FOUND_ERR         = 101;
        this.DATA_ALREADY_EXISTS_ERR    = 102;
        this.SERVICE_BUSY_ERR           = 103;
        this.SERVICE_IN_USE_ERR         = 104;
        this.DATA_OUT_OF_RANGE_ERR      = 105;
        this.NOT_ALLOWED_ERR            = 106;
        this.SIZE_EXCEEDED_ERR          = 107;
        this.INVALID_URI_ERR            = 108;
        this.URI_NOT_FOUND_ERR          = 109;
        this.URI_ALREADY_EXISTS_ERR     = 110;      
        this.NO_MEMORY_ERR              = 111;
        this.DIR_NOT_EMPTY_ERR          = 500;
        this.FILE_ALREADY_OPEN_ERR      = 501;
        this.URI_NOT_SUPPORTED          = 502;
        this.CONNMGR_UNKNOWN_SESSION_ERROR      = 503;
        this.CONNMGR_SESSION_ABORTED_ERROR      = 504;
        this.CONNMGR_ROAMING_ERROR              = 505;
        this.CONNMGR_OPERATION_NOTSUPPORTED_ERR = 506;
        this.CONNMGR_NO_CONFIGURATION_ERROR     = 507;
    }

nokia.device.DeviceException.prototype = new Error();

nokia.device.DeviceException.prototype.constructor = nokia.device.DeviceException;

nokia.device.DeviceException.prototype.toString = function(){
    return(this.name + " : " + this.code + " : " + this.message);
};


/**
 * A class for handling errors in errorCallback functions.
 * DeviceAPIError extends Error by adding the code property.
 * @class
 * The code proeperty of DeviceAPIError instances store a numeric value, an error code, that represents
 * the cause of the exception. The numberic values are associated with codified strings, that may
 * be present in the message property of a DeviceException instance. 
 * <ul>
 * <li>Code range 100-499 is reserved for generic recoverable errors.</li>
 * <li>Code range &gt;= 500 is reserved for domain specific recoverable errors. An error code in 
 *     one domain might have a different meaning in another domain.</li>
 * </ul>
 *
 * The following table display the error codes.
 * <b>Generic recoverable exception codes</b>
 * <table><tr><td>Cause</td><td>Value</td><td>Description</td></tr>
 * <tr><td>TIMEOUT_ERR</td><td>100</td><td>This error can use when underlying implementation 
 *         could not give response with in a given time. Eg. getLocation method</td></tr>
 * <tr><td>DATA_NOT_FOUND_ERR</td><td>101</td><td>Referred data entry not found. Check UID.</td></tr>
 * <tr><td>DATA_ALREADY_EXISTS_ERR</td><td>102</td><td>Referred data entry exists already (duplicate item)</td></tr>
 * <tr><td>SERVICE_BUSY_ERR</td><td>103</td><td>Service is busy. Unable to take request now, try again later.</td></tr>
 * <tr><td>SERVICE_IN_USE_ERR</td><td>104</td><td>If user tries to register for notifications more that once. 
 *          calling traceLocation twice with calling clearTrace</td></tr>
 * <tr><td>DATA_OUT_OF_RANGE_ERR</td><td>105</td><td>If Invalid value is passed typically out of range value.</td></tr>
 * <tr><td>NOT_ALLOWED_ERR</td><td>106</td><td>If user doesn’t have permission to access specified content.
 *         Eg. DRM file or files inside private folders.</td></tr>
 * <tr><td>SIZE_EXCEEDED_ERR</td><td>107</td><td>Data exceeded allowed limits set by a platform 
 *         or by a configuration. Typically data overflow error.</td></tr>
 * <tr><td>INVALID_URI_ERR</td><td>108</td><td>Specified uri is invalid. i.e. doesn’t conform to uri schema</td></tr>
 * <tr><td>URI_NOT_FOUND_ERR</td><td>109</td><td>Specified uri refers to non existing resource.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>110</td><td>Specified uri refers to existing resource. 
 *         Typically this error code used to protect destination resource not been overwritten.</td></tr>
 * <tr><td>URI_ALREADY_EXISTS_ERR</td><td>111</td><td>Specified uri refers to existing resource. 
 *         In case device runs out of mememory while performing the operation.</td></tr>
 * </table> 
 * @param {number} code A code number for the cause of the exception.
 * @param {string} message A free-form message explaining why this exception is thrown.
 * @return DeviceAPIError 
 */
nokia.device.DeviceAPIError = function (code,message)    {
        /**
        * The name of the Error, will always be DeviceAPIError
        */
        this.name    = 'DeviceAPIError';
        /**
        * A message describing the error in a human-readable way.
        */
        this.message = message;
        /**
         * Exception cause as a code number. Values in the range 1-99 indicate
         * non-recoverable errors, and values >= 100 indicate recoverable errors.
         */
        this.code    = code;
        this.MISSING_ARG_ERR            = 1;
        this.INVALID_ARG_ERR            = 2;
        this.NOT_SUPPORTED_ERR          = 3;
        this.TIMEOUT_ERR                = 100;
        this.DATA_NOT_FOUND_ERR         = 101;
        this.DATA_ALREADY_EXISTS_ERR    = 102;
        this.SERVICE_BUSY_ERR           = 103;
        this.SERVICE_IN_USE_ERR         = 104;
        this.DATA_OUT_OF_RANGE_ERR      = 105;
        this.NOT_ALLOWED_ERR            = 106;
        this.SIZE_EXCEEDED_ERR          = 107;
        this.INVALID_URI_ERR            = 108;
        this.URI_NOT_FOUND_ERR          = 109;
        this.URI_ALREADY_EXISTS_ERR     = 110;
        this.NO_MEMORY_ERR              = 111;
        this.DIR_NOT_EMPTY_ERR          = 500;
        this.FILE_ALREADY_OPEN_ERR      = 501;
        this.URI_NOT_SUPPORTED          = 502;              
    };

nokia.device.DeviceAPIError.prototype = new Error();

    
nokia.device.DeviceAPIError.prototype.toString = function(){
    return(this.name + " : " + this.code + " : " + this.message);
};
		
var asyncCallbackMap = {
	usec_count:0,
	callbackArray: new Array(),
	getTransactionId: function(){
		var KHrs=24,KMin=60,KSec=60,KMcSec=1000;
		var currentTime = new Date();
		this.usec_count++;
		/*return   ((KMcSec * KHrs * KMin * KSec * currentTime.getDate())+
		(KMcSec * KMin * KSec * currentTime.getHours())+ 
		(KMcSec * KSec * currentTime.getMinutes())+
		(KMcSec * currentTime.getSeconds()) +*/
		return this.usec_count;
	},
	add: function(sCb, errCb,options){
		var obj = new Object();
        obj.success_cb = sCb;
		obj.error_cb = errCb;
		obj.options = options;
        obj.transactionId = this.getTransactionId();        
        this.callbackArray.push(obj);
		return obj.transactionId;
	},
	get: function(tid){
		var i = this.callbackArray.length -1;
        for (; i >= 0; i--) {
            if (this.callbackArray[i].transactionId == tid) {
                return this.callbackArray[i];
            }
        }
        return null;
	},
	remove: function(tid){
		var i = this.callbackArray.length -1;
        for (; i >= 0; i--) {
            if (this.callbackArray[i].transactionId == tid) {
                this.callbackArray.splice(i, 1);
            }
        }
	}
	
};
/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/**
 * @class
 */ 

nokia.device.Calendar = function PSCalendarInterface(){
    
	var DeviceException = nokia.device.DeviceException;
	var DeviceAPIError = nokia.device.DeviceAPIError;
	var notifyTid = null;
	
	var MISSING_ARG_ERR = 1;
	var INVALID_ARG_ERR = 2;
	var NOT_SUPPORTED_ERR = 3;
	
	
	var KErrArgument = -6;
	var KErrGeneral = -2;
	var KErrNotSupported = -5;
	
	var /*const causes rhino to fail */ CALENDAR_APP_ID = 0x10005901;
	
	//multiply the error codes by -1 before using this map
	
	var MapErrorCode = { 
	    33: 100, //KErrTimedOut
	    1: 101,//KErrNotFound
	    11: 102, //KErrAlreadyExists
	    16: 103,//    KErrServerBusy
	    14: 104, //KErrInUse    
	    21: 106, //KErrAccessDenied
	    4: 107, //KErrNoMemory
	    2: 2, // KErrGeneral - mapped to default ,
	    5: 3, //KErrNotSupported
	    6: 2, //KErrArgument
	    105: 105 //KDataRangeErr 
	}

    var error = new DeviceException(0,'dummy');
	
	function filterUndefined(obj){
        if(typeof obj === "object"){
            for(var key in obj) {
                if(typeof obj[key] === "undefined"){
                    delete obj[key];
                } 
                if(typeof obj[key] === "object"){
                    filterUndefined(obj[key]);
                }
            }	
        }
        return obj;
    }
	
	var __sp_calendar_entry_types = "MeetingReminderToDoAnniversaryDayEvent";
	
	function __sp_calendar_handle_error(errorCallback, errorCode){

	    if ((errorCallback != undefined) && (typeof errorCallback == 'function') && (errorCallback != null)) {
	       
	       
		    var retPosErr;
	        
	        switch (errorCode) {
	            case 100: //KErrTimedOut
	                retPosErr = new DeviceAPIError(error.TIMEOUT_ERR, "The implementation can not give a response within the given time");
	                break;
	                
	            case 101://KErrNotFound
	                retPosErr = new DeviceAPIError(error.DATA_NOT_FOUND_ERR, "Referred data entry was not found");
	                break;
	                
	            case 102: //KErrAlreadyExists
	                retPosErr = new DeviceAPIError( error.DATA_ALREADY_EXISTS_ERR,"Referred data entry already exists");
	                break;
	                
	            case 103: //    KErrServerBusy
	                retPosErr = new DeviceAPIError(error.SERVICE_BUSY_ERR , "The service is busy.Unable to process the request now, try again later");
	                break;
	                
	            case 104: //KErrInUse
	                retPosErr = new DeviceAPIError(error.SERVICE_IN_USE_ERR, "Registering for notifications is supported only once");
	                break;
	                
	            case 106: //KErrAccessDenied
	                retPosErr = new DeviceAPIError( error.NOT_ALLOWED_ERR, "No permission to access the specified content");
	                break;
	                
	            case 107: //KErrNoMemory
	                retPosErr = new DeviceAPIError(error.SIZE_EXCEEDED_ERR, "Data size exceeded the limits set by the platform or by the configuration");
	                break;
	            
		   		case 105: //DATA_OUT_OF_RANGE
					retPosErr = new DeviceAPIError(error.DATA_OUT_OF_RANGE_ERR, "Data supplied is out of range");
	                break;
					
	            default: 
	                retPosErr = new DeviceAPIError(-2 ,"General error");
	                break;
	        }
	        
	        
	        //Invoke user supplied error callback
	        errorCallback(retPosErr);
			return;
	        
	    }
	    //if errorCallabck is not supplied or it's not a valid one just ignore the error
	}

	/*
	 * Validate the data type of input params
	 * returns "true" if all data types are valid, else "false"
	 */
	function _isInputValid(__matchCrit){
	
        /* 
         * getlist/delete match criteria
         */
	
		if (__matchCrit != null) {
			if (__matchCrit.id != null) {
				if (typeof(__matchCrit.id) != "string") {
		
					return false;
				}
			}
			
			if (__matchCrit.type != null) {

				if ((typeof(__matchCrit.type) != "string") || !__sp_calendar_entry_types.match(__matchCrit.type)) {
					return false;
				}
			}
			
			if (__matchCrit.text != null) {
				if (typeof(__matchCrit.text) != "string") {
	
					return false;
				}
			}
			
			
			if (__matchCrit.range != null) {
				if (__matchCrit.range && typeof(__matchCrit.range) != "object") {
	
					return false;
				}
				
				if (__matchCrit.range.begin != null) {
					if (typeof(__matchCrit.range.begin) != "object") {
						return false;
					}
				}
				
				if (__matchCrit.range.end != null) {
					if (typeof(__matchCrit.range.end) != "object") {
					
						return false;
					}
				}
				
			}
			
			
			/*
			 * addEntry/updateEntry input ,  id and type checked above
			 */
			if (__matchCrit.summary != null) {
				if (typeof(__matchCrit.summary) != "string") {
					return false;
				}
			}
			
			if (__matchCrit.description != null) {
				if (typeof(__matchCrit.description) != "string") {
					return false;
				}
			}
			
			
			if (__matchCrit.status != null) {
			
				if (typeof(__matchCrit.status) != "string") {
					return false;
				}
				
			}
			
			
			if (__matchCrit.location != null) {
				if (typeof(__matchCrit.location) != "string") {
					return false;
				}
			}
			
			if ( __matchCrit.priority != null) {
				if (typeof(__matchCrit.priority) != "number") {
					return false;
				}
			}
			
			if (__matchCrit.instanceStartTime != null) {
				if (typeof(__matchCrit.instanceStartTime) != "object") {
					return false;
				}
			}
			
			if (__matchCrit.exceptionDates != null) {
				if (typeof(__matchCrit.exceptionDates) != "object") {
					return false;
				}
			}
			
			if (__matchCrit.time != null) {
				if(typeof __matchCrit.time != 'object')
				{
					return false;
				}
					var validDate = new Date("January 1, 1970 00:01"); 
					 
			
				if (__matchCrit.time.begin != null) {
				
					if (typeof(__matchCrit.time.begin) != "object") {
					
						return false;
					}
					if ((__matchCrit.time.begin) < validDate) {
						return false;
					}
				}
				
				if (__matchCrit.time.end != null) {
				
					if (typeof(__matchCrit.time.end) != "object") {
					
						return false;
					}
					var validDate = new Date("January 01, 1970 00:01");
					if((__matchCrit.time.end) < validDate ){
						return false;
					}
				}
				
				if (__matchCrit.time.alarm != null) {
				
					if (typeof(__matchCrit.time.alarm) != "object") {
					
						return false;
					}
				}
				if((__matchCrit.time.end) && (__matchCrit.time.alarm)){
					if((__matchCrit.time.end) < (__matchCrit.time.alarm)){
						return false;
					}
				}
			}
			
			if (__matchCrit.repeatRule != null) {
				if(typeof __matchCrit.repeatRule != 'object')
				{
					return false;
				}
				
				if ( __matchCrit.repeatRule.frequency != null )
				{
					if (typeof(__matchCrit.repeatRule.frequency) != "string") {
						return false;
					}
				}
			
				if ( __matchCrit.repeatRule.startDate != null )
				{
			
					if (typeof(__matchCrit.repeatRule.startDate) != "object") {
						return false;
					}
				}
				
				if ( __matchCrit.repeatRule.untilDate != null )
				{
					if (typeof(__matchCrit.repeatRule.untilDate) != "object") {
						return false;
					}
				}
				if ( __matchCrit.repeatRule.interval != null )
				{
					if (typeof(__matchCrit.repeatRule.interval) != "number") {
						return false;
					}
				}
				
				if ( __matchCrit.repeatRule.month != null )
				{
					if (typeof(__matchCrit.repeatRule.month) != "number") {
						return false;
					}
				}
				
				if ( __matchCrit.repeatRule.weekDays != null )
				{
					if (typeof(__matchCrit.repeatRule.weekDays) != "object") {
						return false;
					}
				}
				
				if ( __matchCrit.repeatRule.daysOfMonth != null )
				{
					if (typeof(__matchCrit.repeatRule.daysOfMonth) != "object") {
						return false;
					}
				}
				if ( __matchCrit.repeatRule.monthDates != null )
				{
					if (typeof(__matchCrit.repeatRule.monthDates) != "object") {
						return false;
					}
				}
				
			}
		}
    
    	return true;
	}
	
	

	
    /*
    * Internal
    * qt calender interface object.
    */

    var qtCalendarIf = nokia._services.load("nokia.device.calendar", "com.nokia.ICalendar", "1.0");
        
    qtCalendarIf.addEventListener("getListCallback(int,int,QObject*)", getList_calendar_cb);
    qtCalendarIf.addEventListener("notifyCallback(int,int,QObject*)", setNotification_cb);

     /*
     * Calendar getList callback handler
     */
    function getList_calendar_cb(errCode, transId, result){
    
        
		var retObj = asyncCallbackMap.get(transId);
		
		asyncCallbackMap.remove(transId);
        
        if (!retObj) {
            alert('asyncReqObj.get error');
            return;
        }
        var callback = retObj.success_cb;
        var errorCallback = retObj.error_cb;
        if (errCode) {
			if(errCode == -6)
			{
				//INVALID_ARG(-6) error should be returned as DATA_OUT_OF_RANGE(105) error for getList
				__sp_calendar_handle_error(errorCallback, 105 );
				return;
			}
            __sp_calendar_handle_error(errorCallback, MapErrorCode[(errCode * -1)]);
            return;
        }
	callback(result);
    }
 
     /*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	result is the eventData
     */
    function setNotification_cb(errCode, transId, result){
        var retObj = asyncCallbackMap.get(transId);
        if (retObj) {
            var callback = retObj.success_cb;
            var errorCallback = retObj.error_cb;
            if (errCode) {
                if (errorCallback) {
                    __sp_calendar_handle_error(errorCallback, MapErrorCode[(errCode * -1)]);
                }
            }
            else {
                //Invoke consumer callback with result.
                callback(result);
            }
        }
    }

   
    return {
    /**
    * @constant {String} 
    * interfaceName.
    */		
	interfaceName: "calendar",
    /**
    * @constant {Number} 
    * version.
    */      
    version: nokia.device._interfaces['calendar'],
    /**
     * Gets an iterator of calendar entries matching the supplied pattern.
     * This has both synchronous and asynchronous behaviour.
     * <br><br>
     * The output returned by this method depends on the filter criteria that can optionally
     * be passed with the <i>match</i> parameter, which is an instance of the
     * data scheme {@link MatchPattern}.
     * <br><br>
     * The contents of the {@link MatchPattern} instance will guide <i>getList()</i> as follows:
     * <br><br>
     * A calendar entry has an unique identifier, the id property, for entry identification.
     * If the id property is specified, entries matching this id will be returned,
     * in this case the other filter parameters will be ignored.
     * If id is not specified, the contents of the {@link MatchPattern} instance is interpreted as follows:
     * <ul>
     * <li>If the range property is specified, returns the instances falling within that range.
     *      In case both begin and end range are not specified, it returns all instances present
     *      in the calendar. </li>
     * <li>In case the text propety is specified, returns the instances matched with the summary field of the entry.
     *      The match is not case sensitive.</li>
     * <li>The type property can be used if only instances of a particular type are needed.</li>
     * </ul>
     * In case of instance search i.e. when id is not specified, the begin and end range refers to
     * instances falling within this range. In case of sync, first parameter will be matchPattern
     * <br><br>
     * The <i>matchPattern</i> parameter is optional. If it is not present, then all instances are returned.

     * @param {matchPattern} [match] Specifies a matching filter for the entries to return.The supplied argument may be one of:
     *                 <ul><li><i>null</i> or <i>undefined</i> to match all instances</li>
     *                 <li>an {@link MatchPattern} instace for getting a restricted set of {@link CalendarEntry} instances.</li></ul>
     *
     * @param {function} successCB A callback function with the signature
     *                     <i>function({@link Iterator} of {@link CalendarEntry})</i>
     *                     The iterator will iterate instances of {@link CalendarEntry}, which represent
     *                     calendar entries that match match pattern.
     *
     * @param {function} [errorCB(DeviceError)] This callback function gets invoked with
     * {@link DeviceError} object when error occurs in processing the async request.
     * <i>function(DeviceError)</i>
     * <i>{@link DeviceError}</i> - one of the errors:
     *
     * <br><br>
     * <b>Status Codes</b> are the codes returned in errorCallback function in DeviceError object.<br>
     * <br>
     *              Code 103 (DATA_NOT_FOUND_ERR): id specified does not exist.<br>
     *              Code 106 (DATA_OUT_OF_RANGE_ERR): Invalid value/out of range values passed for any of the parameters.<br>
     *              <br>
     *
     * @return {number/(iterator:calendarentry)} Unique transactionId will be returned.<br> In case of Synchrous invocation the iterator of calendar entries/ instances matching the supplied pattern will be returned instead of TransactionId.<br><br><br>
     *
     *
     * <b> NOTE: </b>{number} <b>nokia.device.calendar.getList (successCB, match, errorCB(DeviceError))</b> signature is also supported at present, but it will deprecated in future.
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): A mandatory argument in a method is missing.<br>
     *                              Code 2 (INVALID_ARG_ERR): Invalid value/out of range values passed for any of the parameters.
     *                              <ul>
     *                              <li>successCB is not a function</li>
     *                              <li>match - does not conform to the {@link MatchPattern} data schema</li>
     *                              <li>errorCB is not a function</li>
     *                              </ul>
     *
     *
     *
     */
    getList: function(callback, matchPatternVal, errorCallback){ 
    
                filterUndefined(matchPatternVal);
                
                var isSync = false;
                var matchPattern;
                
                if (!callback && !matchPatternVal) {
                    //Sync
                    isSync = true;
                }
                else 
                    if (callback && (typeof(callback) != 'function') && !matchPatternVal) {
                        //Sync
                        isSync = true;
                    }
                else {
                    //Async
					
                    if (typeof(matchPatternVal) == 'function') {
                        //new style						
			matchPattern = callback;
                        callback = matchPatternVal;                        						
                    }
                    
                    else 
                        if (typeof(callback) == 'function') {
                            //old style                            						
                            matchPattern = matchPatternVal;
                        }
                        
                        else {
                            //Invalid Type error
                            throw new DeviceException(error.INVALID_ARG_ERR, "Calendar : getList : param order is invalid");
                        }
                }
	    if (isSync) {
	        //input validations..
	        matchPattern = callback;
		
	        if (matchPattern != null) {
			    if ((typeof matchPattern) != "object") {
			        throw new DeviceException(error.INVALID_ARG_ERR, "Calendar : getList : matchPattern is invalid");
			    }
			}
	    }
	    else{
                    
	       //input validations..
	        if (callback == "undefined" || callback == null) {
	            throw new DeviceException(error.MISSING_ARG_ERR, "Calendar : getList : callback is missing");
	        }
	        else 
	            if ((typeof callback) != "function") {
	                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar : getList : callback is invalid");
	            }
	 
	        if( matchPattern != null ) {
	            if ((typeof matchPattern) != "object") {
	                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar : getList : matchPattern is invalid");
	            }			
			}
	        
	        if ((typeof errorCallback) == "undefined" || errorCallback == null) {
	            errorCallback = null;
	        }
	        else 
	            if (errorCallback && (typeof errorCallback) != "function") {
	                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar : getList : errorCallback is not a function");
	            }		
		}	
	    var isValid;
	 
	    if (!matchPattern) {    
				
	        isValid = true;
	        matchPattern = {};
	    }
	    
	    else {
	
	        isValid = _isInputValid(matchPattern);
			
		    if (!isValid) {
	            throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: getList: match param is invalid");
	    	}
	    }
	    var returnValue;
	    if (!isSync) {
	        var tid = asyncCallbackMap.add(callback, errorCallback);
			var serviceObject = qtCalendarIf;
	
			returnValue = qtCalendarIf.getList(matchPattern, tid);
			
			if (returnValue.errorCode != 0) {
			
			asyncCallbackMap.remove(tid);
				
			switch (returnValue.errorCode) {
			    case KErrNotSupported:
			    case KErrArgument:
							
					throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: getList: Operation Failed");
			        break;
							
			    default:
			        __sp_calendar_handle_error(errorCallback, MapErrorCode[(returnValue.errorCode * -1)]);
			    }
			}
			return returnValue.transactionId;
		}
	    else{
	        returnValue = qtCalendarIf.getList(matchPattern);
			//In case of error returnValue will be null , it will be returned as it is to caller.No exception	            
	            
	        return returnValue;			
		}  
    },

   /**
    * Add a new entry into the calendar database. This is a synchronous method.
    * @param {CalendarEntry} calendarEntry The new calendar entry, that is added. 
    *                        The id property is not needed, it will
    *                         be ignored, as addEntry will generate an id to the new entry.
    * @exception  {DeviceException} Code 1 (MISSING_ARG_ERR): calendarEntry is undefined.<br>
    *                               Code 2 (INVALID_ARG_ERR): calendarEntry does not fit {@link CalendarEntry} data scheme.<br>
    *                               Code 105 (DATA_OUT_OF_RANGE_ERR): Invalid value passed for any of the parameters.
    * @return {string} The id of the added calendar entry.                           
    */
    addEntry : function(calendarEntry){

		filterUndefined(calendarEntry);
	 		
    	var connectId;
	
        if (calendarEntry) {
            if (typeof calendarEntry != 'object') {
                throw new DeviceException(error.INVALID_ARG_ERR, 'Calendar: addEntry: calendarEntry param is invalid');
            }
            
            if (calendarEntry.id) {
                calendarEntry.id = undefined;
            }
            
            if (!calendarEntry.type || !calendarEntry.time) {
                throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param missing");
            }
            
            if(calendarEntry.time === null) {
	    		//throw missing argument error
	    		throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param missing");
			}
	
			else if(typeof calendarEntry.time != 'object' || typeof calendarEntry.type != 'string')	{
        		throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: addEntry: calendarEntry param type is invalid");
			}
            
            if ((calendarEntry.type != 'ToDo') && !calendarEntry.time.begin) {
                throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param StartTime missing");
            }
            
            if (!calendarEntry.time.end && (calendarEntry.type == 'ToDo' || calendarEntry.type == 'Meeting')) {
                throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param EndTime missing");
            }
            
            if (calendarEntry.repeatRule) {
                if (typeof calendarEntry.repeatRule != 'object') {
                    throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: addEntry: repeatRule param type is invalid");
                }
                
                if (!calendarEntry.repeatRule.frequency) {
                    throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param Frequency missing");
                }
            }
            
            
            var isValid = _isInputValid(calendarEntry);
            
            if (!isValid) {
                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: addEntry: calendarEntry param is invalid");
            }
        }
        
        else {
            throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: addEntry: mandatory param missing");
        }
        
        var returnValue;
        
        returnValue = qtCalendarIf.addEntry(calendarEntry);
        
        
        if (returnValue.errorCode != 0) {
            throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: addEntry: Operation failed");
        }
        
        return returnValue.uid;
        
    },

    /**
     * Update an existing entry in the calendar database. This is a synchronous method.
     * <br>
     * <br>
     * The calendar entry to be updated must exist and its id must be available in the 
     * {@link CalendarEntry} data scema instance that is passed as a parameter to <i>updateEntry</i>. 
     * In case you wish to modify only a specific instance or occurrence of a repeating calendar entry 
     * then specify start time along with id. If time.begin is not specified, 
     * the whole entry (i.e., all of its instances) will be modified. All the parameters of an 
     * entry can be updated except its type.
     * <br>
     * <br>
     * If an instance of a repeating entry is modified, on child entry supported platforms a new child entry 
     * will be created, on other platforms the new entry will be an independent entry which bears no 
     * relation to the original entry. 
     * @param {CalendarEntry} calendarEntry Calendar entry with at least the id property. The id property must 
     *                        identify an existing calendar entry, otherwise <i>updateEntry</i> will 
     *                        throw an exception. 
     * @return {void}                         
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): calendarEntry is undefined.<br>
     *                              Code 2 (INVALID_ARG_ERR): calendarEntry object missed an id field see {@link CalendarEntry}.<br>
     *                              Code 101 (DATA_NOT_FOUND_ERR): <ul><li>id specified does not exist. </li>
     *                                                             <li>instanceStartTime not found.</li>
     *                                                             </ul>
     */
     updateEntry: function(calendarEntry){
        
         var connectId;
            
         filterUndefined(calendarEntry);
            
         if (calendarEntry) {
             if (typeof calendarEntry != 'object') {
                 throw new DeviceException(error.INVALID_ARG_ERR, 'Calendar: updateEntry: calendarEntry param is invalid');
             }
                
             if (!calendarEntry.id) {
                 throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: updateEntry: mandatory param - Id missing");
             }
                
             if (calendarEntry.repeatRule) {
                
                 if (typeof calendarEntry.repeatRule != 'object') {
                     throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: updateEntry: repeatRule param type is invalid");
                 }
                    
             }
                
                
			 if(calendarEntry.time === null) {
				 //throw missing arg
				 throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: updateEntry: mandatory param missing");
			 }
			 var isValid = _isInputValid(calendarEntry);
			        
			 if (!isValid) {
			     throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: updateEntry: calendarEntry param is invalid");
			 }
   		 }
            
	    else {
	        throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: updateEntry: mandatory param missing");
	    }
            
    
	    var returnValue;
	    
	    returnValue = qtCalendarIf.addEntry(calendarEntry);
    
    
	    if (returnValue.errorCode != 0) {
	        throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: updateEntry: Operation failed");
	    }
    },
    
    /**
     * Delete an entry or an instance from the calendar database.
     * This is a synchronous API.
     * <br>
     * <br>
     * The {@link DeleteData} instance that is passed as a parameter to <i>deleteEntry</i> 
     * determines whether entry deletion or instance deletion should be performed. 
     * If the {@link DeleteData} instance contains only the id property, then the entry 
     * matching that id will be deleted.  
     * <br>
     * <br>
     * If both id and range properties are present, 
     * then only those instances falling within the specified time range and matching 
     * id specified will be deleted.
     * @param {DeleteData} deleteData A DeleteData instance that specifies what will be deleted.
     * @return {void}
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): deleteData is undefined.<br>
     *                              Code 2 (INVALID_ARG_ERR): deleteData does not conform to {@link DeleteData} data scheme.<br>
     */
    deleteEntry : function(deleteData){
		
		filterUndefined(deleteData);
			
	    var connectId;
	
            if (deleteData) {
            
                if (typeof deleteData != 'object') {
                    throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: deleteEntry: delete Data is invalid");
                }
                
                if (!deleteData.id) {
                    throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: deleteEntry: missing Mandatory param");
                }
            }
            
            else {
                throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: deleteEntry: missing delete data");
            }
            
            
            
            var isValid = _isInputValid(deleteData);
            
            if (!isValid) {
                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: deleteEntry: delete data is invalid");
            }
            
            var returnValue;
            
            returnValue = qtCalendarIf.deleteEntry(deleteData);
            
            if (returnValue.errorCode != 0) {
                throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: deleteEntry: Operation failed");
            }
        },

    /**
     * Start the device native calendar editor UI with pre-populated calendar entry data.
     * This is an asynchronous method. 
     * This function can be used to to add a new entry or update an existing entry through
     * the native calendar editor.
     * 
     * @param {function} __success_cb A callback function with the signature
     *                     <i>function(transactionId, status, data)</i>
     * @param {CalendarEntry} calendarEntry A {@link CalendarEntry} data scheme instance,
     *                  whose properties are used to prepopulate the native caledar editor.
     * @param {function} [_error_cb] This callback function gets invoked with
     * {@link DeviceError} object when error occurs in processing the async request.
     * <i>function(DeviceError)</i>
     * {@link DeviceError}
     * @return {number} Returns a transaction id.
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): calendarEntry or
     *                callback is undefined.<br>
     *                Code 2 (INVALID_ARG_ERR):
     *                                 <ul>
     *                              <li>callback is not a function</li>
     *                              <li>calendarEntry - does not conform to the specified {@link CalendarEntry} data scheme.</li>
     *                              <li>errorCallback is not a function</li>
     *                              </ul>
     */
    startEditor : function(__success_cb, calendarEntry, _error_cb){
	       
		    if(!__success_cb)
				throw new DeviceException(error.MISSING_ARG_ERR, 'StartEditor:Missing Success Callback');			
	
			if((typeof __success_cb) != "function" )
				throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Success Callback');
	
			if(_error_cb)
				if((typeof _error_cb) != "function" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Error Callback');
			  
		    function startEditor_cb(){   
				
					__success_cb(null);				
		    }
			
			var connId  = qtCalendarIf.addEventListener("asyncCallback()", startEditor_cb);
			
		    try{
			
		    	var ret = qtCalendarIf.startEditor(calendarEntry, connId);
								  
			  	if (ret.errorCode != 0)
	    			throw new DeviceException(MapErrorCode[(ret.errorCode * -1)], ret.errorMessage);
		    }
			
			catch(er){
				//alert('er '+er);
			   	throw(er);
			}

    },
    
    /**
     * Cancels an asynchronous request identified by transactionId.
     * This is synchronous API.
     *
     * @param {number} transactionId
     *           Identifier of the ongoing asynchronous request to be canceled.
     * @return {void}
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
     *                           Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request corresponds to the specified trasactionid.
     */
    cancel: function(transactionId){
		
        if (!transactionId) {
            throw new DeviceException(error.MISSING_ARG_ERR, "Calendar: cancel: transaction id is missing");
        }
        
        else 
            if (typeof(transactionId) != "number") {
                throw new DeviceException(error.INVALID_ARG_ERR, "Calendar: cancel: transaction id is invalid");
            }
        
        var returnValue = qtCalendarIf.cancel(transactionId);
        
        if (returnValue.errorCode != 0) {
        
            throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: cancel: Operation failed");
            
        }
        
	},
	
	/**
     * Subscribe for Calendar entry change Notification.
     * This is an asynchronous method. 
     * 
     * @param {function} succes_cb A callback function with the signature
     *                     <i>function(transactionId, status, data)</i>
     * 
     * @param {function} [fail_cb] This callback function gets invoked with
     * {@link DeviceError} object when error occurs in processing the async request.
     * <i>function(DeviceError)</i>
     * {@link DeviceError}
     * @return {void} 
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): calendarEntry or
     *                callback is undefined.<br>
     *                Code 2 (INVALID_ARG_ERR):
     *                                 <ul>
     *                              <li>succes_cb  is not a function</li>
     *                              <li>fail_cb is not a function</li>
     *                              </ul>
     */
	subscribeNotification: function(succes_cb, fail_cb){
	    
	    
		
	    if (!succes_cb) {
	        /*
	         * MissingArgument error "callback not passed";
	         */
	        throw new DeviceException( error.MISSING_ARG_ERR, 'Calendar: subscribeNotification: callback is missing');
	    }
		
	    /*
	     * here we check if the type of callback is function. 
	     * This case is useful when arbitrary values are passed to callback
	     */
	    else 
	        if (typeof succes_cb != "function") {
	            throw new DeviceException(error.INVALID_ARG_ERR, 'Calendar: subscribeNotification: callback is invalid');
	        }
			
		if (fail_cb) {
			if (typeof fail_cb != 'function') {
				throw new DeviceException(error.INVALID_ARG_ERR, 'Calendar: subscribeNotification: error callback is invalid');
			}
		}
 	    //Remove previous callback entry
        if (notifyTid) {
            //asyncCallbackMap.remove(notifyTid);
			throw new DeviceException(error.INVALID_ARG_ERR, 'Calendar: subscribeNotification: multiple requests not supported');
        }
		//Add new callback
        var tid = asyncCallbackMap.add(succes_cb, fail_cb);
		//Store current transactionId			
        notifyTid = tid;
        var serviceObject = qtCalendarIf;
        
        var isValid;
        
        var returnValue = qtCalendarIf.subscribeNotification(tid);
            
        if (returnValue.errorCode != 0) {
			//Error, hence remove callback entry from map
			asyncCallbackMap.remove(notifyTid);
			//Error, hence set to null
			notifyTid = null;
            
            switch (returnValue.errorCode) {
                case KErrNotSupported:
                case KErrArgument:
                    
                    throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: subscribeNotification: Operation failed");
                    break;
                    
                default:
                    __sp_calendar_handle_error(fail_cb, MapErrorCode[(returnValue.errorCode * -1)]);
            }
        }
    },
	
	
	/**
     * Cancel a request for notification.
     * This is synchronous API.
     * 
     * @return {void}
     * @exception {DeviceException}  Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request 
     */
	cancelNotification : function(){
        var returnValue = qtCalendarIf.cancelNotification();
        if (notifyTid) {
            asyncCallbackMap.remove(notifyTid);
            notifyTid = null;
        }
		if(returnValue.errorCode != 0) {
            throw new DeviceException(MapErrorCode[(returnValue.errorCode * -1)], "Calendar: cancelNotification: Operation failed");
        }
    }
        
        
    };
}
/**
 * @author thunga
 */

/**
 * @class
 */

/*
*/

var __s60_start_and_wait_cb;

//callback function
function __s60_on_app_exit(){    
  if(__s60_start_and_wait_cb != null){  	
    __s60_start_and_wait_cb();
  }
}

function __s60_on_app_start(){	
  window.widget.onhide = null;
  window.widget.onshow = __s60_on_app_exit;
}

/**
 *This function launches the camera apllication  
 *@param id : id of the application to be opened.
 *@param args : argument to be passed.
 *@param app_exit_cb : callback to be called when exit happpens.
 */
 
function __s60_start_and_wait(app_exit_cb){
  __s60_start_and_wait_cb = app_exit_cb;
  window.widget.onhide = __s60_on_app_start;
 // window.widget.openApplication(id, args);
}

var takePicscb = null;
	
var takePicecb = null;
function callbackfunc(result){

				var error = result.errorCode;

				if (error == 0) {
					 var retFlName = result.fileName;

					// retFlName = retFlName.replace(/\134/g, "/");

					 //retFlName = "file://"+retFlName;

					 takePicscb(retFlName);
				}
				else {
					//takePicecb(new DeviceAPIError1(error,'Error Occured in captureImage'));
					takePicecb(error);
				}
			}
	
function recordCompleteCallback(rv)
{
	window.widget.onhide = null;
	__recordingInProgress = false;
	if (__jilRecordCompleteCallback) {
		var retValue = rv.returnValue;
		__jilRecordCompleteCallback(retValue);
	}
}

var __jilRecordCompleteCallback = null;

nokia.device.Camera = function PSCameraInterface(){

    function camera_cb(errorCode,transId,result)
    {
        var retObj = asyncCallbackMap.get(transId);
        asyncCallbackMap.remove(transId);
		//Temporary hack for properly work of callback
		//One instantion of camera has been supported
		asyncCallbackMap.usec_count = 0;
        if(retObj)
        {
            var callback = retObj.success_cb;
            var errorCallback = retObj.error_cb;
            if(errorCode)
            {
                 if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "Camera : startCamera : error occured."));
                }
            }
            else
            {
                callback(result);
            }
        }
    }

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    //camera application UID. 
    var CAMERA_APP_ID = 0x101f857a;
    var error = new DeviceException(0,'dummy');
    var errorAPI = new DeviceAPIError(0,'dummy');
	
	//flag indicating whether startRecording has been called
	var __recordingInProgress = false;
				
    /*
     * Internal
     * qt contacts interface object.
     */
	
    	var psCameraIntf = nokia._services.load("nokia.device.camera", "com.nokia.ICamera", "1.0");
        psCameraIntf.addEventListener("asyncCallback(int, int, QVariant)",camera_cb);

    
    /*
				  * supportedsizes global variable
				  */
				 var qtCameraSupportedSizes = [];
				 try{
				 qtCameraSupportedSizes = psCameraIntf.supportedSizes();//supported sizes
				}
				catch(er){
					sfw_debug("Unable to get supported sizes"+er);					
				}
				 /*
				 * Read only property - supported sizes
				 */
				 psCameraIntf.supportedSizes = qtCameraSupportedSizes;
    
		    function af(str){
				//alert(str);
			}
			/*
			 * golbal variable to keep track of the domObject 
			 */  
			var prevDomObj = null;
			
			var pluginObj = null;
			
			var vferrcode = 0;
			var vferrmessage = "Success";
			
			var width = 0;
			var height = 0;
			
			var CameraPlugin = null;
	

        // When widget gets hidden while video capture in progress this function gets invoked. Here we stop the video Capturing.		
	// Issue - If an error occurs while stopping we dont have a way to communicate to the user in this scenario
			function widgetHidden(){
				try{
					//alert("in widget onhidden");					
					if(CameraPlugin != null && __recordingInProgress){
							var returnObject = CameraPlugin.StopRecording();
							__recordingInProgress = false;
					}
					window.widget.onhide = null;
				}
				catch(e){
					af("exception in widgethidden func"+e.toString());
				}
			}
  return {
     	    /**
     	    * @constant {String} 
     	    * interfaceName.
     	    */      
     	    interfaceName: "camera",
     	    /**
     	    * @constant {Number} 
     	    * version.
     	    */      
     	    version: nokia.device._interfaces['camera'],
  	     /*
				 * Read only property - supported sizes
				 */
				 
				supportedSizes :  qtCameraSupportedSizes,
  	     
				/**
         * Starts the camera application and returns the list of meta data of images captured.         
         * @param {function} successCallback A function with the signature function((picdata}).         
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
                 
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>                                                              
         *                                                        </ul>
         */                 
				 
				startCamera:function(sCB, eCB){
				
				
				var start_date = new Date();		
				
				if(sCB == undefined || sCB == null){
					throw new DeviceException(error.MISSING_ARG_ERR, 'startCamera:Missing Success Callback');
				}
			
       	if(sCB && ((typeof sCB) != "function" )){
        		throw new DeviceException(error.INVALID_ARG_ERR, 'startCamera:Invalid Success Callback');
        }
					
				if(eCB && ((typeof eCB) != "function" )){
        		throw new DeviceException(error.INVALID_ARG_ERR, 'startCamera:Invalid Error Callback');	
       	}
        	
		try {
				var tid = asyncCallbackMap.add(sCB, eCB);
				
				var errormap = psCameraIntf.startCamera();
			} 
			catch (er) {
				sfw_debug("Unable to launch Camera" + er);
			}
		if (navigator.appVersion.toLowerCase().indexOf("linux") == -1) 
        {
			if (errormap.ErrorCode != 0) {
				if ((eCB != null) && (eCB != undefined)) 
					eCB(new DeviceAPIError(errormap.ErrorCode, "Camera:startCamera:Operation Failed"));
			}
			else {
				__s60_start_and_wait(callback);
			}
		}	
				
				//callback function.		
				function callback(arg1, arg2, arg3){					
					var end_date = new Date();					
					//get the list of images taken between the start and exit of the camera.
					try{
					var result = psCameraIntf.getList(start_date, end_date);			
				  }
				  catch(er){
				  sfw_debug("Unable to get meta data list of images"+er);	
				  }
					var errormap = result.errormap;		  		  
					if ( errormap.ErrorCode != 0) {
						eCB(new DeviceAPIError(errormap.ErrorCode, "Camera:Getlist:Operation Failed"));
						}
					else {
						sCB(result.picturedata);
						}
					}		
				},
			stopViewFinder: function(){
			try {
			        // If the plugin object gets deleted in the callback widget crashes. To fix this crash we have made removal of plugin after a delay of 0.5 seconds
				// This is actually a bug in webkit which needs to be fixed.
				if (prevDomObj) {
					CameraPlugin.StopViewFinder();
					setTimeout(function(){
	                            prevDomObj.removeChild(pluginObj);
				     prevDomObj = null;
	                                },500);
				
				}
			} 
			catch (e) {
				af("Exception in stop in cjse" + e.toString());
				throw e;
			}
		},
			/*
			 * API startViewFinder() to load the camera plugin and set the preview window of the camera. 
			 */
				startViewFinder: function (__domObject){
				try{
					if(!__domObject){
						throw new DeviceException(error.MISSING_ARG_ERR,'domObject input is missing');
					}
					if(typeof __domObject != 'object'){
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not an object');
					}
					if(!__domObject.style){
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input does not mention the height and width of the window');
					}
					if(prevDomObj){
						throw new DeviceException(error.INVALID_ARG_ERR,'a window is already set. Cannot set another window');
					}
					width = __domObject.style.width ;
					height = __domObject.style.height;
					//TODO: need to check the lower limit and upper limit throw exception accordingly
					if(width == "0px" || height == "0px"){						
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not valid.');
					}					
					if(width == "" || height == ""){						
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not valid.');
					}								
					var newdiv = document.createElement('div');
				    newdiv.id = "Camera";
				    newdiv.innerHTML = "\<object id = \"CameraDiv\" TYPE=nokiaplugin\/camera WIDTH="+width+" HEIGHT="+height+" text = \"Camera Nokia Plugin\" hidden="+true+"\>\<\/object\>";	
					__domObject.appendChild(newdiv, document.body.firstChild);
				    CameraPlugin = document.getElementById("CameraDiv");
			
					prevDomObj = __domObject;
				    pluginObj = newdiv;
				
      				  //alert("callingviewfinder");   
         			setTimeout(function(){
						if(CameraPlugin != null){
							var retVal = CameraPlugin.StartViewFinder();
							var errcode = retVal.errorCode;
							var errMessage = retVal.errorMessage;
							if(errcode != 0){							
								throw new DeviceException(errCode, errMessage);
							}
							}
							else{
								throw new DeviceException(error.INVALID_ARG_ERR, 'Operation Failed');
							}
						},500);
				}
				catch(e){
					prevDomObj = null;
					af("exception in cjse setCamWindow()"+e.toString());
					throw e;
				}
			},
			/**
			 * captures a still image and stores to a file
			 *
			 * Returns ??
			 * @param {Function}
			 *         callback - The supplied function will be called when capturing is complete
			 * @param {URL}
			 *         fileName - url of the file to which the image is to be saved 
			 * @param {lowRes}
			 *         Flag to indicate whether the resolution must be maximum or minimum
			 *         Defaults to false
			 * @return {Number} TransactionId which uniquely identifies asynchronous request.
			 * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
			 *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
			 *                                                            <li>fileName is not a string</li>
			 *                                                            <li>lowResolutionFlag is not boolean</li>
			 */                                                           
					
			captureImage: function(__callback, __options, __errorCallback){
			try {
				var __flName = __options.fileUri; 
				var __lowRes = __options.lowResolution;
				if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
				af("in cjse flname"+__flName);
				function validateFlName(fName){
					var index = fName.indexOf(".");
					if(index != -1){
						var remName = fName.slice(index);
						if(remName == ".jpg")
							return true;
						else
							validateFlName(remName);	
					}
					else
						return false;
				};				
				if (!__callback) {
					throw new DeviceException(error.MISSING_ARG_ERR, 'success callback is mandatory');
				}
				if (typeof __callback != 'function') {
					throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of success callback');
				}
				if (__errorCallback) {
					if (typeof __errorCallback != 'function') {
						throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of error callback');
					}
				}
				takePicscb = __callback;
				takePicecb = __errorCallback;
				if (__flName) {
					if (typeof __flName != 'string') {
						throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of file name input');
					}
				}
				if (__lowRes) {
					if (__lowRes != true && __lowRes != false) {
						throw new DeviceException(error.INVALID_ARG_ERR, 'invalid type of lowRes input');
					}
				}
				if(__flName != null && (__flName.length > 255 || __flName.length < 0)){
					throw new DeviceException(error.INVALID_ARG_ERR, 'invalid size of file name');
				}
				
				if(__flName)
					__flName = __flName + String.fromCharCode(0);
				if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
				else{
					var result = CameraPlugin.TakePicture("callbackfunc" + String.fromCharCode(0), __flName, __lowRes);
					var errcode = result.errorCode;
					var errMessage = result.errorMessage;
					if (errcode != 0) {
	                    switch (errcode) {
	                        case error.INVALID_ARG_ERR:
	                        case error.MISSING_ARG_ERR:
	                        case error.NOT_SUPPORTED_ERR:
	                            throw new DeviceException(errcode, errMessage);
	                        default:
	                            if (__errorCallback) {
	                                setTimeout(function(){
	                                    __errorCallback(new DeviceException(errcode, errMessage));
	                                }, 1000);
	                                return;
	                            }
	                            else {
	                                throw new DeviceException(errcode, errMessage);
	                            }
                            }    
                         }										 
					 var retFlName = result.fileName;
					 
					 return retFlName;
				}
				
			} 
			catch (e) {
				af("Exception in captureImage in cjse" + e.toString());
				throw new DeviceException( e.code, e.message);
			}
		},

			

		/**
		 * starts the recording of video
		 *
		 * Returns unique transaction id.
		 * @param {Function}
		 *         callback - The supplied function will be called when recording is complete
		 * @param {URL}
		 *         fileName - url of the file to which the video is to be saved 
		 * @param {LowResolutionFlag}
		 *         Flag to indicate whether the resolution must be maximum or minimum
		 *         Defaults to false
		 * @param {MaxDuration}        
		 *         Maximum Duration for which the recording needs to be done
		 * @return {Number} TransactionId which uniquely identifies asynchronous request.
		 * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
		 *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
		 *                                                            <li>fileName is not a string</li>
		 *                                                            <li>lowResolutionFlag is not boolean</li>
		 *                                                            <li>maxDuration is not a number</li>
		 */                                                           
			
			startVideoCapture: function(__callback, __options, __errorCallback) {
				try {
				var __fileName = __options.fileUri;
				var __lowResolutionFlag = __options.lowResolution;
				var __maxDuration = __options.duration;
				
                if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
                if(__callback == null || typeof __callback == undefined) {
					throw new DeviceException(error.MISSING_ARG_ERR,'callback is missing');
				}
				
				else if( typeof __callback != "function") {
				    throw new DeviceException(error.INVALID_ARG_ERR,'callback is not a function');
				}

                if(__errorCallback != null && typeof __errorCallback != undefined) {
					if( typeof __errorCallback != "function") {
						throw new DeviceException(error.INVALID_ARG_ERR,'error callback is not a function');
					}

				}
				
				if (__fileName != null && typeof __fileName != "undefined" && __fileName != "") {
					if (typeof __fileName != "string") {
						throw new DeviceException(error.INVALID_ARG_ERR, 'filename is not a string');
					}
				}
				
				else
				   __fileName = null;
				
				if (__lowResolutionFlag != null && typeof __lowResolutionFlag != "undefined" ) {
					if (typeof __lowResolutionFlag != "boolean") {
						throw new DeviceException(error.INVALID_ARG_ERR, 'low Resolution is not a boolean value');
					}
				}
				
				else
				   __lowResolutionFlag = false;
				
				if (__maxDuration != null && typeof __maxDuration != "undefined") {
					if (typeof __maxDuration != "number" || (__maxDuration != __maxDuration | 0) || __maxDuration < 0) {
						throw new DeviceException(error.INVALID_ARG_ERR, 'maximum duration  is invalid');
					}
					
					else if(__maxDuration == 0 || __maxDuration > 300) {
					   throw new DeviceException(error.NOT_ALLOWED_ERR,'maximum duration is out of range ');
				    }

				}
				
                		else
				   __maxDuration = 300;
			
				   
					__jilRecordCompleteCallback = __callback;
					
					if(__fileName!=null)
					   __fileName = __fileName +String.fromCharCode(0);
					 
					__recordingInProgress = true;
					var returnObject = CameraPlugin.StartRecording( "recordCompleteCallback" + String.fromCharCode(0),__fileName, __lowResolutionFlag, __maxDuration, false );
					
					//use only errorMessage, returnObject.errorMessage accessible only once
					var errorMessage =  returnObject.errorMessage;
					var retValue = returnObject.returnValue;
					var tid = returnObject.transactionId;
					
				    if (returnObject.errorCode != 0) {
						__recordingInProgress = false;
	                    switch (returnObject.errorCode) {
	                        case error.INVALID_ARG_ERR:
	                        case error.MISSING_ARG_ERR:
	                        case error.NOT_SUPPORTED_ERR:
	                            throw new DeviceException(returnObject.errorCode, errorMessage);
	                        default:
	                            if (__errorCallback) {
	                                setTimeout(function(){
	                                    __errorCallback(new DeviceException(returnObject.errorCode, errorMessage));
	                                }, 1000);
	                                return;
	                            }
	                            else {
	                                throw new DeviceException(returnObject.errorCode, errorMessage);
	                            }
                            }    
                         }	
     			   window.widget.onhide = widgetHidden;		 
				   return   retValue;      
                  }
				  
				catch(e) {
					
					throw new DeviceException( e.code, e.message);
				}
			},
		  		
				
	    /**
		 * stops the recording of video
		 */                                                           

		  stopVideoCapture : function (){
		  	try{
					if(prevDomObj == null){
						throw new DeviceException(error.NOT_ALLOWED_ERR, 'window is not set');
					}	
					var returnObject = CameraPlugin.StopRecording(  );
					
					var errorMessage = returnObject.errorMessage;
					
					
				    if (returnObject.errorCode != 0) {
	                   
	                       throw new DeviceException(returnObject.errorCode, errorMessage);
                                
                         }        
					
				}
				catch(e) {
				
					throw new DeviceException( e.code, e.message);
				}
		  }
  };  
}
/**
 * @class
 */
nokia.device.CommLog = function PSCommLogInterface(){

    var DeviceException = nokia.device.DeviceException;
    var error = new DeviceException(0, 'dummy');
    
    var notifyTid = null;

    /*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	iterator is the eventItem Iterator
     */
    function getList_cb(errorCode, transId, iterator){
        var obj = asyncCallbackMap.get(transId);
        asyncCallbackMap.remove(transId);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (errorCode) {
                if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "CommLog : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback(iterator);
            }
        }
    }
    /*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	result is the eventData
     */
    function setNotification_cb(errorCode, transId, result){
        var obj = asyncCallbackMap.get(transId);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (errorCode) {
                if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "CommLog : setNotification : error occured"));
                }
            }
            else {
                //Invoke consumer callback with result.
                callback(result);
            }
        }
      
    }
    /*
     * Internal
     * qt CommLog interface object.
     */
        var qtCommlogIf = nokia._services.load("nokia.device.commlog", "com.nokia.ICommLog", "1.0");
        qtCommlogIf.addEventListener("asyncCallback(int,int,QObject*)", getList_cb);
        qtCommlogIf.addEventListener("notificationCallback(int,int,const QMap<QString,QVariant>&)", setNotification_cb);
    
    return {
     	    /**
     	    * @constant {String} 
     	    * interfaceName.
     	    */      
     	    interfaceName: "commlog",
     	    /**
     	    * @constant {Number} 
     	    * version.
     	    */      
     	    version: nokia.device._interfaces['commlog'],
  	     /*
				 * Read only property - supported sizes
				 */
        /**
         * Gets an iterator of event entires matching the supplied pattern
         * This is an asynchronous api
         * <br><br>
         * The output returned by this method depends on the filter criteria that can optionally
         * be passed with the <i>matchCriteria</i> parameter, which is an instance of the
         * data scheme {@link MatchCriteria}.
         * <br><br>
         * The contents of the {@link MatchCriteria} instance will guide <i>getList()</i> as follows:
         * <br><br>
         * The matchCriteria contains type, flag, recent and phone fields.
         * Type can be either SMS or Call. Flag can be incoming, outgoing, received or missed.
         * Recent is a boolean flag applicable for only calls. Phone specifies the phone number to be matched.
         * Recent field will be ignored if type is SMS
         * <br><br>
         * The <i>matchPattern</i> parameter is optional. If it is not present, then all instances are returned.
         * @param {function} successCallback A callback function with the signature
         *                     <i>function({@link Iterator} of {@link EventData})</i>
         *                     The iterator will iterate instances of {@link EventData}, which represent
         *                     event entries that match the matchCriteria.
         * @param {MatchCriteria} [matchCriteria] Specifies a matching filter for the entries to return.
         *                 May be <i>null</i> or <i>undefined</i> to match all
         *                 instances, or an {@link MatchCriteria} instance for getting a restricted set of
         *                 {@link EventData} instances.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * @return {number} Returns a transaction id
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR):
         *                              <ul>
         *                              <li>callback is not a function</li>
         *                              <li>matchCriteria - does not conform to the {@link MatchCriteria} data schema</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
        getList: function(successCallback, matchCriteria, errorCallback){
			
            //handle sync as well as async
            var isSync = false;
            if ((!successCallback && !matchCriteria && !errorCallback) || (typeof successCallback) == "object" && !matchCriteria && !errorCallback) {
                isSync = true;
            }
            
            if (isSync) {
                //input validations..
                var matchCriteria = successCallback;
                if (!matchCriteria) {
                    matchCriteria = {};
                }
                else 
                    if ((typeof matchCriteria) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid");
                    }
					
			else if(((typeof matchCriteria) == "object")){
				
				var validDate = new Date("January 01, 1970 00:01");
				var flag = 1;
				if (matchCriteria.endTime!=null && typeof matchCriteria.endTime!="undefined" && typeof matchCriteria.endTime =="object") {
					try {
                        var etime = matchCriteria.endTime;
						var year = etime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if(flag)
					   {
					   	if ((matchCriteria.endTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					   }
				}
				
				if (matchCriteria.startTime!=null && typeof matchCriteria.startTime!="undefined" && typeof matchCriteria.startTime =="object") {
					try {
                        var stime = matchCriteria.startTime;
						var year = stime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if (flag) {
						if ((matchCriteria.startTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					}

				}
				
				
			}
				
                
                     var retValue = qtCommlogIf.getList(matchCriteria);                                                                        
                     if ((typeof retValue.status) != "undefined" && retValue.status != 0)                                                               
                   throw new DeviceException(retValue.status, retValue.message);                                                                     
                 else{                                                                                                                                
         return  retValue;                                                                                                                          
                 }   
            }
            else {
                //input validations..
                if (successCallback == "undefined" || successCallback == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : getList : callback is missing");
                }
                else 
                    if ((typeof successCallback) != "function") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : callback is invalid");
                    }
                if ((typeof matchCriteria) == "undefined" || matchCriteria == null) {
                    matchCriteria = {};
                }
                else 
                    if ((typeof matchCriteria) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid");
                    }
			else if(((typeof matchCriteria) == "object")){
				
				var validDate = new Date("January 01, 1970 00:01");
				var flag = 1;
				if (matchCriteria.endTime!=null && typeof matchCriteria.endTime!="undefined" && typeof matchCriteria.endTime =="object") {
					try {
                        var etime = matchCriteria.endTime;
						var year = etime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if(flag)
					   {
					   	if ((matchCriteria.endTime) < validDate) {
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
						}
					   }
				}
				
				if (matchCriteria.startTime!=null && typeof matchCriteria.startTime!="undefined" && typeof matchCriteria.startTime =="object") {
					try {
                        var stime = matchCriteria.startTime;
						var year = stime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if (flag) {
						if ((matchCriteria.startTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					}

				}
				
				
				
			}
				
                if ((typeof errorCallback) == "undefined" || errorCallback == null) {
                    errorCallback = null;
                }
                else 
                    if (errorCallback && (typeof errorCallback) != "function") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : errorCallback is not a function");
                    }
                
				//Add new callback
                var tid = asyncCallbackMap.add(successCallback, errorCallback);
                var returnValue = qtCommlogIf.getList(matchCriteria, tid);
                
                if (returnValue.status != 0) {
					//Error, hence remove callback entry from map
					asyncCallbackMap.remove(tid);
                    switch (returnValue.status) {
                        case error.INVALID_ARG_ERR:
                        case error.MISSING_ARG_ERR:
                        case error.NOT_SUPPORTED_ERR:
                            throw new DeviceException(returnValue.status, returnValue.message);
                        default:
                            if (errorCallback) {
                                setTimeout(function(){
                                    errorCallback(new DeviceException(returnValue.status, returnValue.message));
                                }, 1000);
                                return;
                            }
                            else {
                                throw new DeviceException(returnValue.status, returnValue.message);
                            }
                    }
                    
                    
                    
                }
                
                return tid;
            }
            
            
        },
        
        /**
         * Subscribe for Events  Notification.
         * This is an asynchronous method.
         *
         * @param {function} succesCallback A callback function with the signature
         *                     <i>function(errorCode, transId, result)</i>
         *
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * {@link DeviceError}
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR):
         *                              <ul>
         *                              <li>succesCallback  is not a function</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
        setNotification: function(successCallback, errorCallback){
            //input validations..
            if (successCallback == "undefined") {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : setNotification : callback is missing");
            }
            else 
                if ((typeof successCallback) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : setNotification : callback is invalid");
                }
            
            if ((typeof errorCallback) == "undefined" || errorCallback == null) {
                errorCallback = null;
            }
            else 
                if (errorCallback && (typeof errorCallback) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : setNotification : errorCallback is invalid");
                }
            
			//Remove previous callback entry
            if (notifyTid) {
                asyncCallbackMap.remove(notifyTid);
            }
			//Add new callback
            var tid = asyncCallbackMap.add(successCallback, errorCallback);
			//Store current transactionId			
            notifyTid = tid;
            var returnValue = qtCommlogIf.setNotification(tid);
            
            if (returnValue.status != 0) {
				//Error, hence remove callback entry from map
				asyncCallbackMap.remove(notifyTid);
				//Error, hence set to null
				notifyTid = null;
                switch (returnValue.status) {
                    case error.INVALID_ARG_ERR:
                    case error.MISSING_ARG_ERR:
                    case error.NOT_SUPPORTED_ERR:
                        throw new DeviceException(returnValue.status, returnValue.message);
                    default:
                        if (errorCallback) {
                            setTimeout(function(){
                                errorCallback(new DeviceException(returnValue.status, returnValue.message));
                            }, 1000);
                            return;
                        }
                        else {
                            throw new DeviceException(returnValue.status, returnValue.message);
                        }
                }
                
            }
        },
        
        /**
         * Cancel a call for getList.
         * This is synchronous API.
         *
         * @param {number} transactionId to cancel the notification
         * @return {void}
         * @exception {DeviceException}  Code 1 (MISSING_ARG_ERR): If transactionId is missing.<br>
         *                               Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
         *                               Code 101 (DATA_NOT_FOUND_ERR): If there are no active notification request corresponds to the specified trasactionid.
         */
        cancel: function(transId){
            if (!transId) {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : cancel : transactionId is missing");
            }
            
            else 
                if (typeof(transId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog: cancel: transaction id is invalid");
                }
            
            var returnValue = qtCommlogIf.cancel(transId);
            
			//Cancel, hence remove callback entry from map
            asyncCallbackMap.remove(transId);
            
            if (returnValue.status) {
                throw new DeviceException(returnValue.status, returnValue.message);
            }
        },
        
        /**
         * Cancels a request for notification.
         * This is synchronous API.
         *
         * @return {void}
         * @exception {DeviceException}  Code 101 (DATA_NOT_FOUND_ERR): If there are no active notification request corresponds to the specified trasactionid.
         */
        cancelNotification: function(){
        	
			qtCommlogIf.cancelNotification(notifyTid);
			//Check if setNotification was called. If running, then remove entry from map and set to null.
            if (notifyTid) {
                asyncCallbackMap.remove(notifyTid);
                notifyTid = null;
            }
            
           
        },
        
        /**
         * Deletes a log entry in the databse.
         * This is a synchronous API.
         *
         * @param {number} logId to delete the log
         * @return {void}
         * @exception {DeviceException}  Code 1 (MISSING_ARG_ERR): If logId is missing.<br>
         *                               Code 2 (INVALID_ARG_ERR): logId is not a number.<br>
         *                               Code 101 (DATA_NOT_FOUND_ERR): If a non-existent logId is passed.
         */
        deleteLogEntry: function(logId){
            if (!logId) {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : cancelNotification : transactionId is missing");
            }
            
            else 
                if (typeof(logId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog: cancelNotification: transaction id is invalid");
                }
            
            var returnValue = qtCommlogIf.deleteLogEntry(logId);
            
            if (returnValue.status) {
                throw new DeviceException(returnValue.status, returnValue.message);
            }
        }
    };
}

/**
 * @class
 */
nokia.device.Contacts = function PSContactsInterface(){

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    var error = new DeviceException(0,'dummy');
    var errorAPI = new DeviceAPIError(0,'dummy');
	var notificationId = -1;
	var usec_count=0;
	
	var __s60_start_and_wait_cb;
	
	function __s60_on_app_exit(){
					  window.widget.onshow = null;
					  if(__s60_start_and_wait_cb){
					    __s60_start_and_wait_cb();
					  }
					}
					
	function __s60_on_app_start(){
		  window.widget.onhide = null;
		  window.widget.onshow = __s60_on_app_exit;
		}
		
	function __s60_start_and_wait(args, app_exit_cb){
		  __s60_start_and_wait_cb = app_exit_cb;
		  window.widget.onhide = __s60_on_app_start;
		}

	
	
	var contactsAsyncCallbackMap = function(){
		//this.usec_count			=0,
		this.maptype			="getContacts",	//Used for Contacts
		this.callbackArray		=new Array(),
		this.getTransactionId	=function(){
		usec_count++;
		return usec_count;
	},
	this.add=function(sCb, errCb,options){
			var obj = new Object();
	        obj.success_cb = sCb;
			obj.error_cb = errCb;
			obj.options = options;
	        obj.transactionId = this.getTransactionId();        
	        this.callbackArray.push(obj);
			return obj.transactionId;
	},
	this.get=function(tid,mtype){
			var i = this.callbackArray.length -1;
	        if(!mtype){
				for (; i >= 0; i--) {
	            	if (this.callbackArray[i].transactionId == tid) {
		            	return this.callbackArray[i];
	            	}
	        	}
	    	}else{
		    	for (; i >= 0; i--) {	//Used for Contacts
	            	if (this.callbackArray[i].transactionId == tid) {
		            	if(this.maptype==mtype)
	                		return this.callbackArray[i];
	            	}
	        	}
	    	}
	    	return null;
	},
	this.remove=function(tid){
			var i = this.callbackArray.length -1;
	        for (; i >= 0; i--) {
	            if (this.callbackArray[i].transactionId == tid) {
	                this.callbackArray.splice(i, 1);
	            }
	        }
		}
	
	};
	
	var getcontactscbmap		=	new contactsAsyncCallbackMap;
	getcontactscbmap.maptype 	= 	"getContacts";
	var getgroupscbmap			=	new contactsAsyncCallbackMap;
	getgroupscbmap.maptype		= 	"getGroups";
	var getIdscbmap				=	new contactsAsyncCallbackMap;
	getIdscbmap.maptype			=	"getIds";

	
    function __contact_cb(error,trans,iter)
		{	
			try{
					var retObj = getcontactscbmap.get(trans,"getContacts");	        
	        		if(retObj){
			        	getcontactscbmap.remove(trans);
		        		var callback = retObj.success_cb;
		        		var errorCallback = retObj.error_cb;
		        		
		        		if (error) {
			        		if(errorCallback){
			        			var exception = new DeviceAPIError(error,"getContacts:Failed");
			            		errorCallback(exception);	            			
	            			}
		        		}
		        		else
		        			callback(iter);
        			}
    			}
    			catch(er){
	    			alert(er);
    			}
		}
		
		
		function __get_group_cb(error,trans,iter)
				{	
					try{
						var retObj = getgroupscbmap.get(trans,"getGroups");
				
						getgroupscbmap.remove(trans);
		        
		        		if (retObj) {
			        		var callback = retObj.success_cb;
			        		var errorCallback = retObj.error_cb;
			        		
			        		if (error) {
				        		if(errorCallback){
				        			var exception = new DeviceAPIError(error,"getGroups:Failed");
				            		errorCallback(exception);	            			
		            			}
			        		}
			        		else
			        			callback(iter);
		        		}
	    			}
	    			catch(er){
		    			alert(er);
	    			}
				}
		
    function __ids_cb(error,trans,iter)
		{	
			try{
					var retObj = getIdscbmap.get(trans,"getIds");	        
	        		if(retObj){
			        	getIdscbmap.remove(trans);
		        		var callback = retObj.success_cb;
		        		var errorCallback = retObj.error_cb;
		        		
		        		if (error) {
			        		if(errorCallback){
			        			var exception = new DeviceAPIError(error,"getContactIds:Failed");
			            		errorCallback(exception);	            			
	            			}
		        		}
		        		else
		        			callback(iter);
        			}
    			}
    			catch(er){
	    			alert(er);
    			}
		}


     
    try {
       	var qtContactsIf = nokia._services.load("nokia.device.contacts", "com.nokia.IContacts", "1.0");
       	qtContactsIf.addEventListener("asyncCallbackC(int,int,QObject*)",__contact_cb);	
       	qtContactsIf.addEventListener("asyncCallbackG(int,int,QObject*)",__get_group_cb);
       	qtContactsIf.addEventListener("asyncCallback(int,int,QVariant)",__ids_cb);		
    }catch(e){
        throw DeviceException(error.DATA_NOT_FOUND_ERR,'failed to load requested service interface');
    }

    return     {	    
	    /**
	    * @constant {String} 
	    * interfaceName.
	    */      
	    interfaceName: "contacts",
	    /**
	    * @constant {Number} 
	    * version.
	    */      
	    version: nokia.device._interfaces['contacts'],
		/**
		* @constant {Number} 
		* sorts contacts in ascending order.
		*/
		SORT_ASCENDING	: 0,
		/**
		 * @constant {Number} 
		 * sorts contacts in descending order.
		*/
		SORT_DESCENDING	: 1,	   
		
		/*
		 * Constants used to identify the event in the notification callback
		 */
		EVENT_CONTACT_ADDED : 0,
		EVENT_CONTACT_UPDATED : 1,
	 	EVENT_CONTACT_DELETED : 2,
		EVENT_GROUP_ADDED : 3,
		EVENT_GROUP_UPDATED : 4,
		EVENT_GROUP_DELETED : 5, 
	    
        /**
         * Get an iterator to a list of contacts. This is an asynchronous function.
         * Returns a transaction id.
         * @param {function} successCallback A function with the signature function((Iterator} of ContactData).
         * @param {string} [match] Specifies a matching filter for the contacts to return.
         *                  All the contacts whose fields name.last or name.first start with the string <i>match</i> in
         *                  will be listed.
         * @param {string} [sortOrder] Specifies the sort order, 0 indicates ascending, and 1 indicates descending.
         *                  The contacts are sorted by name.last, and name.first. 
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_OUT_OF_RANGE_ERR: sortingOrder is not one of SORT_ASCENDING or SORT_DESCENDING.
         * </li>
         * <li>
         * DATA_NOT_FOUND_ERR: if no contacts match the parameters.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>match is not a string</li>  
         *                                                        <li>sortOrder is not a number</li>
         *                                                        </ul>
         */
        getContacts : function(__succes_cb, __match, __sort_order, __error_cb) { 	        
	        
				
				if(!__succes_cb)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
				
				if(__succes_cb==null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
				if(__succes_cb==undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
				if(typeof(__succes_cb)=="undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
					
				if((typeof __succes_cb) != "function" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Success Callback');
				
				if((typeof __match) == "undefined")	
					__match = "";
					
				if((__match) == null)
					__match = "";
					
				if((typeof __match) != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Filter Criteria');	
					
				if((typeof __sort_order) == "undefined")
					__sort_order = this.SORT_ASCENDING;	
				
				if((__sort_order) == null)
					__sort_order = this.SORT_ASCENDING;
					
				if((__sort_order) == undefined)
					__sort_order = this.SORT_ASCENDING;
					
				if((typeof  __sort_order) != "number")
					throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid Success Callback');
		
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Error Callback');
			
				function _contact_error_cb(error){
		          	if (__error_cb) {
		            	var exception = new DeviceAPIError(error,"getContacts:Failed");
		            	__error_cb(exception);
					}
				}
				
			try{		
					var tidgl = getcontactscbmap.add(__succes_cb, __error_cb);
			    		
			    	ret=qtContactsIf.getContactsAsync( __match,__sort_order,tidgl );
			    				    	
			    	if (ret.ErrorCode != 0){				    	
				    	
				    	getcontactscbmap.remove(tidgl);
			    		
				    	if((ret.ErrorCode == error.INVALID_ARG_ERR)||(ret.ErrorCode == error.MISSING_ARG_ERR))		//throw only for these errors
			    		 	throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
			    		else
			    		{
			    			setTimeout(_contact_error_cb(ret.ErrorCode),10);	//All other errors returned asynchronously.why? ..."Thats what the spec says"
		    			}
		    		 }	
				}
				catch(er){
					throw(er);
					}
					
					return tidgl;				
        },

        /**
         * Get an iterator to the list of groups. This is an
         * asynchronous function. Returns a transaction id.
         * @param {function} successCallback  A function with the signature function({@link Iterator} of {@link GroupInfo}).
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_NOT_FOUND_ERR: no contacts are found.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id, that will be passed to the callback function too.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        </ul>
         */
        getGroups : function(__success_cb, __error_cb) {
	        
		        if(!__success_cb)
				throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
			
				if(__success_cb==null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
					
				if(__success_cb==undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
					
				if(typeof(__success_cb)=="undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');		
				
				if((typeof __success_cb) != "function" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'getGroups:Invalid Success Callback');
					
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroups:Invalid Error Callback');
		
					
				try{		
				
				var tidg2 = getgroupscbmap.add(__success_cb, __error_cb);
				ret=qtContactsIf.getGroupsAsync( tidg2 );
					
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
		
				}
				catch(er){
					throw(er);
				}
				
				return tidg2;			  
        
        },              
        /**
         * Adds a new contact to the default database. This is a synchronous function.
         * @param {ContactData} contact The new contact to be added. The id property is not
         *        needed, it will
         *        be ignored, addContact will generate an id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): contact is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): contact does not fit {@link ContactData} data scheme.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         * @return {string} The id of the added contact.
         */
        addContact: function(__acontact){
	            
	        	if((__acontact) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
				
				if((typeof __acontact) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
					
				if((__acontact) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
				
				if((typeof __acontact) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'addContact:Invalid Contact Data');
				
				var connectId	= 1;
				var ret 		= -1;
				try{	   		
				    	ret=qtContactsIf.addContact(  __acontact,connectId );
				    	
				    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
					}
				catch(er){
					throw(er);
					}
					
				return ret.ReturnValue;		
        },
        
        /**
         * Adds a new group to the default database. This is a synchronous function.
         * @param {string} groupName Specifies the name of the group to be added.
         * @return {string} The id of the added group.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): groupName is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): groupName is not a string.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         */
        addGroup: function(__agroupName){
	        
		        if((__agroupName) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((typeof __agroupName) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((__agroupName) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((typeof __agroupName) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'addGroup:Invalid Group Data')
				
				var ret 		= -1;
				try{	   		
				    	ret=qtContactsIf.addGroup(  __agroupName );
				    	
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
				
					}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;	
        },

        /**
         * Modifies an existing contact. This is a synchronous function.
         * The ContactData parameter object must contain valid a id (i.e., an id of a contact that
         * exists in the database). <b>Note:</b> if the id is not valid, then a new contact will be added.
         * @param {ContactData} contact This contains the details need to modify an existing contact.
         *         The <i>id</i> field in the ContactData object is mandatory. 
         *         If unexisting "id" is provided as input a new contact will be added to the database.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): contact is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): contact object missed an id field see {@link ContactData}.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         * @return {void}
         */
        updateContact: function(__acontact){
	        
		        if((__acontact) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
					
				if((typeof __acontact) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
					
				if((__acontact) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
				
				if((typeof __acontact) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateContact:Invalid Contact Data');
					
				if(typeof __acontact.id != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateContact:Invalid Contact Id');
				
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.updateContact(  __acontact,connectId );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;			
        
        },
        /**
         * Modifies an existing group. This is a synchronous function.
         * The GroupData parameter object must contain a valid id (i.e., an id of a group that
         * exists in the database).
         * @param {GroupData} group A GroupData instance, whose property values will
         *         replace the stored values of the group with the same id.
         *         The <i>id</i> field in the GroupData object is mandatory.
         *         If unexisting "id" is provided as input a new group will be added to the database.
         * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): group is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): group object missed an id field see {@link GroupData}.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         */
        updateGroup: function(__agroup){
            
        		if((__agroup) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data Needed');
					
				if((typeof __agroup) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data  Needed');
					
				if((__agroup) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data  Needed');
					
				if((typeof __agroup) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Data');
				
				if((__agroup.groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID Needed');
					
				if((typeof __agroup.groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID  Needed');
					
				if((__agroup.groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID  Needed');
				
				if(typeof __agroup.groupId != "string" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Id');
					
				if (__agroup.groupName) {
					if (typeof __agroup.groupName != "string") 
						throw new DeviceAPIError(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Name');
				}
				
				
				var ret 		= -1;
				try{
					
			    	ret=qtContactsIf.updateGroup(  __agroup );
		
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;    
        },
        /**
         * Deletes one or more existing contacts from the contacts database.
         * This is a synchronous function. If any of the contact ids passed is/are
         * parmeter are invalid, then no contact will be deleted.
         * @param {string[]} id The id of the contact or the ids of the contacts that are deleted.
         *                      May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string or array of strings.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if contact id specified is not found.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously.
         * @return {void}
         */
        deleteContacts: function(__Ids){
	        	if((__Ids) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
					
				if((typeof __Ids) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
					
				if((__Ids) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
				
					
				if((typeof __Ids) != "object")
				{
					if((typeof __Ids) == "string")
					{
						var idArray = new Array();
						idArray.push(__Ids);
						
						__Ids=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'deleteContact:Invalid Contact Data');
					}
				}				
			
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.deleteContacts(__Ids );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
			
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;		        
        },

        /**
         * Deletes one or more existing groups from the contacts database.
         * This is a synchronous function.
         * @alias ContactService.deleteGroups
         * @param {string[]} id The id of the group or ids of the groups that are deleted.
         *                      May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string or array of strings.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if group id specified is not found.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously.
         * @return {void}
         */
        deleteGroups: function(__groupIds){
	        
		        if((__groupIds) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((typeof __groupIds) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((__groupIds) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((typeof __groupIds) != "object")
				{
					if((typeof __groupIds) == "string")
					{
						var idArray = new Array();
						idArray.push(__groupIds);
						
						__groupIds=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'deleteGroups:Invalid Group Data');
					}
				}
								
				var ret 		= -1;
				try{	   		
			    	ret=qtContactsIf.deleteGroups(  __groupIds );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
			
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;	
        },
        
        /**
         * Retrieves data of a single contact. This is a
         * synchronous function.
         * @param {string} id The id of the contact whose data has to be retrieved.
         * @return {ContactData} The data of the contact, whose id matches the parameter <i>id</i>.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if contact id specified is not found.<br>
         */
        getContactInfo: function(__Id){

		        if((__Id) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((typeof __Id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((__Id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((typeof __Id) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactInfo:Invalid Contact ID');
						
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.getContactInfo(__Id );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;		        
        },
        
        /**
         * This function is used to retrieve details of a single group. This is an
         * synchronous function.
         * @param {string} id The id of the group that has to be retrieved.
         * @return {GroupInfo} The data of the group, whose id matches the parameter <i>id</i>.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if group id specified is not found.<br>
         */
        getGroupInfo: function(__group_id){
	        
			     if((__group_id) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
					
				if((typeof __group_id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
					
				if((__group_id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
				
				if((typeof __group_id) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupInfo:Invalid Group Id');
				
				var ret = -1;
				try{	   		
			    	ret = qtContactsIf.getGroupInfo( __group_id );
					//DEBUG(ret);
			    	
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				}
				catch(er){
					throw(er);
					}
				return ret.ReturnValue;
	        },
        
        /**
         * Get a list of contacts' id's. This is an
         * synchronous/asynchronous function. Returns a transaction id.
         * @param {function} successCallback A function with the signature function(string[]).
         *                  Upon the successful execution of operation , contactId(s) will be sent
         *                  to this function	
         * @param {string} [match] Specifies a matching filter for the contacts to return.
         *                  All the contacts whose fields name.last or name.first start with the string <i>match</i> in
         *                  will be listed.
         * @param {string} [sortOrder] Specifies the sort order, 0 indicates ascending, and 1 indicates descending.
         *                  The contacts are sorted by name.last, and name.first.  <b>Note:</b> sorting is not currently supported,
         *                  the list of contacts will not be sorted regardless of the value of this parameter.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_OUT_OF_RANGE_ERR: sortingOrder is not one of SORT_ASCENDING or SORT_DESCENDING.
         * </li>
         * <li>
         * DATA_NOT_FOUND_ERR: if no contacts match the parameters.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>match is not a string</li>  
         *                                                        <li>sortOrder is not a number</li>
         *                                                        </ul>
         */
        getContactIds: function(__succes_cb, __match, __sort_order, __error_cb){
	        
			    var connectId = -1;
			
				if((__succes_cb)||(__succes_cb!=null))
					if((typeof __succes_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid succes Callback');
				
				if((typeof __match) == "undefined")	
					__match = "";
					
				if((__match) == null)
					__match = "";
					
				if((typeof __match) != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Filter Criteria');	
					
				if((typeof __sort_order) == "undefined")
					__sort_order = this.SORT_ASCENDING;	
				
				if((__sort_order) == null)
					__sort_order = this.SORT_ASCENDING;
					
				if((__sort_order) == undefined)
					__sort_order = this.SORT_ASCENDING;
					
				if((typeof  __sort_order) != "number")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Success Callback');
		
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Error Callback');
					
				function _contact_error_cb(error){
		          	if (__error_cb) {
		            	var exception = new DeviceAPIError(error,"getContactIds:Failed");
		            	__error_cb(exception);
					}
				}
				
				if(__succes_cb){	//Async Processing
					try{		
					    	var transID1 = getIdscbmap.add(__succes_cb, __error_cb);
								
					    	ret=qtContactsIf.getContactIdsAsync( __match,__sort_order,transID1 );
					    	
					    	if (ret.ErrorCode != 0){
								getIdscbmap.remove(transID1);
					    		if((ret.ErrorCode == error.INVALID_ARG_ERR)||(ret.ErrorCode == error.MISSING_ARG_ERR))		//throw only for these errors
					    		 	throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
					    		else{
					    			setTimeout(_contact_error_cb(ret.ErrorCode),10);	//All other errors returned asynchronously.why? ..."Thats what the spec says"
				    			}
				    		 }	
						}
						catch(er){
							throw(er);
							}
							
							return transID1;
				}
				else{//sync processing
							try
							{
								ret=qtContactsIf.getContactIds( __match,__sort_order,connectId );
								
								if(ret.ErrorCode != 0)
									 throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);										
									
							}
							catch(er){
									throw(er);
								}
							return ret.ReturnValue;
					}
        },     
        

        
        /**
         * Get a list of groups' id's. This is an
         * asynchronous function. Returns a transaction id.
         * @param {function} [successCallback] A function with the signature function(string[]).
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_NOT_FOUND_ERR: if no groups are found.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function.</li>
         *                                                        <li>errorCallback is not a function.</li>
         *                                                        </ul>
         */
        getGroupIds: function(__succes_cb, __error_cb){
	        
        if((__succes_cb)||(__succes_cb!=null))
					if((typeof __succes_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupIds:Invalid succes Callback');
					
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupIds:Invalid Error Callback');
				
				
				if(__succes_cb){	//Async Processing
						try{		
			    				    	
							var transID2 = getIdscbmap.add(__succes_cb, __error_cb);
					    		
					    	ret=qtContactsIf.getGroupIdsAsync( transID2 );
					    	
							if (ret.ErrorCode != 0){
									  getIdscbmap.remove(transID2);
						    		  throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);													
							}

						}
						catch(er){
							throw(er+":GetList Failed");
							}
						return transID2;							
						
					}else{				//Sync Processing
							try
							{
								ret=qtContactsIf.getGroupIds();
								
								if(ret.ErrorCode != 0)
										 throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);										
									
							}
							catch(er){
									throw(er);
								}
							return ret.ReturnValue;
						
						
						}
        },
        
        /**
         * Add contacts to a group.
         * @param {string} groupId
         * @param {string[]} id Specifies the ids of contacts that are added to
         *                the group, whose id is <i>groupId</i>. May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>groupId is undefined.<li>
         *                                                      <li>id is undefined</li>
         *                                                      </ul>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>groupId is not a string.</li>
         *                                                         <li>id is not a string or array of strings.</li>
         *                                                      </ul> <br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if GroupId or id’s in idList are not found in database.  </li>                        
         *                           Code 102 (DATA_ALREADY_EXISTS_ERR) If a contact is added twice to one group.                           
         * @return {void}
         */
        addContactsToGroup: function(__groupId, __contactIDs){
	        
			    var ret 		= -1;
				
				if((__groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
					
				if((typeof __groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
					
				if((__groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
				
				if((typeof __groupId) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'addContactsToGroup:Invalid Group Id');
			
						
				if((__contactIDs) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
				
				if((__contactIDs) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
					
				if((typeof __contactIDs) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
					
				if ((typeof __contactIDs) != "object") {
					if((typeof __contactIDs) == "string")
					{
						var idArray = new Array();
						idArray.push(__contactIDs);
						
						__contactIDs=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'addContactsToGroup:Invalid contactIDs');
					}
				}
							
				try{	   		
			    	ret=qtContactsIf.addContactsToGroup(  __groupId , __contactIDs );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
			
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;
        },
        
        /**
         * Remove contacts from a group.
         * @param {string} groupId
         * @param {string[]} id Specifies the ids of contacts that are removed from
         *                the group, whose id is <i>groupId</i>. May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>groupId is undefined.<li>
         *                                                      <li>id is undefined</li>
         *                                                      </ul>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>groupId is not a string.</li>
         *                                                         <li>id is not a string or array of strings.</li>
         *                                                      </ul> <br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) If a contact is deleted from a group twice or if groupId provided is not found..                          
         * @return {void}
         */
        removeContactsFromGroup: function(__groupId, __contactIDs){

			    var ret 		= -1;
				
				if((__groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
					
				if((typeof __groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
					
				if((__groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
				
				if((typeof __groupId) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'removeContactsFromGroup:Invalid Group Id');
			
				if((__contactIDs) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
				
				if((__contactIDs) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
					
				if((typeof __contactIDs) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
					
				if ((typeof __contactIDs) != "object") {
					if((typeof __contactIDs) == "string")
					{
						var idArray = new Array();
						idArray.push(__contactIDs);
						
						__contactIDs=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'removeContactsFromGroup:Invalid contactIDs');
					}
				}
						
				try{	   		
			    	ret=qtContactsIf.removeContactsFromGroup(  __groupId , __contactIDs );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);		
				}
				catch(er){			
					throw(er);
					}
				
				return ret.ReturnValue;	        
        },
        
        /**
         * Cancels any asynchronous request identified uniquely by a trasactionId. This is synchronous API.
         * @param {number} transactionId
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request corresponds to the specified trasactionid.
         * @return {void}
         */
        cancel: function(__transaction_id){
	        
			     if((__transaction_id) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
				
				if((__transaction_id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
					
				if((typeof __transaction_id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
		
				if( ((typeof __transaction_id) != "number")  || (__transaction_id <=0) )
						throw new DeviceException(error.INVALID_ARG_ERR, 'cancel:TransactionID Needed');
						
				var ret = -1;
				try{
					ret = qtContactsIf.cancel( __transaction_id );
					
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				}
				catch(er){
					throw(er);
				}
				return ret.ReturnValue;

        },
        
        /**
         * Starts the device native contact editor UI with pre-populated contact data.
         * For the current implementation the parameter passed is an optional one.
         * <b>Note:</b> this function is not currently implemented, calling it will do nothing.
         * @param {function} callback A function with the signature function(data). This callback gets invoked in response to the user request of getting the list of Contacts.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * -NA-
         * </li>
         * </ul>
         * @return {void}
         * @throws    {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>contact does not fit {@link ContactData} data scheme.</li>  
         *                                                        </ul>
         */
        startEditor: function(__success_cb,__acontact, _error_cb){
	        
			    if(!__success_cb)
						throw new DeviceException(error.MISSING_ARG_ERR, 'StartEditor:Missing Success Callback');			
		
					if((typeof __success_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Success Callback');
	
					if(_error_cb)
						if((typeof _error_cb) != "function" )
							throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Error Callback');						
				
				
				if ((typeof __acontact) != "object") 					
					throw new DeviceException(error.INVALID_ARG_ERR, 'startEditor:Invalid Contact Data');			
							
					  
				    function contacts_cb(errCode, transId, result){   
							__success_cb(result);				
				    	}
				    
				    try{				    				
					var ret = qtContactsIf.startEditor(__acontact);
					__s60_start_and_wait('', contacts_cb);
										  
					  if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				    }
					 catch(er){
						   throw(er);
					 }

        },
		
		startNotification: function(__contact_cb, __error_cb){
			
			function __Notification_cb( err, trans, notifydata ){
				if(err == 0){
					success_cbk(notifydata);				
				}
				else{
					var deverr = new DeviceAPIError(err,"startNotification: Operation Failed");
					error_cbk(deverr);
				}
			} 
		
			
			if(!__contact_cb){
				throw new DeviceException(error.MISSING_ARG_ERR, 'startNotification:Missing Success Callback');
			}
				
			if(typeof __contact_cb != "function"){
				throw new DeviceException(error.INVALID_ARG_ERR, 'startNotification:Invalid type of success callback');
			}
				
			if(__error_cb){
				if(typeof __error_cb != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR, 'startNotification:Invalid type of error callback');
				}
			}
			
			var connectId = -1;
			connectId = qtContactsIf.addEventListener("asyncCallbackN(int,int,QMap<QString,QVariant>)",__Notification_cb);
				
			if( connectId < 0 ){
				//This should never happen, but adding as part of error handling - safety
				throw new DeviceException(error.NOT_ALLOWED_ERR, 'startNotification:Connect failed');
			}

			try{
	    	
	    	ret = qtContactsIf.startNotification( connectId );
				
				if( ret.ErrorCode != 0 ){
					qtContactsIf.removeEventListener( connectId );
					if(ret.ErrorCode == error.INVALID_ARG_ERR || ret.ErrorCode == error.MISSING_ARG_ERR || ret.ErrorCode == error.NOT_SUPPORTED_ERR){
						throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
					}
					else{
						if(__error_cb){
							setTimeout( function(){ 
													__error_cb(new DeviceAPIError(ret.ErrorCode, ret.ErrorMessage));
													}, 1000);
							qtContactsIf.removeEventListener(connectId);
						}
					}
					return;
				}
				
				success_cbk = __contact_cb;
				error_cbk = __error_cb;
				notificationId = connectId;
			}
			catch(e){
					//This should never happen, but adding as part of error handling - safety
					throw new DeviceException(error.NOT_ALLOWED_ERR, 'startNotification:Connect failed');
				}
			return;
		},
	
	/*
	 * public
	 * stopNotification
	 */
	stopNotification : function(){
		
		if( notificationId != -1 ){
			qtContactsIf.removeEventListener( notificationId );
			try{
				var ret = qtContactsIf.stopNotification();
				}
			catch(e){
				alert('this shld never happnd:'+e);
				//This should never happen, but adding as part of error handling - safety
				throw new DeviceException( error.NOT_ALLOWED_ERR, 'stopNotification:Operation failed');
			}
			
			if ( ret.ErrorCode != 0 ){
				alert( 'ret.ErrorCode:'+ret.ErrorCode);
				throw new DeviceException( ret.ErrorCode, ret.ErrorMessage );
			}
			notificationId = -1;
		}
		else{
			throw new DeviceException( error.DATA_NOT_FOUND_ERR, 'stopNotification:No pending notification present');
		}
	}
 }; //End of contacts return interface
	 
} //End contacts
/**
 * A wrapper JS class for objects implementing IFileSystem interface of FileSystem Plugin
 * @class FileSystem
 */

/**
 * @class
 */ 
nokia.device.FileSystem = function PSFileSystemInterface(){
	
	var DeviceException = nokia.device.DeviceException;
    var error = new DeviceException(0,'dummy');

	/*
	 * Internal
	 * qt FileSystem interface object.
	 */
	try {
		var fileSystemService = nokia._services.load("nokia.device.filesystem", "com.nokia.IFileSystem", "1.0");
	} 
	catch (er) {
		alert("Load Error:" + er);
		return;
	}
	
	/**
	 * Checks for the mandatory string type
	 */
	function _chkFS_MandatoryString(str, paramName)
	{
		if( (str == null) || (typeof str == 'undefined') )
			throw new DeviceException(error.MISSING_ARG_ERR, paramName);
	
		if(typeof str != 'string' )
			throw new DeviceException(error.INVALID_ARG_ERR, paramName);	
	}
	
	/**
	 * Checks for the optional string type
	 */
	function _chkFS_OptionalString(str, paramName)
	{
		if( (str != 'undefined') && (str != null)&& (typeof str != 'string') )
			throw new DeviceException(error.INVALID_ARG_ERR,paramName);
	}
	
	/**
	 * Checks for the optional function type
	 */
	function _chkFS_Optionalcallback(callback, paramName)
	{
		//if call back defined, not null and not a fn
		if( typeof callback != 'undefined' )
		{
			if( ( callback != null ) && (typeof callback != 'function') )
				throw new DeviceException(error.INVALID_ARG_ERR, paramName);
		}
	}
	
	/**
	 * Checks for the mandatory function type
	 */
	function _chkFS_Mandatorycallback(callback, paramName)
	{
		if( (typeof callback == 'undefined') || (callback == 'null') )
			throw new DeviceException(error.MISSING_ARG_ERR,paramName);
			
		if(typeof callback != 'function')
			throw new DeviceException(error.INVALID_ARG_ERR,paramName);
	}
	
	/**
	 * Checks for the optional boolean type
	 */
	function _chkFS_OptionalBool(boolVal, paramName)
	{
		if( (boolVal != 'undefined') && (boolVal != null) && (typeof boolVal != 'boolean') )
			throw new DeviceException(error.INVALID_ARG_ERR, paramName);
	}
	
	/**
	 * Checks for the mandatory number type
	 */
	function _chkFS_MandatoryNumber(numberVal, paramName)
	{
		if( (numberVal == null) || (typeof numberVal == 'undefined') )
			throw new DeviceException(error.MISSING_ARG_ERR, paramName);
	
		if(typeof numberVal != 'number' )
			throw new DeviceException(error.INVALID_ARG_ERR, paramName);
	}
	
	/**
	 * Checks for the optional number type
	 */
	function _chkFS_OptionalNumber(numberVal, paramName)
	{
		if( (numberVal != 'undefined') && (numberVal != null)&& (typeof numberVal != 'number') )
			throw new DeviceException(error.INVALID_ARG_ERR,paramName);
	}
	
	/**
	 * Checks for the mandatory object type
	 */
	function _chkFS_MandatoryObject(matchObj, paramName)
	{
		if( (matchObj == null) || (typeof matchObj == 'undefined') )
			throw new DeviceException(error.MISSING_ARG_ERR, paramName);
	
		if(typeof matchObj != 'object' )
			throw new DeviceException(error.INVALID_ARG_ERR, paramName);	
	}	
	
/**
 * @class
 */
 	function FileHandle(id){
	    var handleId = id;
		
		return{
		/**
		 * Calls close method of fileSystemService that implements IFileSystem interface 
		 * of FileSystem Plugin
		 *
		 * @function close
		 * @param {function} successCB - success call back function
		 * @param {function} errorCB - error call back function
		 * @returns trans Id in async mode
		 */
		close : function(successCB, errorCB){
			
			_chkFS_Optionalcallback(successCB, 'success callback');
			_chkFS_Optionalcallback(errorCB, 'error Callback');
		
			var connectId = -1;	
			if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
			{
				connectId = fileSystemService.addEventListener('closeSignal(int , QVariant)', closeCB );
			}
		
		    var retValue = fileSystemService.close(handleId, connectId);
					
			if (connectId != -1) 
			{//async call
				return retValue;//returning trans id
			}
			else
			{//sync call
				if (retValue.ErrorCode)
					throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
			}
			
			function closeCB(tid, output)
			{			
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}	
		},//end of close
			/**
			 * Calls read method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function read
			 * @param {int} count - length of data to be read
			 * @param {int} position - position in file from where to read from
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns Data read for sync call and transactin id for async calls
			 */
			read : function(count, position, successCB, errorCB){
			
				_chkFS_MandatoryNumber(count,'length to read is invalid');
				_chkFS_OptionalNumber(position, 'position is invalid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
							  
				if( (position) && position < 0 )
				{
					throw new DeviceException(error.DATA_OUT_OF_RANGE_ERR,'position');
				}
				
			  if( (position == 'undefined') || (position == null) )
					position = -1;
			
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('readSignal(int , QVariant)', readCB );
				}			
			
				var retValue = fileSystemService.read(handleId, count, position, connectId); 
			
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
					else
						return retValue.data;		
				}
				
				function readCB(tid, output)
				{
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB(output.data);
								}
						}
					}		
				}
			},//end of read
			
			/**
			 * Calls readLine method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function readLine
			 * @param {int} count - length of data to be read
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns Data read for sync call and transactin id for async calls
			 */
			readLine : function(count, successCB, errorCB){
				
				_chkFS_OptionalNumber(count,'data length invalid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
				
				
			  if(count == 'undefined' || count == null)
					count = 0;
			  
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('readLineSignal(int , QVariant)', readLineCB );
				}			
			
				var retValue = fileSystemService.readLine(handleId, count, connectId); 
			
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
					else
						return retValue.data;		
				}
				
				function readLineCB(tid, output)
				{
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB(output.data);
								}
						}
					}
				}
			},//end of readline
			
			/**
			 * Calls readBase64 method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function readBase64
			 * @param {int} count - length of data to be read
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns Data read for sync call and transactin id for asycn calls
			 */
			readBase64 : function(count, successCB, errorCB){
				
				_chkFS_MandatoryNumber(count,'byte count invalid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
				
			
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('readBase64Signal(int , QVariant)', readBase64CB );
				}			
			
				var retValue = fileSystemService.readBase64(handleId, count, connectId); 
			
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
					else
						return retValue.data;		
				}
				
				function readBase64CB(tid, output)
				{			
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB(output.data);
								}
						}
					}		
				}
			},//end of readase64
			
			/**
			 * Calls write method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function write
			 * @param {string} data - data to be written in the file
			 * @param {pos} data - postion in which data has to be written
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns transaction id for async calls
			 */
			write : function(data, position, successCB, errorCB){
				
				_chkFS_MandatoryString(data,'data not valid');
				_chkFS_OptionalNumber(position, 'position invalid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
				
			  
				if( position < 0 )
				{
					throw new DeviceException(error.DATA_OUT_OF_RANGE_ERR,'position');
				}
				
				if(position == 'undefined' || position == null)
					position = -1;	
			  
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('writeSignal(int , QVariant)', writeCB );
				}			
			
				var retValue = fileSystemService.write(handleId, data, position, connectId); 
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
				}
				
				function writeCB(tid, output)
				{	
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB();
								}
						}
					}		
				}
			},//end of write
						
			/**
			 * Calls writeLine method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function writeLine
			 * @param {string} data - data to be written in the file
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns transaction id for async call
			 */
			writeLine : function(data, successCB, errorCB){
	
				_chkFS_MandatoryString(data,'data not valid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
				
				
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('writeLineSignal(int , QVariant)', writeLineCB );
				}			
			
			 	var retValue = fileSystemService.writeLine(handleId, data, connectId); 
			
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
				}
				
				function writeLineCB(tid, output)
				{
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB();
								}
						}
					}		
				}
			},//end of writeline
			
			/**
			 * Calls writeBase64 method of fileSystemService that implements IFileSystem interface 
			 * of FileSystem Plugin
			 *
			 * @function writeBase64
			 * @param {string} data - data to be written in the file
			 * @param {function} successCB - success call back function
			 * @param {function} errorCB - error call back function 
			 * @returns transaction id for async calls
			 */
			writeBase64 : function(data, successCB, errorCB){
			
				_chkFS_MandatoryString(data,'data not valid');
				_chkFS_Optionalcallback(successCB,'success Callback');
				_chkFS_Optionalcallback(errorCB,'error Callback');
				
				 	
				var connectId = -1;	
				if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
				{
					connectId = fileSystemService.addEventListener('writeBase64Signal(int , QVariant)', writeBase64CB );
				}
			
				var retValue = fileSystemService.writeBase64(handleId, data, connectId); 
			
				if (connectId != -1) 
				{//async call
					return retValue;//returning trans id			
				}
				else
				{//sync call
					if (retValue.ErrorCode)
						throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
				}
				
				function writeBase64CB(tid, output)
				{
					if(tid == connectId)
					{
						fileSystemService.removeEventListener(tid);
						if( output.ErrorCode )
						{
							//if error callback is defined call it, else ignore the result
							if( typeof errorCB == 'function' )
								{
									errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
								}
						}
						else
						{
							//if success callback is defined call it, else ignore the result
							if( typeof successCB == 'function' )
								{
									successCB();
								}
						}
					}		
				}
			}, // end of writebase64			
			
		/**
		 * Calls flush method of fileSystemService that implements IFileSystem interface 
		 * of FileSystem Plugin
		 *
		 * @function flush
		 * @param {function} successCB - success call back function
		 * @param {function} errorCB - error call back function
		 * @returns trans Id in async mode
		 */
		
		flush : function(successCB, errorCB){

			_chkFS_Optionalcallback(successCB, 'success callback');
			_chkFS_Optionalcallback(errorCB, 'error Callback');
			
		
			var connectId = -1;
			if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
			{
				connectId = fileSystemService.addEventListener('flushSignal(int, QVariant)', flushCB );
			}
		
		    var retValue = fileSystemService.flush(handleId, connectId);
			if (connectId != -1) {//async call
				return retValue;//returning trans id
			}
			else{//sync call
				if (retValue.ErrorCode)
					throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
			}
		
			function flushCB(tid, output)
			{				
				if(tid == connectId)
				{
					fileSystemService.removeEventListener(tid);
					if( output.ErrorCode )
					{
						//if error callback is defined call it, else ignore the result
						if( typeof errorCB == 'function' )
							{
								errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
							}
					}
					else
					{
						//if success callback is defined call it, else ignore the result
						if( typeof successCB == 'function' )
							{
								successCB();
							}
					}
				}		
			}
		},//end of flush
		
		/**
		 * Calls seek method of fileSystemService that implements IFileSystem interface 
		 * of FileSystem Plugin
		 *
		 * @function seek
		 * @param {int} seekOption - seekOption should SEEKSTART, SEEKCURRENT, SEEKEND
		 * @param {int} position - postion to be moved
		 * @returns trans Id in async mode
		 */
		
		seek : function(seekOption, position){			
			_chkFS_MandatoryNumber(seekOption, 'seek Option invalid');
			_chkFS_OptionalNumber(position, 'position invalid');
		
			if( (position == null) || (typeof position == 'undefined') )
				position = 0;
		
		    var retValue = fileSystemService.seek(handleId, seekOption, position);
		
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
			else
				return retValue.data;
		} //end of seek	
			
				
		};//end of file handle return
	}//end of file handle class
	
	return{
    /**
    * @constant {String} 
    * interfaceName.
    */	
    interfaceName: "filesystem",
    /**
    * @constant {Number} 
    * version.
    */      
    version: nokia.device._interfaces['filesystem'],
	/**
	 * 
	 * @constant {Number} file seek constants
	*/
	SEEKSTART	: 0,
	/**
	 * 
	 * @constant {Number} file seek constants
	*/	
	SEEKCURRENT : 1,
	/**
	 * 
	 * @constant {Number} file seek constants
	*/		
	SEEKEND	    : 2,
	/**
	 * 
	 * @constant {Number} memory type constants
	*/			
	INTERNAL : 0,
	/**
	 * 
	 * @constant {Number} memory type constants
	*/	
	REMOVABLE : 1,
	/**
	 * 
	 * @constant {Number} memory type constants
	*/	
	REMOTE : 2,
	/**
	 * 
	 * @constant {Number} memory type constants
	*/	
	UNKNOWN : 3,	
	/**
	 * 
	 * @constant {Number} connect status constants
	*/	
	DISCONNECTED : 0,
	/**
	 * 
	 * @constant {Number} connect status constants
	*/	
	CONNECTED : 1,
	
	/**
	 * 
	 * @constant {Number} search constants
	*/	
	PARTIAL : 0,
	/**
	 * 
	 * @constant {Number} search constants
	*/	
	COMPLETE : 1,
	/**
	 * 
	 * @constant {Number} element type constants
	*/		
	FILE : 0,
	/**
	 * 
	 * @constant {Number} element type constants
	*/		
	DIRECTORY : 1,
	/**
	 * 
	 * @constant {Number} element type constants
	*/		
	LINK : 2,

	
	
	/**
	 * Calls createDir method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function createDir
	 * @param {string} Uri - Uri path to be created in the file system
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */		
	createDir : function(SrcUri, successCB, errorCB){
		_chkFS_MandatoryString(SrcUri,'Uri');
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
	
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('createDirSignal(int, QVariant)', createDirCB );
		}
		
	  var retValue = fileSystemService.createDir(SrcUri,connectId);
	    
		if (connectId != -1) {//async call
			return retValue;//returning trans id
		}
		else{//sync call		
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
		}
	
		function createDirCB(tid, output)
		{		
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}				
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}
		}
	},//end of createDir
	
	/**
	 * Calls rename method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function rename
	 * @param {string} SrcUri - Source Uri path to be renamed in the file system
	 * @param {string} NewName - new name for the Source.
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	rename : function(SrcUri, NewName, successCB, errorCB){

		_chkFS_MandatoryString(SrcUri,'Source Uri');
		_chkFS_MandatoryString(NewName,'New Name');//new name is a mandatory param here
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
	
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('renameSignal(int, QVariant)', renameCB );
		}
	
	    var retValue = fileSystemService.rename(SrcUri, NewName, connectId);
		
		if (connectId != -1) {//async call
			return retValue;//returning trans id
		}
		else{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
		}		
	
		function renameCB(tid, output)
		{
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}		
				}
				else
				{								
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}
		}
 	},//end of rename
	
	/**
	 * Calls getDirContents method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function getDirContents
	 * @param {string} SrcUri - Source direcorty Uri
	 * @param {string} matchPattern - items to be matched.
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	getDirContents : function(SrcUri, matchPattern, successCB, errorCB){
			
		_chkFS_MandatoryString(SrcUri,'Source Uri');
		_chkFS_OptionalString(matchPattern, 'match Pattern');	
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');	
		
	
		if( (matchPattern == 'undefined') || (matchPattern == null) )
			matchPattern = '*';
	
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('getDirContentsSignal(int , QVariant)', getDirContentsCB );
		}		
	
	    var retValue = fileSystemService.getDirContents(SrcUri, matchPattern, connectId);
		
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
			else
				return retValue.data;	
		}
		
		function getDirContentsCB(tid, output)
		{	
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB(output.data);
						}
				}
			}
		}
	},//end of getDirContents

	/**
	 * Calls getElementInfo method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function getElementInfo
	 * @param {string} SrcUri - Source direcorty Uri
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	getElementInfo : function(SrcUri, successCB, errorCB){
			
		_chkFS_MandatoryString(SrcUri,'Source Uri');	
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');	
	
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('getElementInfoSignal(int , QVariant)', getElementInfoCB );
		}

	    var retValue = fileSystemService.getElementInfo(SrcUri, connectId);
		
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
			else
				return retValue.data;	
		}
		
		function getElementInfoCB(tid, output)
		{
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB(output.data);
						}
				}
			}
		}
	},//end of getElementInfo
	
	/**
	 * Calls remove method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function remove
	 * @param {string} SrcUri - Source Uri path to be renamed in the file system
	 * @param {boolean} recursive - new name for the Source.
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	remove : function(SrcUri, recursive, successCB, errorCB){
	
		_chkFS_MandatoryString(SrcUri,'Source Uri');
		_chkFS_OptionalBool(recursive,'recursive');
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
			
		if( (typeof recursive == 'undefined') || (recursive == null) )
			recursive = false;
	
		var connectId = -1;	
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('removeSignal(int , QVariant)', removeCB );
		}		
		
	    var retValue = fileSystemService.remove(SrcUri, recursive, connectId);
		
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);		
		}
		
		function removeCB(tid, output)
		{	
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{									
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}
		}	
	},//end of rename
	
	/**
	 * Calls cancel method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function cancel
	 * @param {string} tid - transaction id
	 * @returns None
	 */
	cancel : function(tid){
		
		_chkFS_MandatoryNumber(tid, 'Transaction Id');
	
	    var retValue = fileSystemService.cancel(tid);
	
		if (retValue.ErrorCode)
		{
			throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
		}		
		else
		{
			//if cancel is success remove the event listener based on tid
			fileSystemService.removeEventListener(tid);
		}
		
	},//end of cancel
	
	/**
	 * Calls openFile method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function openFile
	 * @param {string} uri - uri of the file
	 * @param {string} mode - mode in which the file should be opened.
	 * @param {string} encoding - encoding format.
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode or file handle in sync mode
	 */
	openFile : function(fileUri, openMode, encoding, successCB, errorCB){
	
		_chkFS_MandatoryString(fileUri,'uri');
		_chkFS_MandatoryString(openMode,'mode');
		_chkFS_MandatoryString(encoding,'encoding');	
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');	
		
	
		var connectId = -1;	
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('openFileSignal(int , QVariant)', openFileCB );
		}					
	
	    var retValue = fileSystemService.openFile(fileUri, openMode, encoding, connectId);
			
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
			else
				return new FileHandle(retValue.data);				
		}	
		
		function openFileCB(tid, output)
		{
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB(new FileHandle(output.data, fileSystemService));
						}
				}
			}				
		}			
	},//end of openFile
	
	/**
	 * Calls copy method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function copy
	 * @param {string} SrcUri - Source path
	 * @param {string} DestUri - Destination path
	 * @param {string} newName - new name
	 * @param {boolean} overWrite - overwrite option
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns None
	 */
	copy : function(SrcUri, DestUri, newName, overWrite, successCB, errorCB){
	
		_chkFS_MandatoryString(SrcUri,'SrcUri');
		_chkFS_MandatoryString(DestUri,'DestUri');	
		_chkFS_OptionalString(newName,'new Name');
		_chkFS_OptionalBool(overWrite, 'overWrite');
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
		
		if( (typeof newName == 'undefined') || (newName == null))
			newName = "";			
	
		if( (typeof overWrite == 'undefined') || (overWrite == null))
			overWrite = false;	
	
		var connectId = -1;	
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('copySignal(int , QVariant )', copyCB );
		}
	
		var retValue = fileSystemService.copy(SrcUri, DestUri, newName, overWrite, connectId);
	
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
		}
	
		function copyCB(tid, output)
		{
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
								errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));						
						}
				}
				else
				{									
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}
		}
	},//end of copy
	
	/**
	 * Calls move method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function move
	 * @param {string} SrcUri - Source path
	 * @param {string} DestUri - Destination path
	 * @param {string} newName - new name
	 * @param {boolean} overWrite - overwrite option
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns None
	 */
	move : function(SrcUri, DestUri, newName, overWrite, successCB, errorCB){
	
		_chkFS_MandatoryString(SrcUri,'SrcUri');
		_chkFS_MandatoryString(DestUri,'DestUri');	
		_chkFS_OptionalString(newName,'new Name');
		_chkFS_OptionalBool(overWrite, 'overWrite');
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');	
			
		
		if( (typeof newName == 'undefined') || (newName == null))
			newName = "";
	
		if( (typeof overWrite == 'undefined') || (overWrite == null))
			overWrite = false;
	
		var connectId = -1;	
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{	
			connectId = fileSystemService.addEventListener('moveSignal(int , QVariant )', moveCB );
		}
			
		var retValue = fileSystemService.move(SrcUri, DestUri, newName, overWrite, connectId);
	
		if (connectId != -1) 
		{//async call
			return retValue;//returning trans id
		}
		else
		{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);	
		}
	
		function moveCB(tid, output)
		{
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{									
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB();
						}
				}
			}
		}
	},//end of move
	
	/**
	 * Calls search method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function search
	 * @param {function} successCB - success call back function
	 * @param {string} matchPattern - items to be matched.
	 * @param {string} SrcUri - Source directory Uri
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	search : function(successCB, matchPattern, SrcUri, errorCB){
	
		_chkFS_Mandatorycallback(successCB,'callback');
		_chkFS_MandatoryString(matchPattern, 'matchPattern');
		_chkFS_MandatoryString(SrcUri, 'SrcUri');
		_chkFS_Optionalcallback(errorCB,'errorCB');
							
	
		var connectId = fileSystemService.addEventListener('searchSignal(int , QVariant)', searchCB );	
	
		//returning trans id
	    return fileSystemService.search(connectId, matchPattern, SrcUri);
	
		function searchCB(tid, output)
		{
			if (tid == connectId) 
			{
				if ( output.ErrorCode )//if some error
				{
					fileSystemService.removeEventListener(tid);
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}				
				}
				else
				{
					if(output.data.state == 1)//Search COMPLETE == 1
					{
						fileSystemService.removeEventListener(tid);
					}							
					successCB(output.data);
				}
			}		
		}
	},//end of search
	
	/**
	 * Calls getMountPoints method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function getMountPoints
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	getMountPoints : function(successCB, errorCB){
				
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
		
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('getMountPointsSignal(int, QVariant)', getMountPointsCB );
		}
		
	    var retValue = fileSystemService.getMountPoints(connectId);
		if (connectId != -1) {//async call
			return retValue;//returning trans id
		}
		else{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);			
			else
			    return retValue.data;
		}
		
		function getMountPointsCB(tid, output)
		{		
		if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB(output.data);
						}
				}
			}
		}
	},//end of getMountPoints
	

	/**
	 * Calls getDefaultPath method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function getDefaultPath
	 * @param {string} contentType - content type
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	getDefaultPath : function(contentType,successCB, errorCB){
	
		_chkFS_OptionalString(contentType, 'content Type');
		_chkFS_Optionalcallback(successCB, 'success callback');
		_chkFS_Optionalcallback(errorCB, 'error Callback');
		
		
		if(contentType == "")
		{
			throw new DeviceException(error.INVALID_ARG_ERR,'contentType');
		}
	
		if( (contentType == null) || (typeof contentType == 'undefined') )		    
			contentType = "";
					
		var connectId = -1;
		if( (typeof successCB == 'function') || (typeof errorCB == 'function') )
		{
			connectId = fileSystemService.addEventListener('getDefaultPathSignal(int, QVariant)', getDefaultPathCB );
		}
		
	    var retValue = fileSystemService.getDefaultPath(contentType, connectId);
		if (connectId != -1) {//async call
			return retValue;//returning trans id
		}
		else{//sync call
			if (retValue.ErrorCode)
				throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
			else
				return retValue.data;
		}
		
		function getDefaultPathCB(tid, output)
		{		
			if(tid == connectId)
			{
				fileSystemService.removeEventListener(tid);
				if( output.ErrorCode )
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}
				}
				else
				{
					//if success callback is defined call it, else ignore the result
					if( typeof successCB == 'function' )
						{
							successCB(output.data);
						}
				}
			}
		}
	},//end of getDefaultPath
	
	/**
	 * Calls notifyMountEvents method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function notifyMountEvents
	 * @param {function} successCB - success call back function
	 * @param {function} errorCB - error call back function
	 * @returns trans Id
	 */
	notifyMountEvents : function(successCB, errorCB){

		_chkFS_Mandatorycallback(successCB,'success callback');			
		_chkFS_Optionalcallback(errorCB,'error callback');
		
		var connectId = -1;
		connectId = fileSystemService.addEventListener('notifyMountEventsSignal(int, QVariant)', notifyMountEventsCB );
	
	    var retValue = fileSystemService.notifyMountEvents(connectId);
		if(retValue.ErrorCode) //if request already gng on
		{
			fileSystemService.removeEventListener(connectId);
			throw new DeviceException(retValue.ErrorCode,retValue.ErrorMessage);
		}
		else
		{
			//dont return the dummy trans id.
			//return retValue.data;
		}
	
		function notifyMountEventsCB(tid, output)
		{	
			if ( output.code )//if some error
			{
				//if error callback is defined call it, else ignore the result
				if( typeof errorCB == 'function' )
				{
					errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
				}
			}
			else
			{
				successCB(output.data);
			}		
		}
	},//end of notifyMountEvents
	
	/**
	 * Calls cacelNotify method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function cacelNotify
	 * @returns None
	 */
	cancelNotify : function(){
	
	    var retValue =  fileSystemService.cancelNotify();
		
		if (retValue.ErrorCode) {
			throw new DeviceException(retValue.ErrorCode, retValue.ErrorMessage);
		}
		else 
		{
			fileSystemService.removeEventListener(retValue.data);
		}
	},//end of cancelNotify
	
	/**
	 * Calls search_matchObject method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function searchMatchObject
	 * @param {function} successCB - success call back function
	 * @param {string} matchObject - items to be matched.
	 * @param {function} errorCB - error call back function
	 * @returns trans Id in async mode
	 */
	searchMatchObject : function(successCB, matchObject, errorCB){
		_chkFS_Mandatorycallback(successCB,'callback');
		_chkFS_MandatoryObject(matchObject, 'matchObject');
		_chkFS_Optionalcallback(errorCB,'errorCB');

		var connectId = -1;
		connectId = fileSystemService.addEventListener('searchMatchObjectSignal(int , QVariant)', searchMatchObjectCB);
		
		//returning trans id
	    return fileSystemService.searchMatchObject(connectId, matchObject);
	
		function searchMatchObjectCB(tid, output)
		{
			if (tid == connectId) 
			{
				fileSystemService.removeEventListener(tid);
				if ( output.ErrorCode )//if some error
				{
					//if error callback is defined call it, else ignore the result
					if( typeof errorCB == 'function' )
						{
							errorCB(new DeviceException(output.ErrorCode, output.ErrorMessage));
						}				
				}
				else
				{
					successCB(output.data);
				}
			}		
		}
	},//end of search	
	
	/**
	 * Calls mount method of fileSystemService that implements IFileSystem interface 
	 * of FileSystem Plugin
	 *
	 * @function mount
	 * @param {string} virtualPath - virtual path to be mounted
	 * @param {string} defaultPathKey - specifies the key for which CJSE default path	 
	 * should be obtained and mapped to the specified virtualPath
	 * @returns 
	 */
	mount : function(virtualPath,defaultPathKey){
		fileSystemService.mount(virtualPath,defaultPathKey);
	}//end of mount

	};//end of filesystem object return
}//end of filesystem class
/**
 * @author 
 */
/**
 * @class
 */

nokia.device.Geolocation = function PSGeoLocation(){
    function PositionError()
	{
		this.UNKNOWN_ERROR = 0;
		this.PERMISSION_DENIED = 1;
		this.POSITION_UNAVAILABLE = 2;
		this.TIMEOUT = 3;
		this.code ;
		this.message ;
	}
	function Coordinates()
	{
		this.latitude = null;
		this.longitude = null;
		this.altitude = null;
		this.accuracy = null;
		this.altitudeAccuracy = null;
		this.heading = null;
		this.speed = null;
	}
	function Position()
	{
		this.coords = null;
		this.timestamp = null;
	}
	function PositionOptions()
	{
		this.enableHighAccuracy ;
		this.timeout;
		this.maximumAge;
	}
	function errorObject()
	{
		this.ErrArgument = -6;
		this.ErrNotSupported = -5;
		this.ErrInUse = -14;
		this.ErrAccessDenied = -21;
		this.ErrNotFound = -1;
		this.ErrGeneral = -2;
		this.ErrDeviceNotReady = -18;
	}
	function convertToCjseError(cjseError)
	{
		var locException = new nokia.device.DeviceException(0,"");
		var errObject = new Object();
		switch(cjseError){
			case this.ErrArgument:
				errObject.code = locException.INVALID_ARG_ERR;
				errObject.message ="one of the argument supplied is not proper";
				break;
			case this.ErrNotSupported:
				errObject.code = locException.NOT_SUPPORTED_ERR;
				errObject.message ="requested service not supported";
				break;
			case this.ErrInUse:
				errObject.code = locException.SERVICE_IN_USE_ERR;
				errObject.message ="requested service is already in use";
				break;	
			case this.ErrDeviceNotReady:
				errObject.code = locException.NOT_ALLOWED_ERR;
				errObject.message ="service not ready";
				break;	
			default:
				errObject.code = -101;
				errObject.message = "unknown";									
				
		}
		return errObject;
	}
	function __sp_location_handle_error(errorCallback,errorCode)
	{
		if( (errorCallback != undefined) && (typeof errorCallback == 'function') && (errorCallback != null) )
		{
			//create a new position error object
			var posError = new PositionError(); 
			if( (-21) == errorCode )
			{
				posError.code = posError.PERMISSION_DENIED;
				posError.message = "permission denied";
				
			}
			else if( (-33) == errorCode )
			{
	
				posError.code = posError.TIMEOUT;
				posError.message = "request timed out";
	
				
			}
			else 
			{
				posError.code = posError.UNKNOWN_ERROR;
				posError.message = "UnKnown Error";
				
			}
			
			//Invoke user supplied error callback
			errorCallback( posError );
			
		} else {
			var posError = new PositionError();
			posError.code = posError.UNKNOWN_ERROR;
			posError.message = "UnKnown Error";
			throw posError;
		}
		
		
		
	}
	function isInputValid(__pos_opt)
	{
		////alert("input validation starts");
		////alert("typeofinp="+typeof(__pos_opt));
		
		var isValid = true;
		//special check for  0
		if ((__pos_opt !== undefined)
		    && (typeof(__pos_opt) === "number")) {
			return false;
		}
		if ((__pos_opt === undefined) 
		    ||(__pos_opt === null)
			||(__pos_opt === "")) {
				
			return true;
		}
		if((typeof(__pos_opt) != "object")) {
			return false;	
		} 
			
		////alert("object check ok");		
		
		if((__pos_opt.enableHighAccuracy !== undefined ))
		{
			if ((__pos_opt.enableHighAccuracy === null) || (__pos_opt.enableHighAccuracy === "")) {
				if(typeof(__pos_opt.enableHighAccuracy) != "number") {
					isValid =  true;
				}	
			} else 
			{
				if (typeof(__pos_opt.enableHighAccuracy) != "boolean") {
					return false;
				}
			}
			
		}
		////alert("accuracy ok");
			
		if (__pos_opt.timeout !== undefined) {
			if ((__pos_opt.timeout === null)
			    || ((__pos_opt.timeout === ""))) {
					
				isValid =  true;	
				
			}
			else if (typeof(__pos_opt.timeout) != "number")
				return false;
			else if(isNaN(__pos_opt.timeout) || (__pos_opt.timeout == Infinity))
				return false;
		}
		////alert("TO ok");
		if (__pos_opt.maximumAge !== undefined) {
			if ((__pos_opt.maximumAge === null)
			    || ((__pos_opt.maximumAge === ""))) {
					
				isValid =  true;	
				
			}
			else if (typeof(__pos_opt.maximumAge) != "number")
				return false;
			else if(isNaN(__pos_opt.maximumAge)|| (__pos_opt.maximumAge == Infinity))
				return false;
		}
		
		////alert("all ok exiting validation");
		return isValid;
		   
	}
	function watchIndex()
	{
		this.watchId;
		this.connectId;
	}
	var watchArray = new Array();
	
   /**
    * Internal
    * Geolocation interface object.
    */

    var qtGeolocationIf = nokia._services.load("nokia.device.geolocation", "com.nokia.ILocation", "1.0");
		var locException = new nokia.device.DeviceException(0,"");
		var asyncReqObj = asyncCallbackMap;
		var connectId = qtGeolocationIf.addEventListener("MethodAsyncCallback(int,int,const QMap<QString,QVariant>&,QString)",__CJSE_CALLBACK);
        if (connectId < 0) {
            throw ("Connect Failed:" + connectId);
        }
	
    function __CJSE_CALLBACK(id1, id2, id3,mName){
		//alert("inside PS Location callback");
		var retObj = asyncReqObj.get(id2);
		asyncReqObj.remove(id2);
		
		if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
		var callback = retObj.success_cb;
        var errCbk = retObj.error_cb;
		
		if(id1 != 0) {
			//alert("pf error code="+id1);
			//qtGeolocationIf.removeEventListener(connectId);
			//alert("listener removed");
			
			if (errCbk) {
				var errObj = convertToCjseError(id1);
				var errObj =  new nokia.device.DeviceAPIError(errObj.code,errObj.message);
				if (errCbk){
					errCbk(errObj,mName);	
				}
				
			}
			
		}
		else {
			//alert("inside pf scb");
			//alert("creating _pos_coord");
			var _pos_coord = new Coordinates();
			//alert("longitude="+id3.longitude);
			if(id3.longitude && !isNaN(id3.longitude)){
				_pos_coord.longitude = id3.longitude;
			}
			//alert("latitude="+id3.latitude);
			if(id3.latitude && !isNaN(id3.latitude)){
				_pos_coord.latitude = id3.latitude;
			}
			//alert("altitude="+id3.altitude);
			if(id3.altitude && (!isNaN(id3.altitude))){
				_pos_coord.altitude = parseFloat(id3.altitude);
			}
			
			if(id3.accuracy && (!isNaN(id3.accuracy))){
				_pos_coord.accuracy = parseFloat(id3.accuracy);
			}
			
			if(id3.altitudeAccuracy ){
				if(!isNaN(id3.altitudeAccuracy)){
					_pos_coord.altitudeAccuracy = parseFloat(id3.altitudeAccuracy);	
				}
					
				
			}
			//alert("creating position object");
			//Position Object
			var _pos_data = new Position();
			_pos_data.coords = new Object();
			
			_pos_data.coords =_pos_coord;
			//alert("time="+id3.timestamp);
			if(id3.timestamp){
				_pos_data.timestamp = id3.timestamp;
			}
			
			
			//qtGeolocationIf.removeEventListener(connectId);
			//Invoke consumer callback
			//alert("ps callback longitude="+_pos_data.coords.longitude);
			//alert("callback set="+callback);
			//alert("cjse methodname="+id3.methodname)
			callback( _pos_data,mName );
		}
	}
    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "geolocation",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['geolocation'],
	    /**
	     * Gets the current position of the hosting device.
	     * This is an asynchronous API.
	     * <br><br>
	     * @param {function} callback A callback function with the signature
	     *                     <i>function({@link Position} )</i>
	     *                     Position contains location coordinate in WGS-84 representation
	     *                     as well as time stamp when this coordinate was obtained.
	     * @param {function} [errorCallback] This callback function is optional and when supplied gets invoked with
	     * {@link PositionError} object when error occurs in processing the  request.
	     * @param {object} [__pos_opt] optional position option see {@link PositionOptions} for details
	     * @return none
	     * @exception  					Code 0 (UNKNOWN_ERROR): Parametrs supplied are invalid and error callback is not supplied 
	     *                              or is invalid.
	     *                              <br>
	     *                              
	     */
		getPositionUsingMethodName : function (callback,methodName,errCbk) {
			//alert("inside cjse getmethodname");
			
			if (!callback) {
				
				throw new nokia.device.DeviceException(locException.MISSING_ARG_ERR,
													   "callback must be supplied");
				
			}
			if (typeof (callback) != "function"){
				throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "callback should be a function");
			}
			if (!methodName) {
				throw new nokia.device.DeviceException(locException.MISSING_ARG_ERR,
													   "missing method name");
			}
			if (typeof(methodName) != "string"){
				throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "methodname should be string");
			}
			if (errCbk){
				if (typeof(errCbk) != "function"){
					throw new nokia.device.DeviceException(locException.INVALID_ARG_ERR,
												       "error callback should be  function");
				}
			}
			var transId  = asyncReqObj.add(callback,errCbk,null);
			//alert("added transid="+transId);
			//connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__CJSE_CALLBACK);
			//alert("callback added with cid="+connectId);
			//alert("calling ps method");
			var returnValue = qtGeolocationIf.getLocationUsingMethodName(methodName,transId);
			//alert("error from ul="+returnValue.errorCode);
			if (returnValue.errorCode){
				var errObj = convertToCjseError(returnValue.errorCode);
				throw new nokia.device.DeviceException(errObj.code,errObj.message);
			}
		},
	    getCurrentPosition: function( __succes_cb, __fail_cb,__pos_opt){ 
	    	////alert("calling getcurrentposition");
			var connectId;
			if((__succes_cb == undefined) || (__succes_cb == null) || (typeof(__succes_cb) != "function"))
			{
				__sp_location_handle_error(__fail_cb,-1);
				//alert("succes_cb fail");
				
			}
			if ((__fail_cb != undefined)) {
				if ((__fail_cb != null)
				    &&(__fail_cb != "")
					&& (typeof(__fail_cb) != "function")) {
						//alert("fail_cb fail");
					var errorObject = new PositionError();
					errorObject.code = -1;
					throw errorObject;	
				}
			}
			////alert("pos object:TO="+__pos_opt);
			/**
			 * following code handles situation where timeout = 0 and maximumAge is 
			 * either not supplied or supplied as 0.
			 */
			if ((__pos_opt != undefined) 
			    && (__pos_opt != null)
				&& (__pos_opt != "")
				&& (typeof(__pos_opt) == "object")
				&& (__pos_opt.timeout != undefined)) {
				if ((__pos_opt.timeout == 0) && (typeof(__pos_opt.timeout) == "number")) {
					if ((__pos_opt.maximumAge == undefined)
					|| (__pos_opt.maximumAge == 0)) {
						//alert("time out error");
					    var errorObject = new PositionError();
						errorObject.code = 3;
						errorObject.message = "time out error";
						if ((__fail_cb != undefined) && (typeof(__fail_cb) == "function")) {
							__fail_cb(errorObject);
							return;
						}else {
							throw errorObject;	
						}
						
					}
				}
				
			}
			////alert("typeoffunction="+typeof(__succes_cb));
			var serviceObject = qtGeolocationIf;
			function __location_cb(id1,id2,id3)
			{
				//this.locationservice.removeEventListener(connectId);
				if(id1 != 0) //handle error
				{
					//alert("Pf error");
					serviceObject.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,id1);
				}
				else
				{
					var _pos_coord = new Coordinates();
					_pos_coord.longitude = (id3.longitude == undefined)?null:id3.longitude;
					_pos_coord.latitude = (id3.latitude == undefined)?null:id3.latitude;
					_pos_coord.altitude = (id3.altitude == undefined)?null:id3.altitude;
					_pos_coord.accuracy = (id3.accuracy == undefined)?null:id3.accuracy;
					_pos_coord.altitudeAccuracy = (id3.altitudeAccuracy == undefined)?null:id3.altitudeAccuracy;
					_pos_coord.heading = (id3.heading == undefined)?null:id3.heading;
					_pos_coord.speed = (id3.speed == undefined)?null:id3.speed;
					
					//Position Object
					var _pos_data = new Position();
					_pos_data.coords = new Object();
					_pos_data.coords =_pos_coord;
					
					_pos_data.timestamp = id3.timestamp;
					serviceObject.removeEventListener(connectId);
					//Invoke consumer callback
					__succes_cb( _pos_data );
				}
			}
			////alert("inside actual function call");
			//add callback to the event listener
			connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__location_cb);
			////alert("conncetid="+connectId);
		    var returnValue;
			if((__pos_opt != undefined) && (__pos_opt != null) ) 
			{
				////alert("posoptdefined="+__pos_opt);
				//input validation
				////alert("result="+(__pos_opt.maximumAge == Infinity));
				if((__pos_opt.maximumAge == Infinity))
				{
					if((__pos_opt.enableHighAccuracy == undefined) || 
					   (typeof(__pos_opt.enableHighAccuracy) == "boolean"))
					{
						////alert("calling getlast1");
						var posOpts = new Object();
						var lastKnownLocation = new Boolean(true);
						returnValue = qtGeolocationIf.getCurrentPosition(posOpts,lastKnownLocation);
						if(returnValue.errorCode < 0)
						{
							//alert("return error");
							qtGeolocationIf.removeEventListener(connectId);
							////alert("errCode:lib="+returnValue.errorCode);
							__sp_location_handle_error(__fail_cb,returnValue.errorCode);
							return;
							
						}
						return;
						
					}
					else
					{
						qtGeolocationIf.removeEventListener(connectId);
						__sp_location_handle_error(__fail_cb,-1);
						return;
					    
						
					}
					
				}
				var isValid = isInputValid(__pos_opt);
				//alert("isValid="+isValid);
				if(isValid)
				{
					var getLast = new Boolean(false);
					//alert("calling PS API");
					returnValue = qtGeolocationIf.getCurrentPosition(__pos_opt,getLast);		
					
					
								
				}
				else //handle error
				{
					qtGeolocationIf.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,-1);
					return;
					
				}
				
			}
			else
			{
				////alert("posoptundef="+__pos_opt);
				var posOpts = new Object();
				var getLastlocation = new Boolean(false);
				returnValue = qtGeolocationIf.getCurrentPosition(posOpts,getLastlocation);
				////alert("retvalue="+returnValue);
			}
			 
			if(returnValue.errorCode < 0)
			{
				//alert("PF retvalue error");
				__sp_location_handle_error(__fail_cb,returnValue.errorCode);
				qtGeolocationIf.removeEventListener(connectId);
				return;
			}
	    
	    	
	    
	    
	    },
		/**
	     * Notify about updates of the hosting device position.
	     * Invokes __succes_cb whenever device positon changes.
	     * This is an asynchronous API.
	     * <br><br>
	     * @param {function} callback A callback function with the signature
	     *                     <i>function({@link Position} )</i>
	     *                     Position contains location coordinate in WGS-84 representation
	     *                     as well as time stamp when this coordinate was obtained.
	     * @param {function} [errorCallback] This callback function is optional and when supplied gets invoked with
	     * {@link PositionError} object when error occurs in processing the  request.
	     * @param {object} [__pos_opt] optional position option see {@link PositionOptions} for details
	     * @return an integer value that uniquely identifies the watch process. When the clearWatch() method is called 
	     * 	with this identifier, the watch process must stop acquiring any new position fixes and must cease invoking any callbacks.
	     * @exception  					Code 0 (UNKNOWN_ERROR): Parametrs supplied are invalid and error callback is not supplied 
	     *                              or is invalid.
	     *                              <br>
	     *                              
	     */
	    watchPosition: function( __succes_cb, __fail_cb,__pos_opt){ 
	   
	    	var connectId;
			////alert("TO="+__pos_opt.timeout);
			////alert("maxage="+__pos_opt.maximumAge);
			if((__succes_cb == undefined) || (__succes_cb == null) || (typeof(__succes_cb) != "function"))
			{
				__sp_location_handle_error(__fail_cb,-1);
				
			}
			if ((__fail_cb != undefined)) {
				if ((__fail_cb != null)
				    &&(__fail_cb != "")
					&& (typeof(__fail_cb) != "function")) {
					var errorObject = new PositionError();
					errorObject.code = -1;
					throw errorObject;	
				}
			}
			if ((__pos_opt != undefined) 
			    && (__pos_opt != null)
				&& (__pos_opt != "")
				&& (typeof(__pos_opt) == "object")
				&& (__pos_opt.timeout != undefined)) {
				if ((__pos_opt.timeout == 0) && (typeof(__pos_opt.timeout) == "number")) {
					if ((__pos_opt.maximumAge == undefined)
					|| (__pos_opt.maximumAge == 0)) {
						//alert("imeout 0 case");
					    var errorObject = new PositionError();
						errorObject.code = 3;
						errorObject.message = "time out error";
						if ((__fail_cb != undefined) && (typeof(__fail_cb) == "function")) {
							__fail_cb(errorObject);
							return;
						}else {
							throw errorObject;	
						}
						
					}
				}
				
				if ((__pos_opt.timeout >= 86400000) && (typeof(__pos_opt.timeout) == "number")) {
					//alert(" My condition"+__pos_opt.timeout);
					__pos_opt.timeout = 86400000;
				}
			}
			if ((__pos_opt != undefined)) {
				if ((__pos_opt != null)
				    &&(__pos_opt != "")
					&& (typeof(__pos_opt) == "object")) {
					if ((__pos_opt.maximumAge != undefined)) {
						if ((__pos_opt.maximumAge == Infinity)) {
							//alert("maxinfinity case");
							var newPosObject = new PositionOptions();
							if ((__pos_opt.timeout !== undefined) && (__pos_opt.timeout !== 0)) 
								newPosObject.timeout = 	__pos_opt.timeout;
							if ((__pos_opt.enableHighAccuracy != undefined))
								newPosObject.enableHighAccuracy = __pos_opt.enableHighAccuracy;
							__pos_opt = newPosObject;
						}
					}	
				}
			}
			
			function __location_watch_cb(id1,id2,id3)
			{
				
				if(id1 != 0) //handle error
				{
					__sp_location_handle_error(__fail_cb,id1);
				}
				else
				{
					var _pos_coord = new Coordinates();
					_pos_coord.longitude = (id3.longitude == undefined)?null:id3.longitude;
					_pos_coord.latitude = (id3.latitude == undefined)?null:id3.latitude;
					_pos_coord.altitude = (id3.altitude == undefined)?null:id3.altitude;
					_pos_coord.accuracy = (id3.accuracy == undefined)?null:id3.accuracy;
					_pos_coord.altitudeAccuracy = (id3.altitudeAccuracy == undefined)?null:id3.altitudeAccuracy;
					_pos_coord.heading = (id3.heading == undefined)?null:id3.heading;
					_pos_coord.speed = (id3.speed == undefined)?null:id3.speed;
					
					//Position Object
					var _pos_data = new Position();
					_pos_data.coords = new Object();
					_pos_data.coords =_pos_coord;
					
					_pos_data.timestamp = id3.timestamp;
					
					
					//Invoke consumer callback
					__succes_cb( _pos_data );
				}
			}
			////alert("inside actual trace function call");
			//add callback to the event listener
			connectId = qtGeolocationIf.addEventListener("AsyncCallback(int,int,const QMap<QString,QVariant>&)",__location_watch_cb);
			////alert("watchid="+connectId);
		    var returnValue;
			if((__pos_opt != undefined) && (__pos_opt != null) ) 
			{
				var isValid = isInputValid(__pos_opt);
				//alert("isvalid="+isValid);
				if(isValid)
				{
					returnValue = qtGeolocationIf.watchPosition(__pos_opt);
				}
				else
				{
					qtGeolocationIf.removeEventListener(connectId);
					__sp_location_handle_error(__fail_cb,-1);
					return;
				}
				
				
			}
			else
			{
				var posOpts = new Object();
				returnValue = qtGeolocationIf.watchPosition(posOpts);
			}
			 
			if(returnValue.errorCode < 0)
			{
				qtGeolocationIf.removeEventListener(connectId);
				__sp_location_handle_error(__fail_cb,returnValue.errorCode);
				
				return;
			}
			else
			{
				var callbackinfo = new watchIndex();
				callbackinfo.connectId = connectId;
				callbackinfo.watchId = returnValue.transactionId;
				watchArray.push(callbackinfo);
				return returnValue.transactionId;	
			}
			    
			    
			    
		},
		/**
		 * Clears previously invoked watchPosiion request
		 * @param {integer}  Uniqely  Identifies previously invoked watchPosition Request.
		 * @return none
		 * @exception when supplied with an invalid type of id or not supplied with anything at all.
		 */
		clearWatch: function(watchId) {
			//////alert("inside clearwatch");
			if((isNaN(watchId)) || watchId == undefined || watchId == null)
			throw "invalid or Missing watchId";
			else
				{
					for (var d in watchArray)
					{
						if(watchArray[d].watchId == watchId)
							{
							//////alert("cancel.connectId="+watchArray[d].connectId);
							qtGeolocationIf.removeEventListener(watchArray[d].connectId);
							qtGeolocationIf.clearWatch(watchArray[d].watchId );
							//remove the entry from watch table
							watchArray.splice(d,1);
							}
					}
				
				
				}
			
		}
   		 
    };
}
/**
 * @author lgaur
 */
/**
 * @class
 */

nokia.device.Media = function PSMediaInterface(){
    
	var DeviceException = nokia.device.DeviceException;

    var error = new DeviceException(0,'dummy');
	
	/*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	iterator is the eventItem Iterator
     */
    function getList_cb(trans,error,iter){        
        var obj = asyncCallbackMap.get(trans);
        asyncCallbackMap.remove(trans);        
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (error) {
                if (errorCallback) {
                    errorCallback(new DeviceException(error, "Media : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback(iter);
            }
        }		
	
		
		
    }
	
	function getThumbnail_cb(arg1, arg2, arg3){
		
		var obj = asyncCallbackMap.get(arg1);		 
		 asyncCallbackMap.remove(arg1);
		 if (obj) {
		 	var __succes_cb = obj.success_cb;
			var __fail_cb = obj.error_cb;
		 	if (arg2 == 0 || arg2 == error.URI_ALREADY_EXISTS_ERR) {
		 	
		 		if (arg3) {
		 		
		 			__succes_cb(arg3);
		 		}
		 		else {
		 		
		 		
		 		
		 			if ((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function")) {
		 				__fail_cb(new DeviceException(arg2, "Media:getThumbnail:thumbnail uri is not present"));
		 			}
		 		}
		 		
		 		
		 	}
		 	else {
		 	
		 		if ((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function")) {
		 		
		 			__fail_cb(new DeviceException(arg2, "Media:getThumbnail:Operation Failed"));
		 		}
		 	}
		 }
		 
	}
	
	
	function addMusic_cb(trans,error)	{
					
					
		var obj = asyncCallbackMap.get(trans);
        asyncCallbackMap.remove(trans);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (error) {
                if (errorCallback) {
                    errorCallback(new DeviceException(error, "Media : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback();
            }
        }		
	
	
				}
	
    /*
    * Internal
    * qt media interface object.
    */
    var qtMediaIf = nokia._services.load("nokia.device.media", "com.nokia.IMedia", "1.0"); 		
		qtMediaIf.addEventListener("getListCallback(int , int , QObject* )", getList_cb);		
		qtMediaIf.addEventListener("getThumbnailCallback(int,int,QString)", getThumbnail_cb);
		qtMediaIf.addEventListener("addMusicToCollectionCallback(int,int)", addMusic_cb);
    
    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "media",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['media'],
        /**
         * Gets list of media files/ instances matching the supplied pattern.
         * This is an asynchronous API.
         *
         * Returns unique transaction id.
         * @param {Function}
         *         callback - The supplied function will be called asynchronously with an
         *         iterator of objects matching the Media file data schema.
         *         Media urls should refer to locations that are accessible to the
         *         browser or runtime engine invoking this operation.
         *         Function signature:
         *         callback({@link Iterator} of {@link MediaFileData}</i>).
         * @param {MediaFileMatchingPattern}
         *         [match] Specifies a matching filter for the media files to return. The supplied argument may be one of:
         *         <ul>
         *         <li> null or unspecified then all media files will be returned</li>
         *         <li> {@link MediaFileMatchingPattern}. can be used to specify required matching pattern.</li>
         *         </ul>
         * @param {SortOrder}
         *         [order] Sorting order. The value must be one of
         *            <a href=#ASCENDING>ASCENDING</a> or <a href=#DESCENDING>DESCENDING</a>.
         *            ASCENDING is the default.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * SERVICE_BUSY_ERR: Unable to take request now, try again later.
         * </li>
         * <li>
         * </ul>
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>mediaFileMatchingPattern  does not conform to {@link MediaFileMatchingPattern}</li>
         *                              <li>sortingOrder is not one of <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a></li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
    getList: function(__succes_cb, __match, __sort_order, __fail_cb){ 

            var connectId=-1;
            var gcret=0;
        
			if(__succes_cb == undefined || __succes_cb == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param successCallback is missing');
				}

			
        	if((typeof __succes_cb) != "function" )
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid Callback");

        	if(__fail_cb && ((typeof __fail_cb) != "function" ))
        	{
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid error Callback");
        	}

        	if((__match == undefined) || (__match == null))	
        		__match = {type:"all"};
        		
        	if((typeof __match) != "object"){
        		        	throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" + __match);	}
        	else
        		{
		
       		if( ( __match.type == undefined || __match.type == null) )
        		   throw new DeviceException(error.MISSING_ARG_ERR, "Missing Argument: type " + __match.type);
				   					
        		if( ('field' in __match) && ( __match.field == undefined || __match.field == null) )
        		   throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: field " + __match.field);
						
        		if( ('dateRange' in __match) && ( __match.dateRange == undefined || __match.dateRange == null) ){
        		 throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: date range " + __match.dateRange);}
			
			if(('dateRange' in __match) &&( __match.dateRange.start == undefined || __match.dateRange.start == null))
				throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: start in date Range " + __match.dateRange.start);

			if(('dateRange' in __match) && ( __match.dateRange.end == undefined || __match.dateRange.end == null))
				throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: start in date Range " + __match.dateRange.end);
			        		 

            if( ('sortBy' in __match) && ( __match.sortBy == undefined || __match.sortBy == null) ){

        		 throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: sortby" + __match.sortBy);}
        			        			
        		}
			        	
        	
        	if((__sort_order == undefined) || (__sort_order == null))
        		__sort_order = 0;
        	
		
        
    		if((typeof  __sort_order) != "number")
				{
				throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" +  __sort_order) ;
				
			}else if(__sort_order < 0 || __sort_order > 1 )
				{
			
				throw  new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument:" +  __sort_order) ;
				}
	    	
			 
	
        	/*function __mediagetlist_cb(trans,error,iter)
        	{	
        		
        		if(trans==connectId)
        		{
        			try{
        				qtMediaIf.removeEventListener(trans);
        				
        				//Invoke consumer callback
        				if(error != 0)
        				{
        				    __fail_cb(new DeviceException(error, "getList::operation failed"));
        				}
        			    else
        			        __succes_cb(iter);
        			        
        			   }
        		    catch(er){
					
        		    }			
        		}
        	}*/
        	var tid = -1;
            try{
            	tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
				//alert(" after asyncCallbackMap"+tid);
        		//connectId = qtMediaIf.addEventListener("getListCallback(int , int , QObject* )",__mediagetlist_cb);				
        		
        		
        		//if(connectId<0)
        			//throw  new DeviceException(error.INVALID_ARG_ERR, "Connect Failed:"+connectId);
            	
				
            	gcret=qtMediaIf.getList( tid, __match,__sort_order );            	 
				if(gcret["errorCode"] != 0)
            	{			
					 
            	    throw new DeviceException(gcret["errorCode"], gcret["errorMessage"]);
            	}
        	}
        	catch(er){
        	    asyncCallbackMap.remove(tid);
        		throw new DeviceException(er.code, er.message);
        	}
        		
        	//return connectId;
			return tid;
    },

        /**
         * This method is used to get a thumbnail of the image or video.
         * This is an Asynchronous method.
         *
         * Returns unique transaction id.
         * @param {Function} callback
         *       a user-supplied callback function with the signature
         *       callback(String <i>data</i>).
         *       data is uri for the thumbnail image,
         *       The supplied function will be called asynchronously.
         * @param {ThumbnailInfo} thumbnailinfo
         *        Specifies the thumbnailInfo object which contains the uri of image or video file and size of thumbnail
         *        tobe generated.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - could be:
         * <ul><li>URI_NOT_FOUND_ERR: image or video file provided doesn't exist.</li>
         * <li>INVALID_URI_ERR: Specified uri is invalid. i.e doesn't conform to uri schema</li>
         * </ul>
         *
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined.</li><li>thumbnailInfo is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>thumbnailInfo  does not conform to {@link ThumbnailInfo} data scheme</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
    */
    getThumbnail : function(__succes_cb,thumbnailInfo, __fail_cb) {
    	
			
        	var connectId=-1;
          var gcret=0;
        	
        		if( (__succes_cb == undefined ) || (__succes_cb == null ) )
          		{
					
          			throw  new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:Callback is missing");	
        				
          		
          		}
          	else if(typeof __succes_cb != "function")	//here we check if the type of callback is function. This case is useful when arbitrary values are passed to callback
          		{
				
        			throw  new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:Callback is invalid");	
          		}
        	
			
			if((__fail_cb != undefined) &&__fail_cb && ((typeof __fail_cb) != "function" ))
        	{
			
        		throw  new DeviceException(error.INVALID_ARG_ERR, "InValid error Callback");
        	}
			
			
        /*	var invoker = function(arg1, arg2, arg3) {
			
					var thumbUrl= null;
        	qtMediaIf.removeEventListener(connectId);
          if(arg2 == 0 || arg2 == error.URI_ALREADY_EXISTS_ERR )
          {
            
          if(arg3){
 
              __succes_cb(arg3); 
            }
          else
          	{
				
	         	 
	
        	if((__fail_cb != undefined) && (__fail_cb != null) && (typeof(__fail_cb) == "function"))
			 	   {
           		__fail_cb(new DeviceException(arg2,"Media:getThumbnail:thumbnail uri is not present")); 
           	   }
        	}
          	
         
         }
          else
        	{
        			
        	if((__fail_cb != undefined)&&(__fail_cb != null) &&(typeof(__fail_cb) == "function"))
        	   {
			   	
           		__fail_cb(new DeviceException(arg2,"Media:getThumbnail:Operation Failed")); 
           	   }
        		}
     }*/
          
        
        	
        	
        // Input validation
        	
        		var inputParam = new Object();
        	if (thumbnailInfo) {
		
				if (typeof thumbnailInfo != "object") {
					throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo is of invalid type object");
				}
				
				
				if (thumbnailInfo.uri) {
				
					if (typeof thumbnailInfo.uri != "string") {
				
						throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:uri is not of type string");
					}
					inputParam.uri = thumbnailInfo.uri;
					
				}
				else {
					// Throw error
					throw new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:uri is missing");
					
				}
				
				if (('size' in thumbnailInfo) && (thumbnailInfo.size == undefined || thumbnailInfo.size == null)) {
				
					
					throw new DeviceException(error.INVALID_ARG_ERR, "Invalid Argument: size " + thumbnailInfo.size);
				}
			
				
				
				
				if(('size' in thumbnailInfo) && (typeof thumbnailInfo.size != "object")){
				
					throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:size is not of type Object");
				}
				
				if ( thumbnailInfo.size ) {
										
					
					if ((typeof thumbnailInfo.size.width == "undefined") && (typeof thumbnailInfo.size.height == "undefined")) {
					
						throw new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:thumbnailInfo should have atleast width or height");
					}
					else {
						
						
						if( ('width' in thumbnailInfo.size) && (typeof thumbnailInfo.size.width != "number")){
					
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:width is of not number type");
						}
						//alert("Whether height is there: " + ('height' in thumbnailInfo.size) );
						if( ('height' in thumbnailInfo.size) && (typeof thumbnailInfo.size.height != "number")){
//							//alert("prob in height");
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:height is of not number type");
						}
					
						var thumbnailsize = new Object();
						//alert("width : "+ thumbnailInfo.size.width );

						if (('width' in thumbnailInfo.size) && (typeof thumbnailInfo.size.width == "number") ) // Need to put check on this
						{
							//alert("Width is:"+ thumbnailInfo.size.width );
							if ((thumbnailInfo.size.width > 0)) {
								thumbnailsize.width = thumbnailInfo.size.width;
							}else
							{
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:width is invalid value");	
							}
						}
					//	alert("Height : "+ thumbnailInfo.size.height );
					//	alert("Check : " + (thumbnailInfo.size.height >0));
						if (('height' in thumbnailInfo.size) && (typeof thumbnailInfo.size.height == "number") ){
							
							if(thumbnailInfo.size.height >0){
								thumbnailsize.height = thumbnailInfo.size.height;
							}else
							{
							//	alert("Exception for height");
							throw new DeviceException(error.INVALID_ARG_ERR, "Media:getThumbnail:thumbnailInfo:size:height is invalid value");	
							}
							
						}
				
						inputParam.size = thumbnailsize;
						///alert("InputParam:  "+inputParam);
					}
					
				}
	
			
			}
        	else{
        		throw  new DeviceException(error.MISSING_ARG_ERR, "Media:getThumbnail:thumbnailInfo is missing");	
        		}	
				//alert(typeof thumbnailInfo.size);
        	//for thumbanilsize
        
        // adding to listener
		//alert("addEventListener calling : " +qtMediaIf);
        	
        	//alert("addEventListener Called");
			//alert("Connect Id " + connectId);
			
			//connectId = qtMediaIf.addEventListener("getThumbnailCallback(int,int,QString)",invoker);
        /*	if(connectId<0)
        	{
        		alert("connect id faield");
        		throw  new DeviceException(1, "Connect Failed:"+connectId);
        				
        	}*/
        	
        	// Input validation done
        	// 
			var tid = -1;
        	 try {    
            //__device_debug("Getting media list");
      //  alert("CAlling getThumbnail api from JS code");
	    
	 		  tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
			  //alert("after async call = "+tid);
              gcret = qtMediaIf.getThumbnail(tid ,inputParam);        	 
       
        	//alert("getthumbnail is called  " + gcret);
           	if(gcret["errorCode"] != 0)
            	{
            	    throw new DeviceException(gcret["errorCode"], gcret["errorMessage"]);
            	}
         
          }
          catch (er) {
		 
			   asyncCallbackMap.remove(tid);
          		throw new DeviceException(er.errorCode, er.errorMessage);
          }  		
		// alert("Returning user transId");
        //return connectId;
		return tid;

    },

    /**
     * This API is used to add a music file to the music collection database on the device.
		 * This is an Asynchronous API
     * Returns unique transaction id.
         * @param {Function} sCB
         *       a user-supplied callback function with the signature
         *       callback().
         *       The supplied function will be called asynchronously.
         * @param {String} uri
         *        Specifies path to the musis file.
         * @param {Function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - could be:
         * <ul><li>URI_NOT_FOUND_ERR: image or video file provided doesn't exist.</li>
         * <li>INVALID_URI_ERR: Specified uri is invalid. i.e doesn't conform to uri schema</li>
         * </ul>
         *
         * @return {Number} TransactionId which uniquely identifies asynchronous request.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined.</li><li>thumbnailInfo is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
     */
    addMusicToCollection : function(sCB, uri, eCB){
	            var connectid;
				//input validations..
				if(sCB == undefined || sCB == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param successCallback is missing');
				}
				else if((typeof sCB) != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR,'successCallback is not a function');
				}
					
				if((typeof uri) == "undefined" || uri == null){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter uri is missing');
				}	
				else if((typeof uri) != "string"){
					throw new DeviceException(error.INVALID_ARG_ERR,'uri param must be a string');
				}
					
				if((typeof eCB) == "undefined" || eCB == null){
					eCB = null;
				}	
				else if( eCB&& (typeof eCB) != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR,'errorCallback is not a function');
				}

				/*
				 * intermediate callback function 
				 * @param	error 	is DeviceException errror code.
				 * @param	trans	is the trasactionId
				 */
				/*function addMusic_cb(trans,error)	{	
					if( trans == connectid )
					{
						//////alert("in cb");
						qtMediaIf.removeEventListener(connectid);	
						if(error){
							if( eCB ){
							eCB(new DeviceException(error,'error occured.'));		
							}
						}
						else
						{
						sCB();	
						}
					}
				}*/
				
           try{
		   		//alert("Interface : " + qtMediaIf);
        		//connectid = qtMediaIf.addEventListener("addMusicToCollectionCallback(int,int)",addMusic_cb);
        		
        
        		//if(connectid<0)
        			//throw  new DeviceException(error.INVALID_ARG_ERR, "Connect Failed:"+connectId);
            	//alert("Calling api");
				var tid = -1;
			    tid = asyncCallbackMap.add(sCB,eCB);
            	ret = qtMediaIf.addMusicToCollection(tid,uri);				
            	//alert("Called gettList api");
				if(ret["errorCode"]!=0){		    	    
		    	    throw new DeviceException(ret.errorCode,ret.errorMessage);
		    	}
        	}
        	catch(er){
				//alert("Exception: " +er.code );
        	    //qtMediaIf.removeEventListener(connectid);
				 asyncCallbackMap.remove(tid);
        		throw new DeviceException(er.code, er.message);
        	}	
			//return transactionId.
			//return connectid;
			return tid;    	
    },
    
        /**
         * This method helps user to add streaming uri to media gallery.
         * Streaming uri is link to the server from where streaming
         * is done. This is synchronous method.
         * @param {String} uri
         *            Streaming Uri link.
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): uri is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid (only Streaming protocol is supported).
         */
        addStreamUri: function(uri){
            throw  new DeviceException(error.NOT_SUPPORTED_ERR, "addStreamUri Not Supported");
              },

        /**
         * This method helps user to delete a streaming uri from gallery.
         * This is a synchronous method. Stream uri is link to the server
         * from where streaming is done.
         * @alias MediaService.deleteStreamUri
         * @param {String} uri
         *            Streaming Uri link.
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): uri is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid (only Streaming protocol is supported).<br>
         *                              Code 101 (DATA_NOT_FOUND_ERR): uri does not exist in the gallery.
				*/
        deleteStreamUri : function(uri)
        {
            throw  new DeviceException(error.NOT_SUPPORTED_ERR, "deleteStreamUri Not Supported");
        },
        /**
         * This method is used to get a temporary resized image of the original image
         * This is a synchronous method.
         * @param {String} uri
         *       The URI of the image file to be resized.
         * @param {Object} resizeOptions
         *        width: Specifies the width of the resized image in pixels.
         *        height: Specifies the height of the resized image in pixels.
         *        [aspectRatioOption]: Specifies if aspect ratio should be maintained. 
         *        If 0, the image is scaled freely, the aspect ratio is not preserved. 
         *        If 1, the image is scaled to a rectangle as large as possible inside the size 
         *        as given, preserving the aspect ratio.
         *        If 2, the image is scaled to a rectangle as small as possible outside the size 
         *        as given, preserving the aspect ratio.
         *        The default value is 0.
         * @param {String} [destUri]
         *       The URI of the resized image provided by user. If not provided, the resized image is stored in temporary directory.
         *
         * @return {String} The URI of the resized image.
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>uri is undefined.</li><li>resizeOptions is undefined</li></ul><br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>uri is not a string</li>
         *                              <li>resizeOptions is not a object</li>
         *                              <li>resizeOptions.width is not a number</li>
         *                              <li>resizeOptions.height is not a number</li>
         *                              <li>resizeOptions.aspectRatioOption is outside the defined values</li>
         *                              <li>destUri is not a string</li>
         *                              </ul>
         *                              Code 3 (URI_NOT_FOUND_ERR): <ul><li>The specified uri was not found</li></ul><br>
         *                              Code 4 (NOT_SUPPORTED_ERR): <ul><li>The specified file format is not supported</li></ul><br>
         *                              Code 5 (INVALID_URI_ERR): <ul><li>URI is improper</li></ul><br>
         *                              Code 6 (NOT_ALLOWED_ERR): <ul><li>Permission not granted</li></ul><br>
         *                              Code 6 (GENERAL_ERR): <ul><li>Any other processing error</li></ul><br>
		 */        
        
        resizeImage : function(uri,resizeOptions,destUri){
		//input validations.
				if(!uri){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter uri is missing');
				}	
				else if((typeof uri) != "string"){
					throw new DeviceException(error.INVALID_ARG_ERR,'uri param must be a string');
				}
				if(!resizeOptions){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter resizeOptions is missing');
				}	
				else if((typeof resizeOptions) != "object"){
					throw new DeviceException(error.INVALID_ARG_ERR,'resizeOptions param must be a object');
				}
				if(!resizeOptions.width){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter width is missing');
				}	
				else if((typeof resizeOptions.width) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'width param must be a number');
				}
				if(!resizeOptions.height){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory parameter height is missing');
				}	
				else if((typeof resizeOptions.height) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'height param must be a number');
				}
				if(resizeOptions.aspectRatioOption && (typeof resizeOptions.aspectRatioOption) != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'aspectRatioOption param must be a number');
				}
				if(resizeOptions.aspectRatioOption && resizeOptions.aspectRatioOption != 0 && resizeOptions.aspectRatioOption != 1 && resizeOptions.aspectRatioOption != 2){
					throw new DeviceException(error.INVALID_ARG_ERR,'aspectRatioOption param must be within defined values');
				}
				if (destUri && (typeof uri) != "string") {
					throw new DeviceException(error.INVALID_ARG_ERR, 'destUri param must be a string');
				}
				if(!destUri){
					destUri = "";
				}
		    ret = qtMediaIf.resizeImage(uri,resizeOptions,destUri);
			
			if(ret["errorCode"] == -1){
            	throw new DeviceException(error.URI_NOT_FOUND_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -5){
				throw new DeviceException(error.NOT_SUPPORTED_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -6){
				throw new DeviceException(error.INVALID_URI_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -46){
				throw new DeviceException(error.NOT_ALLOWED_ERR, ret["errorMessage"]);
			}
			if(ret["errorCode"] == -2){
				throw new DeviceException(error.GENERAL_ERR, ret["errorMessage"]);
			}
			return ret["returnValue"];				
		},       
        /**
         * This method helps user to refresh/sync media database.
         * This is a synchronous method.
         * @param {String}
         *            [uri] Uri for file protocol.
         * @return {void}
         * @exception {DeviceException} Code 2 (INVALID_ARG_ERR): uri error if URI schema is invalid ((Only file protocol is supported).<br>
         *                              Code 101 (DATA_NOT_FOUND_ERR): uri does not exist in the gallery.
				*/        
        refreshMediaDb : function(uri)
        {
          //  throw  new DeviceException(error.NOT_SUPPORTED_ERR, "refreshMediaDb Not Supported");
       },

    
    /**
     * Cancels an asynchronous request identified by transactionId.
     * This is synchronous API.
     *
     * @param {number} transactionId
     *           Identifier of the ongoing asynchronous request to be canceled.
     * @return {void}
     * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
     *                           Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request corresponds to the specified trasactionid.
     */
    cancel: function(transactionId){
    	
				if(transactionId == undefined || transactionId == null || (typeof transactionId !== "number")){
					throw new DeviceException(error.MISSING_ARG_ERR,'mandatory param transactionId is missing');
				}

				if(typeof transactionId != "number"){
					throw new DeviceException(error.INVALID_ARG_ERR,'mandatory param transactionId is missing');
				}
				else{
				
						return qtMediaIf.cancel(transactionId);
				
				}

	}
 
    };
}
/**
* @class
*/
nokia.device.Messaging = function PSMessagingInterface(){         
        var notifyTid = null;
        var TIME_OUT = 100;
        var integerLimit = 2147483648;
        
        var DeviceException = nokia.device.DeviceException;
        var error = new DeviceException(0,'dummy');
    
        function filterUndefined( obj ){
            if(typeof obj === "object"){
                for(var key in obj) {
                    if(typeof obj[key] === "undefined"){
                        delete obj[key];
                    } 
                    if(typeof obj[key] === "object"){
                        filterUndefined(obj[key]);
                    }
                } 
            }
            return obj;
        }
        
        function removeDuplicateEntry(arr){ 
            if (arr) {
                for (index = 0; index < arr.length; index++) {
                    var element = arr[index];
                    for (dupIndex = index + 1; dupIndex < arr.length; dupIndex++) {
                        if (arr[dupIndex] == element || element == "") {
                            arr.splice(dupIndex, 1);
                        }
                    }
                }
            } 
            return arr;
        }
        
        function asyncErrorFound(op,errorCbk){
            var errMsg;
            if (op.ErrorMessage) {
                errMsg = op.ErrorMessage;
            }
            else {
                errMsg = "Messaging:Operation Failed";
            }
            switch (op.ErrorCode) {
                case error.MISSING_ARG_ERR:
                case error.INVALID_ARG_ERR:
                case error.NOT_SUPPORTED_ERR:
                    throw new DeviceException(op.ErrorCode, errMsg);
                    break;
                default:
                    setTimeout(function(){
                        errorCbk(new DeviceException(op.ErrorCode, errMsg));
                    }, TIME_OUT);
                    break;
            }
        }    
    
        /*
        * Internal
        * qt messaging interface object.
        */

        var qtMessagingIf = nokia._services.load("nokia.device.messaging", "com.nokia.IMessaging", "1.0");          
        
        //getlist eventListener            
        qtMessagingIf.addEventListener("asyncCallback(int,int,QObject*)", getListMessaging_cb);
        
        //send eventListener            
        qtMessagingIf.addEventListener("asyncCallback(int,int,QString)", send_cb);
        
        //notification eventListener
        qtMessagingIf.addEventListener("asyncCallback(int,int,int)", setNotifier_cb);

        /*
         * Messaging getList callback handler
         */
        function getListMessaging_cb(error, transId, iterator){
            var retObj = asyncCallbackMap.get(transId);
            asyncCallbackMap.remove(transId);
            
            if (!retObj) {
                return;
            }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
            
            if (error == 0) {
                var localIter = new tempIterator(iterator);
                function tempIterator(tIter){
                    this.iter = tIter;
                    this.next = function(){
                        var item = this.iter.next();
                        if (item) 
                            return item;
                        else 
                            return null;
                    };//next
                    this.hasNext = function(){
                        return this.iter.hasNext();
                    };//hasNext
                    this.reset = function(){
                        return this.iter.reset();
                    };//reset
                    this.close = function(){
                        return this.iter.close();
                    }; //close         
                }//tempIterator
                sCB(localIter);
            }
            else {
                if (eCB) {
                    eCB(new DeviceException(error, "Messaging:getList:Operation Failed"));
                }
            }
        }
    
        /*
         * Messaging send callback handler
         */  
        function send_cb(error, transId, recipient){ 
            var retObj = asyncCallbackMap.get(transId);
            
            if (!retObj) {
                return;
            }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
            var data = retObj.options;
            
            if (data.type == "SMS") {
                data.currentCount++;            
                if(data.currentCount == data.actualCount) {
                   asyncCallbackMap.remove(transId);
                } 
            } 
            else {
                if (data.type == "MMS") {
                    asyncCallbackMap.remove(transId);
                }
            }
            if (error) {
                eCB(new DeviceException(error, "Messaging:send:Operation Failed"), recipient);
                return;
            }
            sCB(recipient);
        }   
        
        /*
         * New Message Notification callback
         */ 
         function setNotifier_cb(error, transId, id){
             var retObj = asyncCallbackMap.get(notifyTid);
             
             if (!retObj) {
                 return;
             }
            var sCB = retObj.success_cb;
            var eCB = retObj.error_cb;
                     
             if (transId == 0) {//this will be always 0 for notification cbk
                 if (error) {
                     eCB(new DeviceException(error, 'Messaging:setNotifier:Operation Failed'));
                     return;
                 }
                 sCB(id);
             }
         }
    
        return {
            /**
            * @constant {String} 
            * interfaceName.
            */      
            interfaceName: "messaging",
            /**
            * @constant {Number} 
            * version.
            */      
            version: nokia.device._interfaces['messaging'],     
            
          /**
          * @constant {Number} sorts by date
          */
          SORT_BY_DATE  : 0,
            
          /**
          * @constant {Number} sorts by sender
          */
          SORT_BY_SENDER  : 1,
    
          /**
          * @constant {Number} to get read messages
          */
          STATUS_READ : 0,
            
          /**
          * @constant {Number} to get unread messages
          */
          STATUS_UNREAD : 1,
      
          /**
          * @constant {Number} to indicate sort in ascending order
          */
          SORT_ASCENDING  : 0,
      
          /**
          * @constant {Number} to indicate sort in descending order
          */
            SORT_DESCENDING  : 1,
          
            /**
             * @constant {String} to indicate the folder type inbox
             */
            INBOX_FOLDER : "INBOX",
            
            /**
             * @constant {String} to indicate the folder type drafts
             */
            DRAFTS_FOLDER : "DRAFTS",
          
            /**
             * @constant {String} to indicate the folder type sentitems
             */
            SENT_FOLDER : "SENTBOX",
          
            /**
             * @constant {String} to indicate the folder type outbox
             */
            OUTBOX_FOLDER : "OUTBOX",
            
            /**
             * @constant {Number} to indicate the message priority high
             */
            PRIORITY_HIGH : 0,
            
            /**
             * @constant {Number} to indicate the message priority medium 
             */
            PRIORITY_NORMAL : 1,
            
            /**
             * @constant {Number} to indicate the message priority low 
             */
            PRIORITY_LOW : 2,
      
            /**
            * Start the device native message editor with pre-populated message data.
            * This is a synchronous method. This method just launches the editor and
            * returns. Its upto the user to operate on the editor.
            * @param {MessageData}
            *            messagedata that conforms to the specified message data schema ({@link MessageData}).
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): messageData undefined.<br>
            *                Code 2 (INVALID_ARG_ERR): messageData - does not conform to the specified message data schema {@link MessageData}.<br>
            *                Code 101 (DATA_NOT_FOUND_ERR): Attachment file not present in specified path for MMS message.<br>
            *                Code 103 (SERVICE_BUSY_ERR): Message storage unavailable/busy.<br>
            *                Code 109 (URI_NOT_FOUND_ERR): File path specified does not exist.<br>
            *                Code 105 (DATA_OUT_OF_RANGE_ERR):  If any of the input parameter values are out of range.<br>
            */
            startEditor : function(messageData){
                if (!messageData) {
                    //Dummy messageData parameter created
                    var messageData = {
                        type : "SMS"
                    };
                }
                else {
                    if ((typeof messageData) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'messageData should be an object');
                    }
                }
     
                var messageDataRight = filterUndefined(messageData);
                var returnValue = qtMessagingIf.startEditor(messageDataRight);
                if(returnValue.ErrorCode != 0){
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancel:Operation Failed";
                    }
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
                return 0;
            },
    
            /**
            * Get an iterator to a list of messages matching the supplied pattern.
            * Returns a transaction id, which is passed as an argument to the callback function.
            * It's an asynchoronous method.
            * @param {Function} callback
            *            A user-supplied callback function with the signature
            *            function({@link Iterator} of {@link MessageInfo}). The supplied function
            *            will be called asynchronously.
            * @param {MessageMatchingPattern} [matchPattern]
            *            Message matching pattern.
            * @param {SORT_BY} [sortKey]
            *            Sort key property. The value must be one of the defined sort key properties for the
            *            messaging service object
            *            (<a href=#SORT_BY_DATE>SORT_BY_DATE</a> or <a href=#SORT_BY_SENDER>SORT_BY_SENDER</a>)<br>
            *            Default is SORT_BY_DATE.
            * @param {SORT_ORDER} [sortOrder]
            *            Sorting order. The value must be one of
            *            <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a>.
            *            SORT_ASCENDING is the default.
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - could be:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.<br>
            * DATA_OUT_OF_RANGE_ERR:  If any of the input parameter values are out of range.<br>
            * </li>
            * </ul>
            * @return {Number}
            *            transactionId - Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
            *                              <li>messageMatchingPattern  does not conform to {@link MessageMatchingPattern}</li>
            *                              <li>sortBy is not one of <a href=#SORT_BY_DATE>SORT_BY_DATE</a> or <a href=#SORT_BY_SENDER>SORT_BY_SENDER</a></li>
            *                              <li>sortOrder is not one of <a href=#SORT_ASCENDING>SORT_ASCENDING</a> or <a href=#SORT_DESCENDING>SORT_DESCENDING</a></li>
            *                              <li>errorCallback is not a function</li>
            *                              </ul>
            */
            getList: function(sCB, match, sortKey, sortOrder, eCB){
                var dummyId = 1;
                var isSync = false;
                var matchcrit = match;
    
                //new singnature is getList(match,sCB,eCB) where sCB and eCB are optional
                if(typeof sCB == 'object'){               
                  matchcrit = sCB;
                  sortKey = matchcrit.sortkey;
                  sortOrder = matchcrit.sortorder;
                  if (match != null) {
                    if(typeof match == 'function'){
                        sCB = match;
                    }else{
                       throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:successCallback is not a function'); 
                    } 
                  }
                  else{
                    isSync = true;
                  } 
                  
                  if (sortKey != null) {
                    if(typeof sortKey == 'function'){
                        eCB = sortKey;
                    }else{
                       throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:errorCallback is not a function');
                    } 
                  }
                }                        
                if (!isSync && (typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:successCallback is not a function');
                }
                if (!matchcrit) {
                    matchcrit = {};
                }
                else {
                    if ((typeof matchcrit) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:match is not an object');
                    }
                    if (matchcrit.type != null) {
                        if (typeof matchcrit.type != "object") {
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:invalid data type');
                        }
                    }           
                    if (matchcrit.senders != null) {
                        if (typeof matchcrit.senders != "object") {
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:invalid data type');
                        }               
                    }
                    if (matchcrit.subject != null) {
                        if (matchcrit.subject.length > 255) {
                            setTimeout(function(){
                                eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:subject parameter is out of range"));
                            }, TIME_OUT);
                            return dummyId;
                        }
                    }
                }     
                
                if (matchcrit.priority !== null) {
                    if ((typeof matchcrit.priority) == "number" && ( matchcrit.priority < 0 || ( (matchcrit.priority % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:priority parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;                    
                    }
                }
                
                if (matchcrit.validity !== null) {
                    if ((typeof matchcrit.validity) == "number" && ( matchcrit.validity < 0 || ( (matchcrit.validity % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:getList:validity parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;   
                    }
                }
    
                if (sortKey == null) 
                    sortKey = this.SORT_BY_DATE;
                else {
                    if ((typeof sortKey) != "number") {
              throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:sortKey should be a number');
                    }
                    if ((typeof sortKey) == "number" && ( sortKey < 0 || sortKey > integerLimit || ( (sortKey % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'Messaging:getList:sortKey invalid'));
                        }, TIME_OUT); 
                        return dummyId;                   
                    }
                }
    
                if (sortOrder == null) 
                    sortOrder = this.SORT_ASCENDING;
                else {
                    if ((typeof sortOrder) != "number") {
              throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:sortOrder should be a number');
                    }
                    if ((typeof sortOrder) == "number" && ( sortOrder < 0 || sortOrder > integerLimit || ( (sortOrder % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'Messaging:getList:sortOrder invalid'));
                        }, TIME_OUT); 
                        return dummyId;                     
                    }
                }
    
                if (eCB) {
                    if (isSync) {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:synchronous call');
                    }
                    else {
                        if ((typeof eCB) != "function") 
                            throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getList:errorCallback is not a function');
                    }
                }
    
               var matchRight = filterUndefined(matchcrit);
    
                if (!isSync) {
                  var transId  = asyncCallbackMap.add(sCB,eCB,null);
                    var returnValue = qtMessagingIf.getList(matchRight, sortKey, sortOrder, transId);
                    if (returnValue.ErrorCode != 0) {
                        asyncCallbackMap.remove(transId);
                        asyncErrorFound(returnValue, eCB);
                        return transId;
                    }
                    return transId;
                }
                else {
                    var msgIter = qtMessagingIf.getListSync(matchRight, sortKey, sortOrder);    
                    var localIter = null;
                    if (msgIter) {
                       localIter = new tempIterator(msgIter);
                        function tempIterator(tIter){
                            this.iter = tIter;
                            this.next = function(){
                                var item = this.iter.next();
                                if (item) 
                                    return item;
                                else 
                                    return null;
                            };//next
                            this.hasNext = function(){
                                return this.iter.hasNext();
                            };//hasNext
                            this.reset = function(){
                                return this.iter.reset();
                            };//reset
                            this.close = function(){
                                return this.iter.close();
                            };//close         
                        }//tempIterator   
                    }
                    return localIter;  
                }
            },
            /**
            * Get the list of configured mail accounts on the device.
            * Returns List of Account objects containing the accountId and accountName.
            * It's an synchoronous method.                   
            * @return {List}
                       List of Account objects containing the accountId and accountName.       
            */
            getEmailAccounts: function(){           
                var result = qtMessagingIf.getEmailAccounts();
                var err = result.ErrorMap;
                if(err.ErrorCode == 0){
                  var accList = result.ReturnValue;             
                  return accList;
                }else{              
                  throw new DeviceException(result.ErrorCode, result.ErrorMessage); 
                }         
            },
            
            /**
            * Get the Account object which is set as current account to do other email operations.
            * Returns Account object containing the accountId and accountName.
            * It's an synchoronous method.                
            * @return {Account}
                       Account object containing the accountId and accountName.       
            */
            getCurrentEmailAccount: function(){            
                var result = qtMessagingIf.getCurrentEmailAccount();
                var err = result.ErrorMap;
                if(err.ErrorCode == 0){
                  var acc = result.ReturnValue;             
                  return acc;
                }else{              
                  throw new DeviceException(result.ErrorCode, result.ErrorMessage); 
                }   
            },
            
            /**
            * Set the email account as the current account to do other email operations.
            * Returns void
            * It's an synchoronous method.                
            * @return 
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): accountId is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): <ul><li>accountId is invalid</li>          
            */
            setCurrentEmailAccount: function(accountId){
                if (!accountId) {                
                    throw new DeviceException(error.INVALID_ARG_ERR, "accountId is missing");
                }
                
                if (typeof accountId != 'string') {                
                    throw new DeviceException(error.INVALID_ARG_ERR, "accountId is not a string");
                }
                            
                var err = qtMessagingIf.setCurrentEmailAccount(accountId);            
                if(err.ErrorCode != 0){
                  throw new DeviceException(err.ErrorCode, err.ErrorMessage);
                }
            },
            
           /**  
            * Sends a message. This is an asynchronous method.
            * The message is sent to outbox.
            * @param {Function} callback
            * A user-supplied callback function. The supplied function will be called asynchronously on success.
            * A callback function with the signature
            * <i>function()</i>.
            * @param {MessageData} messageData
            *           messageData - a message that conforms to the specified message data schema.
            * @param {String} [id]
            *          Message id of another message for populating the data.
            *          Usefull in "Forward" operation.
            *          <ul>
            *          <li>
            *          Invalid to pass a MMS message id to an SMS message.
            *          </li>
            *          <li>
            *          If the SMS message id is passed to an SMS/MMS message, the message body of SMS message will be appended to the MMS message.
            *          </li>
            *          <li>
            *          If the MMS message id is passed to a MMS message, the attachments if any will be added the new MMS message. The body of the passed message will be added as an attachment.
            *          </li>
            *          </ul>
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - one of the errors:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.
            * </li>
            * <li>
            * DATA_NOT_FOUND_ERR: Recoverable exception: Sending an attachment file which is not present in the specified path.
            * </li>
            * <li>
            * URI_NOT_FOUND_ERR: Recoverable exception: If the path specified for attchment does not exist on the device.
            * </li>
            * </ul>
            *
            * @return {Number}
            *            transactionId - Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): messagedata or
            *                callback is undefined.<br>
            *                Code 2 (INVALID_ARG_ERR):
            *                                 <ul>
            *                              <li>messageData - does not conform to the specified message data schema {@link MessageData}</li>
            *                              <li>callback is not a function</li>
            *                              <li>Message id is not a <i>String</i></li>
            *                                 <li>errorCallback is not a function</li>
            *                              </ul>
            *                Code 3 (NOT_SUPPORTED_ERR):  If MMS message id is passed to SMS message            
            */
            send : function(sCB, messageData, id, eCB){
                var dummyId = 1;
                if (!sCB) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:send:mandatory param successCallback is missing');
                }
                else if ((typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:successCallback is not a function');
                }
                if (!messageData) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:send:mandatory param messageData is missing');
                }
                else if ((typeof messageData) != "object") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:messageData is not an object');
                }
                if (!id) {
                    id = "";
                }        
                if (((typeof id) != "function") && ((typeof id) != "string")) {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:id is not a string');
                }
                if ((typeof id) == "function") {
                    var errorCbk = id;
                    id = "";
                    eCB = errorCbk;
                }
                if ((typeof eCB) == "undefined" || eCB == null) {
                    eCB = null;
                }
                else if ((typeof eCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:send:errorCallback is not a function');
                }
    
                if (messageData.priority !== null) {
                    if ((typeof messageData.priority) == "number" && ( messageData.priority < 0 || ( (messageData.priority % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:send:priority parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;   
                    }
                }
                
                if (messageData.validity !== null) {
                    if ((typeof messageData.validity) == "number" && ( messageData.validity < 0 || ( (messageData.validity % 1) != 0 ) ) ) {
                        setTimeout(function(){
                            eCB(new DeviceException(error.DATA_OUT_OF_RANGE_ERR, "Messaging:send:validity parameter is out of range"));
                        }, TIME_OUT);
                        return dummyId;  
                    }
                }
                
                var messageDataRight = filterUndefined(messageData);
                
                var toCount = 0;
                var ccCount = 0;
                
                if (messageDataRight.to && typeof messageDataRight.to == 'object') {
                    var toArray = messageDataRight.to;
                    messageDataRight.to = removeDuplicateEntry(toArray);
                    toCount = messageDataRight.to.length;
                }
                if (messageDataRight.cc && typeof messageDataRight.cc == 'object') {
                    var ccArray = messageDataRight.cc;
                    messageDataRight.cc = removeDuplicateEntry(ccArray);
                    ccCount = messageDataRight.cc.length;
                }
                
                var count = toCount+ccCount;
                var transId;
                            
                if (messageDataRight.type != "EMAIL") {
                    var dataObj = {
                        type : messageDataRight.type,
                        actualCount : count,
                        currentCount : 0
                    };
                    transId  = asyncCallbackMap.add(sCB,eCB,dataObj);
                }  
                        
                var returnValue = qtMessagingIf.send(messageDataRight, id, transId);
                if (returnValue.ErrorCode != 0) { 
                    asyncCallbackMap.remove(transId);
                    asyncErrorFound(returnValue, eCB);
                    return transId;
                }
                return returnValue.TransactionId;
            },
    
            /**
            * Registers a notifier for received messages.
            * This is asynchronous method.
            * @param {Function} callback
            *            A user-supplied callback function with signature:
            *            callback(string <i>id</i>).
            *            id is message ID to be used with, for example, getMessage(),
            *            If a notifier has already been registered, the new handler will replace it.
            *            The supplied function will be called asynchronously.
            * @param {Function} [errorCallback] This callback function gets invoked with
            * {@link DeviceError} object when error occurs in processing the async request.
            * <i>function(DeviceError)</i>
            * <i>{@link DeviceError}</i> - could be:
            * <ul>
            * <li>
            * SERVICE_BUSY_ERR: Recoverable exception when message storage unavailable/busy.
            * </li>
            * </ul>
            * @return {Number} transactionId
            *            Unique transactionId for the request will be returned.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
            *                                 Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li><li>errorCallback is not a function</li></ul>
            */
            setNotifier : function(sCB, eCB){
                if (!sCB) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:setNotifier:mandatory param successCallback is missing');
                }
                else if ((typeof sCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:setNotifier:successCallback is not a function');
                }
                if ((typeof eCB) == "undefined" || eCB == null) {
                    eCB = null;
                }
                else if ((typeof eCB) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:setNotifier:errorCallback is not a function');
                }
    
    
                if (notifyTid) {
                    asyncCallbackMap.remove(notifyTid);
                    qtMessagingIf.cancelNotifier();
                }
                notifyTid = asyncCallbackMap.add(sCB, eCB);
                var returnValue = qtMessagingIf.setNotifier(notifyTid);
                if (returnValue.ErrorCode != 0) {
            asyncCallbackMap.remove(notifyTid);
            notifyTid = null;                
                    asyncErrorFound(returnValue, eCB);
                    return;
                }
            },
    
            /**
            * Unregisters the currently set message notifier,
            * ending message notifications. This is synchronous method
            * @return {void}
            */
            cancelNotifier : function(){
                if (notifyTid) {
                    asyncCallbackMap.remove(notifyTid);
                    notifyTid = null;
                }
                var returnValue = qtMessagingIf.cancelNotifier();
                if (returnValue.ErrorCode != 0) {
                    var errMsg;
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancelNotifier:Operation Failed";
                    }
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
            },
    
            /**
            * Gets a message by id from the message store.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @return {MessageInfo}
            *            message object that conforms to the specified message info schema {@link MessageInfo}.
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): Id is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): Id is not a String type.<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): Message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            getMessage : function(messageId,folderName){
                if (!messageId) 
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:getMessage:mandatory param messageId is missing');
                else if ((typeof messageId) != "string") 
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getMessage:MessageId should be a string');
                if (folderName) {
                    if(typeof folderName != "string") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:getMessage:folderName should be a string');
                    }
                }
                else {
                    folderName = null;
                }
    
                var ret = qtMessagingIf.getMessage(messageId, folderName);
                if (ret.ErrorCode == 0) 
                    return ret.ReturnValue;
                else {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                    else 
                        errMsg = "Messaging : getMessage :Operation Failed";
                    throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
                }
            },
    
            /**
            * Deletes a message from the message store. It's a synchoronous method.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined<br>
            *                              Code 2 (INVALID_ARG_ERR): id is not a string<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            deleteMessage : function(messageId){                      
                var msgDataFilter = {};
                if (!messageId){ 
                    throw new DeviceException(error.MISSING_ARG_ERR, "Missing MessageId");
                }
                if(typeof messageId == 'string'){
                    msgDataFilter.id  = messageId;
                }
                else if(typeof messageId == 'object'){
                    msgDataFilter = messageId;            
                }else{
                    throw new DeviceException(error.INVALID_ARG_ERR, "Invalid MessageId"); 
                } 
                                         
                var ret = qtMessagingIf.deleteMessage(msgDataFilter);
                if (ret.ErrorCode != 0) {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                    else 
                        errMsg = "Messaging : deleteMessage :Operation Failed";
                    throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
                }             
            },
    
            /**
            * Sets the read/unread status of a message in the message store.
            * It's a synchoronous method.
            * @param {String} id
            *            of an existing message.
            *            ids can be retrieved from the notifier
            *            callback function or from messageinfo
            *            retrieved by getList()
            * @param {MESSAGE_STATUS} status
            *            MESSAGE_STATUS constants (<a href=#STATUS_UNREAD>STATUS_UNREAD</a>, <a href=#STATUS_READ>STATUS_READ</a>).
            * @return {void}
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>id is undefined</li><li>status is undefined</li></ul>
            *                                  Code 2 (INVALID_ARG_ERR): <ul><li>id is not a string</li>status is not one of <a href=#STATUS_UNREAD>STATUS_UNREAD</a> or <a href=#STATUS_READ>STATUS_READ</a><li</li></ul>
            *                              Code 101 (DATA_NOT_FOUND_ERR): message with given id does not exist.<br>
            *                              Code 103 (SERVICE_BUSY_ERR): message storage unavailable/busy.
            *                              Code 105 (DATA_OUT_OF_RANGE_ERR): If any of the input parameter values are out of range. 
            */
            setStatus : function(messageId, status){
                if (!messageId) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Mandatory parameter messageId missing');
                }
                else if ((typeof messageId) != "string") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'messageId should be a string');
                }
                if (status == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Mandatory parameter status missing');
                }
                else {
                    if ((typeof status) != "number") {
                        throw new DeviceException(error.INVALID_ARG_ERR, 'status should be a number');
                    }
                    if ((typeof status == "number") && ( status < 0 || status > integerLimit || ( (status % 1) != 0 ) ) ) 
                        throw new DeviceException(error.DATA_OUT_OF_RANGE_ERR, 'invalid value for status');
                }
                var ret = qtMessagingIf.setStatus(messageId, status);
                if (ret.ErrorCode != 0) {
                    var errMsg;
                    if (ret.ErrorMessage) 
                        errMsg = ret.ErrorMessage;
                     else 
                        errMsg = "Messaging : setStatus :Operation Failed";
                     throw new DeviceException(ret.ErrorCode, errMsg);              
                 }          
            },
    
            /**
            * Cancels any asynchronous request identified uniquely by trasactionId.
            * It's a synchoronous method.
            * @param {Number} transactionId
            * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
            *                              Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
            *                              Code 101 (DATA_NOT_FOUND_ERR): transactionId does not match with a asynchronous request.
            * @return {void}
            */
            cancel : function(transactionId){
                if (transactionId == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, 'Messaging:cancel:mandatory param transactionId is missing');
                }
                else if ((typeof transactionId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'Messaging:cancel:transactionId is not a number');
                }
    
                var errMsg;
                asyncCallbackMap.remove(transactionId);
                var returnValue = qtMessagingIf.cancel(transactionId);
                if (returnValue.ErrorCode != 0) {
                    if (returnValue.ErrorMessage) {
                        errMsg = returnValue.ErrorMessage;
                    }
                    else {
                        errMsg = "Messaging:cancel:Operation Failed";
                    }             
                    throw new DeviceException(returnValue.ErrorCode, errMsg);
                }
        }  
    };
}




/**
 * @author
 */
/**
 * @class
 */
nokia.device.Sensors = function PSSensorsInterface(){

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    var error = new DeviceException(0, 'dummy');
    
    
    
    function __sensor_cb(trans, error, sensorData){
    
        var obj = asyncCallbackMap.get(trans);
        
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            try {
                //Invoke consumer callback with iterator.
                callback(sensorData);
            } 
            catch (e) {
                alert(e);
            }
            
        }
        
        
    }
    
    /*
     * Internal
     * qt sensor interface object.
     */

       var qtSensorsIf = nokia._services.load("nokia.device.sensors", "com.nokia.ISensor", "1.0");
        qtSensorsIf.addEventListener("asyncCallback(int,int,QVariant)", __sensor_cb);
    
    /*
     * Internal
     * Object to map connection id to transaction id for startChannel
     */
    Notification.prototype = new Object();
    Notification.prototype.constructor = Notification;
    
    /*
     * Internal
     * Constructor for Notification
     */
    function Notification(channel, connectionId){
        this.connectionId = connectionId;
        this.channel = channel;
    }
    
    /*
     * Internal
     * Array holding Connection objects for startChannel
     */
    var notifArr = new Array();
    
    /*
     * Internal
     * Counter to hold number of startChannel calls
     */
    var notifCount = 0;
    
    return {
        /**
         * @constant {String}
         * interfaceName.
         */
        interfaceName: "sensors",
        /**
         * @constant {Number}
         * version.
         */
        version: nokia.device._interfaces['sensors'],
        /**
         * Gets the list of system information channels supported on the device.
         * This is a synchronous function.
         * @return {array} list of available channels .
         */
        getChannels: function(){
            var ret = qtSensorsIf.getChannels();
            return ret;
        },
        
        /**
         * Registers for notifications from a particular channel.
         * This is an asynchronous method.
         * @param {function} __succes_cb - callback function called on successful async completion
         * @param {string} __channel - an string value
         * @param {function} __fail_cb - callback function called on un-successful async completion
         * @return connectionID
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i>
         * <ul>
         * <li>
         * SERVICE_IN_USE_ERR : This error occurs when user try to start a channel for notification more than once.
         * </li>
         * </ul>
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>callback is undefined</li>
         <li>channel is undefined</i></ul><br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>channel name is of wrong type </li></ul><br>
         *                           code 3 (NOT_SUPPORTED_ERR ): <li>when specified channel name is not supported </li>
         */
        startChannel: function(__succes_cb, __channel, __fail_cb){
        
        
            if (!__succes_cb) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Callback is missing");
            
            if ((typeof __succes_cb) != "function") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Callback is of invalid type");
            
            if (__fail_cb && ((typeof __fail_cb) != "function")) 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "InValid error Callback");
            
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            
            
            
            var tid = -1;
            try {
            
                tid = asyncCallbackMap.add(__succes_cb, __fail_cb);
                var ret = qtSensorsIf.startChannel(__channel, tid);
                if (ret["errorCode"] != 0) {
                    if (ret["errorCode"] == error.SERVICE_IN_USE_ERR) {
                        asyncCallbackMap.remove(tid);
                        setTimeout(function(){
                            __fail_cb(new DeviceAPIError(ret["errorCode"], ret["errorMessage"]));
                        }, 1000);
                        
                        return tid;
                    }
                    else {
                    
                        throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                    }
                }
                //Append notification info to array
                notifArr[notifCount++] = new Notification(__channel, tid);
                
            } 
            catch (er) {
                asyncCallbackMap.remove(tid);
                throw (er);
            }
            
            return tid;
        },
        
        /**
         * Stops the notifications (started by startChannel) for the channel specified.
         * This is a synchronous method.
         * @function {public var} stopChannel
         * @param {string} __channel - an string value
         * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.<br>
         *                           Code 4 (DATA_NOT_FOUND_ERR): This error occurs if the specified channel has already stopped giving notifications.
         */
        stopChannel: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.stopChannel(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
                //Get the connection id to be removed from list and remove it
                for (i in notifArr) {
                    if (__channel == notifArr[i].channel) {
                        var spliced = notifArr[i];
                        notifArr.splice(i, 1);
                        notifCount = notifArr.length;
                        break;
                    }
                }
                //Once done,remove the listener and invoke user callback
                
                asyncCallbackMap.remove(spliced.connectionId);
            } 
            
            catch (er) {
                throw (er);
            }
            
            return ret.errorCode;
        },
        
        /**
         * Gets the scalefactor value for the specified channel .
         * This is a synchronous method.
         * @function {public var} getScaleFactor
         * @param {string} __channel - an string value
         * @return {double}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.
         */
        getScaleFactor: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.getScaleFactor(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
            } 
            
            catch (er) {
                throw (er);
            }
            return ret.scaleFactor;
        },
        
        /**
         * Gets the channel value for the specified channel .
         * This is a synchronous method.
         * @function {public var} getChannelEvent
         * @param {string} __channel - an string value
         * @return {Object}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
         *                           Code 3 (NOT_SUPPORTED_ERR):specified channel name not supported.
         */
        getChannelEvent: function(__channel){
            if (!__channel) 
                throw new DeviceAPIError(error.MISSING_ARG_ERR, "Channel is missing");
            
            if ((typeof __channel) != "string") 
                throw new DeviceAPIError(error.INVALID_ARG_ERR, "Channel is of invalid type");
            
            try {
                var ret = qtSensorsIf.getChannelData(__channel);
                if (ret["errorCode"] != 0) {
                    throw new DeviceAPIError(ret["errorCode"], ret["errorMessage"]);
                }
            } 
            catch (er) {
                throw (er);
            }
            return ret.channelData;
        }
    }
    
};
/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
nokia.device.Sysinfo = function PSSysinfoInterface(){

    var DeviceException = nokia.device.DeviceException;
    var error = new DeviceException(0, 'dummy');
    /*
     * Internal
     * qt sysinfo interface object.
     */

    var qtSysInfoIf = nokia._services.load("nokia.device.sysinfo", "com.nokia.ISysInfo", "1.0");
    qtSysInfoIf.addEventListener("asyncCallback(int,int,const QMap<QString,QVariant>&)", sysInfo_getChannel_cb);
    qtSysInfoIf.addEventListener("asyncCallbackStChannel(int,int,const QMap<QString,QVariant>&)", sysInfo_startChannel_cb);

    /*
     * SysInfo getChannel callback handler
     */
    function sysInfo_getChannel_cb(errCode, transId, result){
        //alert('getlistcb'+transId);
        var retObj = asyncCallbackMap.get(transId);
        //alert('retObj '+retObj);
        asyncCallbackMap.remove(transId);

        if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
        var callback = retObj.success_cb;
        var errorCallback = retObj.error_cb;
        //alert('callback :error '+errCode+'scb : '+callback);
        //serviceObject.removeEventListener(transId);
        if (errCode != 0) {
            errorCallback(new DeviceException( errCode, "Error in async operation" ) );
            return;
        }
        //alert('calling users cb'+callback);
        callback(result);
    }

    /*
     * SysInfo startChannel callback handler
     */
    function sysInfo_startChannel_cb(errCode, transId, result){
        //alert('getlistcb'+transId);
        var retObj = asyncCallbackMap.get(transId);
        //alert('retObj '+retObj);

        if (!retObj) {
            //alert('asyncReqObj.get error');
            return;
        }
        var callback = retObj.success_cb;
        var errorCallback = retObj.error_cb;
        if (errCode != 0) {
            errorCallback( new DeviceException( errCode , "Error in async operation" ) );
            return;
        }
        //alert('calling users cb'+callback);
        callback(result);
    }

    /*
     * Internal
     * Counter to hold number of getChannel calls
     */
    var asyncCount = 0;

    /*
     * Internal
     * Object to map connection id to transaction id for getChannel
     */
    Connection.prototype = new Object();
    Connection.prototype.constructor = Connection;

    /*
     * Internal
     * Constructor for Connection
     */
    function Connection(connectionId, transId, callback){
        this.connectionId = connectionId;
        this.transId = transId;
        this.callback = callback;
    }

    /*
     * Internal
     * Array holding Connection objects for getChannel
     */
    var connArr = new Array();

    /*
     * Internal
     * Counter to hold number of startChannel calls
     */
    var notifCount = 0;

    /*
     * Internal
     * Object to map connection id to transaction id for startChannel
     */
    Notification.prototype = new Object(); //inheritance occurs here
    Notification.prototype.constructor = Notification;

    /*
     * Internal
     * Constructor for Notification
     */
    function Notification(connectionId, transId, callback, channel){
        this.connectionId = connectionId;
        this.transId = transId;
        this.callback = callback;
        this.channel = channel;
    }

    /*
     * Internal
     * Array holding Connection objects for startChannel
     */
    //var notifArr = new Array();

    /*
     * Internal
     * Object mapping country name to ISO-3166 standard
     */
     var countryArr = {
     "Afghanistan":"AF", "Algeria":"DZ", "Andorra":"AD", "Angola":"AO", "Anguilla":"AI",
     "Antigua & Barbuda":"AG", "Argentina":"AR", "Armenia":"AM", "Aruba":"AW", "Australia":"AU",
     "Austria":"AT", "Azerbaijan":"AZ", "Azores":"Azores", "Bahamas":"BS", "Bahrain":"BH",
     "Bangladesh":"BD", "Barbados":"BB", "Belarus":"BY", "Belgium":"BE", "Belize":"BZ",
     "Benin":"BJ", "Bermuda":"BM", "Bhutan":"BT", "Bolivia":"BO", "Bosnia and Herzegovina":"BA",
     "Botswana":"BW", "Brazil":"BR", "British Indian Ocean Territory":"IO",
     "British Virgin Islands":"VG", "Brunei":"BN", "Bulgaria":"BG", "Burkina Faso":"BF",
     "Burundi":"BI", "Cambodia":"KH", "Cameroon":"CM", "Canada":"CA",
     "Canary Islands":"Canary Islands", "Cape Verde":"CV", "Cayman Islands":"KY",
     "Central African Republic":"CF", "Chad":"TD", "Chile":"CL", "China":"CN",
     "Christmas Island":"CX", "Cocos (Keeling) Islands":"CC", "Colombia":"CO", "Comoros":"KM",
     "Cook Islands":"CK", "Costa Rica":"CR", "C�te d'Ivoire":"CI", "Croatia":"HR", "Cuba":"CU",
     "Curacao":"Curacao", "Cyprus":"CY", "Czech Republic":"CZ", "Democratic Republic of the Congo":"CD",
     "Denmark":"DK", "Djibouti":"DJ", "Dominica":"DM", "Dominican Republic":"DO",
     "Easter Island":"Easter Island", "Ecuador":"EC", "Egypt":"EG", "El Salvador":"SV",
     "Equatorial Guinea":"GQ", "Eritrea":"ER", "Estonia":"EE", "Ethiopia":"ET", "Falkland Islands":"FK",
     "Faroe Islands":"FO", "Fiji":"FJ", "Finland":"FI", "France":"FR", "French Guiana":"GF",
     "French Polynesia":"PF", "Gabon":"GA", "Galapagos Islands":"Galapagos Islands", "Gambia":"GM",
     "Georgia":"GE", "Germany":"DE", "Ghana":"GH", "Gibraltar":"GI", "Greece":"GR", "Greenland":"GL",
     "Grenada":"GD", "Guadeloupe":"GP", "Guam":"GU", "Guatemala":"GT", "Guinea":"GN",
     "Guinea-Bissau":"GW", "Guyana":"GY", "Haiti":"HT", "Honduras":"HN", "Hong Kong":"HK",
     "Hungary":"HU", "Iceland":"IS", "India":"IN", "Indonesia":"ID", "Iran":"IR", "Iraq":"IQ",
     "Israel":"IL", "Italy":"IT", "Jamaica":"JM", "Japan":"JP", "Jerusalem":"Jerusalem",
     "Jordan":"JO", "Kazakhstan":"KZ", "Kenya":"KE", "Kerguelen":"Kerguelen", "Kiribati":"KI",
     "Kiritimati (Christmas Island)":"CX", "Kuwait":"KW", "Kyrgyzstan":"KG", "Laos":"LA",
     "Latvia":"LV", "Lebanon":"LB", "Lesotho":"LS", "Liberia":"LR", "Libya":"LY", "Liechtenstein":"LI",
     "Lithuania":"LT", "Luxembourg":"LU", "Macau":"MO", "Macedonia":"MK", "Madagascar":"MG",
     "Madeira":"Madeira", "Malawi":"MW", "Malaysia":"MY", "Maldives":"MV", "Mali":"ML",
     "Malta":"MT", "Marquesas Islands":"Marquesas Islands", "Marshall Islands":"MH",
     "Martinique":"MQ", "Mauritania":"MR", "Mauritius":"MU", "Mayotte":"YT", "Mexico":"MX",
     "Micronesia":"FM", "Moldova":"MD", "Monaco":"MC", "Mongolia":"MN", "Montenegro":"ME",
     "Montserrat":"MS", "Morocco":"MA", "Mozambique":"MZ", "Myanmar":"MM", "Namibia":"NA",
     "Nauru":"NR", "Nepal":"NP", "Netherlands":"NL", "New Caledonia":"NC", "New Zealand":"NZ",
     "Nicaragua":"NI", "Niger":"NE", "Nigeria":"NG", "Niue":"NU", "Norfolk Island":"NF",
     "North Korea":"KP", "Northern Ireland":"IE", "Northern Mariana Islands":"MP", "Norway":"NO",
     "Oman":"OM", "Pakistan":"PK", "Palau":"PW", "Panama":"PA", "Papua New Guinea":"PG", "Paraguay":"PY",
     "Peru":"PE", "Philippines":"PH", "Phoenix Islands":"Phoenix Islands", "Pitcairn":"PN", "Poland":"PL",
     "Portugal":"PT", "Puerto Rico":"PR", "Qatar":"QA", "Republic of Ireland":"IE", "Republic of the Congo":"CG",
     "Reunion":"RE", "Romania":"RO", "Russia":"RU", "Rwanda":"RW", "Saint Helena":"SH",
     "Saint Kitts & Nevis":"KN", "Saint Lucia":"LC", "Saint Pierre and Miquelon":"PM",
     "Saint Vincent and Granadines":"VC", "Samoa":"WS", "San Marino":"SM", "Sao Tome & Principe":"ST",
     "Saudi Arabia":"SA", "Senegal":"SN", "Serbia":"RS", "Seychelles":"SC", "Sierra Leone":"SL",
     "Singapore":"SG", "Slovakia":"SK", "Slovenia":"SI", "Solomon Islands":"SB", "Somalia":"SO",
     "South Africa":"ZA", "South Georgia":"GS", "South Korea":"KR", "Spain":"ES", "Sri Lanka":"LK",
     "Sudan":"SD", "Suriname":"SR", "Swaziland":"SZ", "Sweden":"SE", "Switzerland":"CH", "Syria":"SY",
     "Tahiti":"Tahiti", "Taiwan":"TW", "Tajikistan":"TJ", "Tanzania":"TZ", "Thailand":"TH", "Timor-Leste":"TL",
     "Togo":"TG", "Tokelau Islands":"TK", "Tonga":"TO", "Trinidad and Tobago":"TT", "Tunisia":"TN",
     "Turkey":"TR", "Turkmenistan":"TM", "Turks and Caicos Islands":"TC", "Tuvalu":"TV",
     "Uganda":"UG", "Ukraine":"UA", "United Arab Emirates":"AE", "United Kingdom":"GB", "Uruguay":"UY",
     "USA":"US", "Uzbekistan":"UZ", "Vanuatu":"VU", "Vatican":"VA", "Venezuela":"VE", "Vietnam":"VN",
     "Wallis and Futuna Islands":"WF", "Western Sahara":"EH", "Yemen":"YE", "Zambia":"ZM", "Zimbabwe":"ZW"
     };

    /*
     * Internal
     * sysInfoObject object which implements ISysInfo interface of SysInfoService
     */
    function SysInfo(qtSysInfoIf){
        this._sysInfoObject = qtSysInfoIf;
    }

    /*
     * Internal
     * Temporary service object to be held for removing async signal from callback
     */
    var tempSysInfo;
    return {
        /**
        * @constant {String}
        * interfaceName.
        */
        interfaceName: "sysinfo",
        /**
        * @constant {Number}
        * version.
        */
        version: nokia.device._interfaces['sysinfo'],
        /**
        * Gets the list of system information channels supported on the device.
        * This is a synchronous function.
        * @return {array} Channel descriptors(as maps) for the available channels }
        */
        getChannelList : function(){
          var __sp_channel_descriptors = [{
            name: 'Charging',
            data: [{
              name: 'chargingStatus',
              range: 'true or false',
              description: 'Charging(true) ,Not charging(false)'
            }],
            style: ["Sync", "Oneshot", "Notification"]
          }, {
            name: 'BluetoothOn',
            data: [{
              name: 'btOn',
              range: 'true or false',
              description: 'BluetoothOn(true) ,BluetoothOff(false)'
            }],
            style: ["Sync", "Oneshot", "Notification"]
          }, {
            name: 'PhoneLanguage',
            data: [{
              name: 'phoneLanguage',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'ProductType',
            data: [{
              name: 'productType',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'FirmwareVersion',
            data: [{
              name: 'firmwareVersion',
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'BatteryLevel',
            data: [{
              name: "batteryLevel ",
              range: '0-100',
              description: 'Percent battery charge'
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'SignalStrength',
            data: [{
              name: "signalStrength",
              range: '0-100',
              description: 'Signal Strength in Percentage'
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'Network',
            data: [{
              name: "networkName ",
              description: "Network name"
            }, {
              name: "networkStatus",
              range: "Available,Current,Forbidden",
              description: ""
            }, {
              name: "networkMode",
              range: "ModeGsm,ModeCdma,ModeWcdma",
              description: ""
            }, {
              name: "mobileCountryCode",
              range: "",
              description: ""
            }, {
              name: "mobileNetworkCode",
              range: "",
              description: ""
            }, {
              name: "locationStatus",
              range: "True, False",
              description: ""
            }, {
              name: "areaCode",
              range: "",
              description: ""
            }, {
              name: "cellID",
              range: "",
              description: ""
            }],
            style: ["Async", "Oneshot", "Notification"]
          } , {
            name: 'IMEI',
            data: [{
              name: "imei",
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          } ,  {
            name: 'DisplayOrientation',
            data: [{
              name: "displayOrientation",
              range: "Landscape,Portrait",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'CellularNetworkStatus',
            data: [{
              name: "cellularNetworkStatus",
              range: "",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'DeviceInputMethod',
            data: [{
              name: "deviceInputMethod",
              range: "Touch,NonTouch,Hybrid",
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'HomeNetwork',
            data: [{
              name: "networkName ",
              description: "Network name"
            }, {
              name: "networkStatus",
              range: "Available,Current,Forbidden",
              description: ""
            }, {
              name: "networkMode",
              range: "ModeGsm,ModeCdma,ModeWcdma",
              description: ""
            }, {
              name: "mobileCountryCode",
              range: "",
              description: ""
            }, {
              name: "mobileNetworkCode",
              range: "",
              description: ""
            }, {
              name: "locationStatus",
              range: "True, False",
              description: ""
            }, {
              name: "areaCode",
              range: "",
              description: ""
            }, {
              name: "cellID",
              range: "",
              description: ""
            }],
            style: ["Async", "Oneshot", "Notification"]
          }, {
            name: 'DisplayResolution',
            data: [{
              name: "height",
              range: "",
              description: ""
            }, {
              name: "width",
              range: "",
              description: ""
            }],
            style: ["Sync", "Notification"]
          }, {
            name: 'PhoneManufacturer',
            data: [{
              name: "phoneManufacturer",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PhoneModel',
            data: [{
              name: "phoneModel",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PlatformName',
            data: [{
              name: "platformName",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'BacklightState',
            data: [{
              name: "backLightOn",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'KeypadLightState',
            data: [{
              name: "keypadLightOn",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'ActiveProfile',
            data: [{
              name: "msgRingtoneVolume",
              range: "1-10",
                  description: ""
            }, {
              name: "ringtoneVolume",
              range: "1-10",
              description: ""
            }, {
              name: "vibrationActive",
              range: "true, false",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'PhoneColorDepth',
            data: [{
              name: "phoneColorDepth",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'ClipBoard',
            data: [{
              name: "clipBoardData",
              range: "",
              description: ""
            }],
            style: ["Sync"]
          }, {
            name: 'WirelessConnSupport',
            data: [{
              name: "connTypes",
              range: "",
              description: "string list"
            }],
            style: ["Sync"]
          }, {
            name: 'SupportedVideoDecoders',
            data: [{
              name: "capability",
              data: [{
                name: "manufacturer",
                description: ""
              },{
                name: "identifier",
                description: ""
              },{
                name: "maxBitrate",
                description: ""
              },{
                name: "accelerated",
                description: ""
              },{
                name: "version",
                description: ""
              }],
              description: "string list"
            }],
            style: ["Sync"]
          }, {
            name: 'DataNetworkInfo',
            data: [{
              name: "connectionList",
              data: [{
                name: "connectionType",
                description: ""
              },{
                name: "connectionStatus",
                description: ""
              },{
                name: "connectionName",
                description: ""
              }],
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }, {
            name: 'WebRuntimeInfo',
            data: [{
              name: "WebRuntimeInfo",
              data: [{
                name: "name",
                description: ""
              },{
                name: "vendor",
                description: ""
              },{
                name: "version ",
                description: ""
              }],
              description: ""
            }],
            style: ["Sync", "Oneshot"]
          }];
          return __sp_channel_descriptors;
        },
     /**
     * Sets the properties of the specified channel.
     * This is a synchronous function.
     * @param {string} aChannel - Name of the channel as specified in the channel
     *                            descriptor.The channel is DisplayWallpaper
     * @param {list} inputData - input data list of the set.
     * @return {object} error object
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    setChannel : function(aChannel, inputData) {
        switch (aChannel) {
        case "DisplayWallpaper":{
            if ( inputData.wallpaperFileurl == null )
                throw new DeviceException(error.MISSING_ARG_ERR, "Wallpaper url is missing");
            if ( typeof inputData.wallpaperFileurl != 'string' )
                throw new DeviceException(error.INVALID_ARG_ERR, "Wallpaper url is not of string type");
            if (inputData.wallpaperFileurl.slice(0, 7) != "file://")
                throw new DeviceException(error.INVALID_ARG_ERR, "Wallpaper url does not conform with file schema");

            var srcFileName = inputData.wallpaperFileurl.slice(7).replace(/\057/g, "\\");
            var inputMap = {
                wallpaperFileurl:srcFileName
            };
            var retVal = qtSysInfoIf.setChannelSync(aChannel, inputMap);
            //If error,then throw error
            if ( retVal.errCode != 0 ){
               throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
            break;
        }
        case "Vibrate":{

          var vibraValues ={
            vibraDurationSecs : 0,
            Intensity: null
          };

          if ((inputData == null)  || (inputData == "string")) {
            throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "inputdata is invalid");
          }

          if (typeof(inputData) == "object") {
            if ((inputData.enable == undefined)||(inputData.enable == true)) {
              if (inputData.duration) {
                if (typeof(inputData.duration) != "number") {
                  throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "duration is not an integer");
                }
                vibraValues.vibraDurationSecs = inputData.duration;
                if (inputData.intensity) {
                  if (typeof(inputData.intensity) != "number") {
                    throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "intensity is not an integer");
                  }
                  vibraValues.Intensity = inputData.intensity;
                }
              }
            }
            else if (inputData.enable == false) {
              vibraValues.vibraDurationSecs = -1;
            }
            else {
              throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "enable is not an valid input");
            }

            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else if (!inputData){
            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else if (typeof(inputData) != "object"){
            if ((isNaN(inputData))){
              throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "inputData is not an valid input");
            }
            else {
              vibraValues.vibraDurationSecs = inputData;
            }
            var retVal = qtSysInfoIf.setChannelSync(aChannel,vibraValues);
            if ( retVal.errCode != 0 ){
              throw new DeviceException( retVal.errCode, retVal.errMessage );
            }
          }
          else {
            throw new nokia.device.DeviceException(error.INVALID_ARG_ERR, "invalid arg");
          }
          return retVal;
        }
        break;
        case "ClipBoard": {
                    if (inputData.clipBoardData == null)
                        throw new DeviceException(error.MISSING_ARG_ERR, "Clipboard data is missing");
                    if ( typeof inputData.clipBoardData != 'string' )
                        throw new DeviceException(error.INVALID_ARG_ERR, "Clipboard data is not a number");

                    var retVal = qtSysInfoIf.setChannelSync(aChannel, inputData);
                    //If error,then throw error
                    if ( retVal.errCode != 0 ){
                        throw new DeviceException( retVal.errCode, retVal.errMessage );
                    }
                }
          break;
        default:
          { //Error cases
            if (aChannel == null) {
              throw new DeviceException(error.MISSING_ARG_ERR, "Channel is missing");
            }
            else {
              if (typeof aChannel != "string") {
                throw new DeviceException(error.INVALID_ARG_ERR, "Channel is of invalid type");
              }
              else {
                throw new DeviceException(error.INVALID_ARG_ERR, "setChannel is not supported for this channel");
              }
            }
          }
      }
      //alert("at end retVal:"+retVal);
      return retVal;
    },
     /**
     * Gets the properties of the specified channel.
     * This method supports synchronous and asynchronous based on style information of <i>channel descriptor</i>.
     * This is a synchronous/asynchronous function.
     * @param {string} aChannel - Name of the channel as specified in the <i>channel
     *                        descriptor</i>.The synchronous channels are Charging,
     *                        PhoneLanguage,BluetoothOn,ProductType and FirmwareVersion.
     *                        The asynchronous channels are BatteryLevel,Network
     *                            and SignalStrength.
     * @param {function} [successCB] - callback function invoked if async call
     *                       is completed and successful.<br><ul>function signature <b>function (Sysinfo data)</b></ul>
     * @param {function} [errorCB(DeviceError)] - callback function invoked if async call is
     *                     completed and not successful.
     *
     * <br><br>
     * <b>Status Codes</b> are the codes returned in errorCallback functionErrorCallback for channels that support asynchronous behavior.<br>
     * <br>
     *                          Code 101 (DATA_NOT_FOUND_ERR): If there is no active asynchronous request corresponding to the specified transactionId.
     *                          <br>
     *
     * @return {Sysinfo Data/number} Properties of the channel(if synchronous)
     *               or transaction id(if asynchronous)
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     *                           Code 101 (DATA_NOT_FOUND_ERR): The specified channel is not available.
     */
    getChannel : function(aChannel, successCB, errorCB) {
      tempSysInfo = qtSysInfoIf;
      if (aChannel=="Network" || aChannel=="SignalStrength" ||  aChannel=="BatteryLevel")
      {
        if (successCB==null)
        {
          aChannel=aChannel+"Sync";
        }
      }
        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":
            case "Network":
            case "HomeNetwork": { //Async channels

                //If callback is null then throw exception
                if ( ( successCB == null ) ){
                    throw new DeviceException( error.MISSING_ARG_ERR, "Success callback parameter missing" );
                }

                //If callback is not a function then throw an exception
                if ( typeof successCB != "function" ){
                    throw new DeviceException( error.INVALID_ARG_ERR, "Success callback parameter is not a function" );
                }

          if ( errorCB && ( typeof errorCB != "function" ) ) {
            throw new DeviceException( error.INVALID_ARG_ERR, "Error callback parameter is not a function" );
          }

                //Call to provider
          var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.getChannelAsync(aChannel);

                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
              throw new DeviceException( retVal.errCode, retVal.errMessage );
                }
                return retVal;
            }
            break;
        case "Charging":
        case "PhoneLanguage":
        case "BluetoothOn":
        case "ProductType":
        case "FirmwareVersion":
        case "IMEI":
        case "IMSI":
        case "CellularNetworkStatus":
        case "DisplayOrientation":
        case "DeviceInputMethod":
        case "CountryName":
        case "AvailableMemory":
        case "TotalMemory" :
        case "DisplayResolution":
        case "PhoneManufacturer":
        case "PhoneModel":
        case "PlatformName":
        case "SignalStrengthSync":
        case "NetworkSync":
        case "BatteryLevelSync":
        case "BacklightState":
        case "KeypadLightState":
        case "ActiveProfile":
        case "PhoneColorDepth":
        case "ClipBoard":
        case "WirelessConnSupport":
        case "SupportedVideoDecoders":
        case "DataNetworkInfo":
        case "PublicId" :{ //Sync channels
          //Call provider

          if (aChannel=="SignalStrengthSync")
            aChannel="SignalStrength";
              if (aChannel=="NetworkSync")
            aChannel="Network";
          if (aChannel=="BatteryLevelSync")
            aChannel="BatteryLevel";

          var retVal = qtSysInfoIf.getChannelSync(aChannel);

          //If error,then throw error
          if ( retVal.errCode != undefined ){
            throw new DeviceException( retVal.errCode, retVal.errMessage );
          }

          if ( aChannel == "CountryName" ) {
            if ((navigator.platform == symbianPlatform) || (navigator.platform == s60Platform)) {
               retVal.countryName = countryArr[retVal.countryName];
             }

            }

                  if ( aChannel == "DisplayResolution" ) {
                     retVal.height = parseInt(retVal.height);
                     retVal.width = parseInt(retVal.width);
                }
          //If not error, then return system data
          return retVal;
        }
        break;
        case "ListDriveInfo":{//Sync channel , but output handled differently

          var listDrives = "ListDrives";

          var retVal = qtSysInfoIf.getChannelSync(listDrives);

          //alert('after QT call'+retVal);

          if ( retVal.errCode != undefined ){
            //handle error
            alert('error from QT list drives'+ retVal.errCode +'  '+ retVal.errMessage );
          }

          var retArr = new Array();
          var listOfDrives = retVal.listOfDrives;

          for (i = 0;i < 4 ; i++)
          {
            //alert('drive letter : ' +listOfDrives[i]);
            var inpMap = {
              DriveName : listOfDrives[i]
            }
            var retInfo = qtSysInfoIf.getChannelSync(aChannel,inpMap);
            //alert('After QT call ');
            retArr[i] = retInfo;

          }
          return retArr;

        }
        case "DataNetworkInfo":{
            return {name: "Qt WRT", vendor: "Nokia", version: nokia.device.version}
        }
        break;
            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing");
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type" );
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "getChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }
    },

     /**
     * Registers for notifications from a particular channel.
     * This is an asynchronous method. If the notification for a particular
     * channel has already been registered, and subsequently a call made again,
     * then the new handler will replace the older call(s).
     * @param {function} successCB - callback function called on successful async completion
     * @param {string} aChannel - an string value
     * @param {int/object} aTrigger(optional) - trigger param
     * @param {function} errorCB - callback function called on un-successful async completion
     * @return {void}
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    startChannel : function(successCB, aChannel, aTrigger, errorCB) {

        //If callback is null then throw exception
        if ( successCB == null ){
        throw new DeviceException( error.MISSING_ARG_ERR, "Success callback parameter missing" );
            }

      //If callback is not a function then throw an exception
      if ( typeof successCB != "function" ){
        throw new DeviceException( error.INVALID_ARG_ERR, "Success callback parameter is not a function" );
            }

      if ( errorCB && ( typeof errorCB != "function" ) ){
        throw new DeviceException( error.INVALID_ARG_ERR, "Error callback parameter is not a function" );
            }


        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":{
          if ( aTrigger != undefined ){
            //If trigger is not a number,throw exception
            if ( typeof aTrigger != "number" ){
              throw new DeviceException( error.INVALID_ARG_ERR, "Trigger is not a number");
            }
            if ( ( aTrigger != -1 ) && (( aTrigger < 0 )) || ( aTrigger >= 100 )){

            throw new DeviceException( error.DATA_OUT_OF_RANGE_ERR, "Trigger Value is out of Range");
            }

          }
          else {
            //Trigger not defined
            aTrigger = -1;
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,aTrigger);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }
                return 0;
        }
        break;
        case "BluetoothOn":
        case "Charging":
          case "Network":
        case "FlipStatus":
        case "DisplayResolution":
                case "DataNetworkInfo":
                case "CellularNetworkStatus": {
          //If trigger is undefined, then proceed with -1
          if ( ( aTrigger != undefined ) && ( typeof aTrigger == "number" ) ) {
            //If trigger is a number, then its not supported for these channels - throw exception
            throw new DeviceException( error.INVALID_ARG_ERR, "Trigger not supported for this channel");
          }
          else {
            aTrigger = 0;
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,aTrigger);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
            asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }
                return 0;
            }
            break;
            case "CriticalMemory":{
          var inputData=aTrigger;
          if ( inputData == undefined ){
              throw new DeviceException( error.INVALID_ARG_ERR, "Cant find input data");
          }

                //Call to provider
                var tid = asyncCallbackMap.add(successCB, errorCB);
                var retVal = qtSysInfoIf.startChannel(aChannel,inputData);
                transactionIdstChannel = tid;
                //If provider call fails, then throw error
                if ( typeof retVal != "number"){
                    asyncCallbackMap.remove(tid);
                    throw new DeviceException( retVal.errCode, retVal.errMessage);
                }

                return 0;
        }
        break;

            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing" );
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type" );
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "startChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }

    },

     /**
     * Stops the notifications (started by startChannel) for the channel specified.
     * This is a synchronous method.
     * @function {public var} stopChannel
     * @param {string} aChannel - an string value
     * @return {void}
     * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): channel is undefined.<br>
     *                           Code 2 (INVALID_ARG_ERR): channel is not a string.<br>
     */
    stopChannel : function(aChannel){
        switch ( aChannel ){
            case "BatteryLevel":
            case "SignalStrength":
        case "BluetoothOn":
        case "Charging":
            case "Network":
        case "CriticalMemory":
        case "FlipStatus":
        case "DisplayResolution":
        case "DataNetworkInfo": {
                var retVal = qtSysInfoIf.stopChannel(aChannel);
                    asyncCallbackMap.remove(transactionIdstChannel);
                //If provider call fails, then throw error
                if ( retVal.errCode != undefined ){
                    throw new DeviceException( retVal.errCode, retVal.errMessage );
                }

            return retVal;
            }
            break;
            default: { //Error cases
                if ( aChannel == null ) {
                    throw new DeviceException( error.MISSING_ARG_ERR, "Channel is missing");
                }
                else {
                    if ( typeof aChannel != "string" ) {
                        throw new DeviceException( error.INVALID_ARG_ERR, "Channel is of invalid type");
                    }
                    else {
                        throw new DeviceException( error.INVALID_ARG_ERR, "stopChannel is not supported for this channel" );
                    }
                }
            }
            break;
        }
    },

    /**
     * Cancels async requests made in getChannel
     * @param {int} aTransactionId - integer transaction id
       * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a number.<br>
     */
    cancel : function(aTransactionId){
      var found = true;
      if ( aTransactionId == null ) {
        throw new DeviceException( error.MISSING_ARG_ERR, "Transaction id param is missing");
            }
        else if ( typeof aTransactionId != "number" ) {
        throw new DeviceException( error.INVALID_ARG_ERR, "Transaction id is non a number");
        }
      else {
        var cancelObj = asyncCallbackMap.get(aTransactionId);
        if (!cancelObj){
          found = false;
        }
        if ( found ) {
            qtSysInfoIf.cancel(aTransactionId);
          asyncCallbackMap.remove(aTransactionId);
        }
        else {
          throw new DeviceException( error.INVALID_ARG_ERR, "Transaction id not found");
        }
      }

    }
        }; //End return
}
/**
 * @author ajana
 */
/**
 * @class
 */
nokia.device.Telephony = function PSTelephonyInterface(){

    var DeviceException = nokia.device.DeviceException;
    
    var error = new DeviceException(0, 'dummy');
    
    /*
     * Internal
     * qt telephony interface object.
     */
    var qtTelephonyIf = nokia._services.load("nokia.device.telephony", "com.nokia.ITelephony", "1.0");

    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "telephony",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['telephony'],

        /**
         * Makes a voice call the the given number
         * This is a synchronous API.
         *
         * @param {String}
         *          phoneNumber The phone number to which a voice call will be made.
         * @exception {DeviceException} Code 1 (INVALID_ARG_ERR): Invalid Phone number.
         * 								Code 2 (MISSING_ARG_ERR): If phoneNumber is missing.
         */
        initiateVoiceCall: function(phoneNumber){
        
            //input validations.
            if (!phoneNumber) {
                throw new DeviceException(error.MISSING_ARG_ERR, 'mandatory parameter phoneNumber is missing');
            }
            else 
                if ((typeof phoneNumber) != "string") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'phoneNumber param must be a string');
                }
            
            var ret = qtTelephonyIf.initiateVoiceCall(phoneNumber);
            if (ret["errorCode"] == -2 ||ret["errorCode"] == -6) {
                throw new DeviceException(error.INVALID_ARG_ERR, ret["errorMessage"]);
            }
        }
        
    }
    
};
