/**
 * @class
 */
nokia.device.CommLog = function PSCommLogInterface(){

    var DeviceException = nokia.device.DeviceException;
    var error = new DeviceException(0, 'dummy');
    
    var notifyTid = null;

    /*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	iterator is the eventItem Iterator
     */
    function getList_cb(errorCode, transId, iterator){
        var obj = asyncCallbackMap.get(transId);
        asyncCallbackMap.remove(transId);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (errorCode) {
                if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "CommLog : getList : error occured."));
                }
            }
            else {
                //Invoke consumer callback with iterator.
                callback(iterator);
            }
        }
    }
    /*
     * intermediate callback function to handle retrieved event items.
     * @param	errorCode 	is DeviceException errror code.
     * @param	transId	is the trasactionId
     * @param	result is the eventData
     */
    function setNotification_cb(errorCode, transId, result){
        var obj = asyncCallbackMap.get(transId);
        if (obj) {
            var callback = obj.success_cb;
            var errorCallback = obj.error_cb;
            if (errorCode) {
                if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "CommLog : setNotification : error occured"));
                }
            }
            else {
                //Invoke consumer callback with result.
                callback(result);
            }
        }
      
    }
    /*
     * Internal
     * qt CommLog interface object.
     */
        var qtCommlogIf = nokia._services.load("nokia.device.commlog", "com.nokia.ICommLog", "1.0");
        qtCommlogIf.addEventListener("asyncCallback(int,int,QObject*)", getList_cb);
        qtCommlogIf.addEventListener("notificationCallback(int,int,const QMap<QString,QVariant>&)", setNotification_cb);
    
    return {
     	    /**
     	    * @constant {String} 
     	    * interfaceName.
     	    */      
     	    interfaceName: "commlog",
     	    /**
     	    * @constant {Number} 
     	    * version.
     	    */      
     	    version: nokia.device._interfaces['commlog'],
  	     /*
				 * Read only property - supported sizes
				 */
        /**
         * Gets an iterator of event entires matching the supplied pattern
         * This is an asynchronous api
         * <br><br>
         * The output returned by this method depends on the filter criteria that can optionally
         * be passed with the <i>matchCriteria</i> parameter, which is an instance of the
         * data scheme {@link MatchCriteria}.
         * <br><br>
         * The contents of the {@link MatchCriteria} instance will guide <i>getList()</i> as follows:
         * <br><br>
         * The matchCriteria contains type, flag, recent and phone fields.
         * Type can be either SMS or Call. Flag can be incoming, outgoing, received or missed.
         * Recent is a boolean flag applicable for only calls. Phone specifies the phone number to be matched.
         * Recent field will be ignored if type is SMS
         * <br><br>
         * The <i>matchPattern</i> parameter is optional. If it is not present, then all instances are returned.
         * @param {function} successCallback A callback function with the signature
         *                     <i>function({@link Iterator} of {@link EventData})</i>
         *                     The iterator will iterate instances of {@link EventData}, which represent
         *                     event entries that match the matchCriteria.
         * @param {MatchCriteria} [matchCriteria] Specifies a matching filter for the entries to return.
         *                 May be <i>null</i> or <i>undefined</i> to match all
         *                 instances, or an {@link MatchCriteria} instance for getting a restricted set of
         *                 {@link EventData} instances.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * @return {number} Returns a transaction id
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR):
         *                              <ul>
         *                              <li>callback is not a function</li>
         *                              <li>matchCriteria - does not conform to the {@link MatchCriteria} data schema</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
        getList: function(successCallback, matchCriteria, errorCallback){
			
            //handle sync as well as async
            var isSync = false;
            if ((!successCallback && !matchCriteria && !errorCallback) || (typeof successCallback) == "object" && !matchCriteria && !errorCallback) {
                isSync = true;
            }
            
            if (isSync) {
                //input validations..
                var matchCriteria = successCallback;
                if (!matchCriteria) {
                    matchCriteria = {};
                }
                else 
                    if ((typeof matchCriteria) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid");
                    }
					
			else if(((typeof matchCriteria) == "object")){
				
				var validDate = new Date("January 01, 1970 00:01");
				var flag = 1;
				if (matchCriteria.endTime!=null && typeof matchCriteria.endTime!="undefined" && typeof matchCriteria.endTime =="object") {
					try {
                        var etime = matchCriteria.endTime;
						var year = etime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if(flag)
					   {
					   	if ((matchCriteria.endTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					   }
				}
				
				if (matchCriteria.startTime!=null && typeof matchCriteria.startTime!="undefined" && typeof matchCriteria.startTime =="object") {
					try {
                        var stime = matchCriteria.startTime;
						var year = stime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if (flag) {
						if ((matchCriteria.startTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					}

				}
				
				
			}
				
                
                     var retValue = qtCommlogIf.getList(matchCriteria);                                                                        
                     if ((typeof retValue.status) != "undefined" && retValue.status != 0)                                                               
                   throw new DeviceException(retValue.status, retValue.message);                                                                     
                 else{                                                                                                                                
         return  retValue;                                                                                                                          
                 }   
            }
            else {
                //input validations..
                if (successCallback == "undefined" || successCallback == null) {
                    throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : getList : callback is missing");
                }
                else 
                    if ((typeof successCallback) != "function") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : callback is invalid");
                    }
                if ((typeof matchCriteria) == "undefined" || matchCriteria == null) {
                    matchCriteria = {};
                }
                else 
                    if ((typeof matchCriteria) != "object") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid");
                    }
			else if(((typeof matchCriteria) == "object")){
				
				var validDate = new Date("January 01, 1970 00:01");
				var flag = 1;
				if (matchCriteria.endTime!=null && typeof matchCriteria.endTime!="undefined" && typeof matchCriteria.endTime =="object") {
					try {
                        var etime = matchCriteria.endTime;
						var year = etime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if(flag)
					   {
					   	if ((matchCriteria.endTime) < validDate) {
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
						}
					   }
				}
				
				if (matchCriteria.startTime!=null && typeof matchCriteria.startTime!="undefined" && typeof matchCriteria.startTime =="object") {
					try {
                        var stime = matchCriteria.startTime;
						var year = stime.getFullYear();							
					}
					catch(e){
						flag = 0;
					}
					if (flag) {
						if ((matchCriteria.startTime) < validDate) 
							throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : matchCriteria is invalid < 1970");
					}

				}
				
				
				
			}
				
                if ((typeof errorCallback) == "undefined" || errorCallback == null) {
                    errorCallback = null;
                }
                else 
                    if (errorCallback && (typeof errorCallback) != "function") {
                        throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : getList : errorCallback is not a function");
                    }
                
				//Add new callback
                var tid = asyncCallbackMap.add(successCallback, errorCallback);
                var returnValue = qtCommlogIf.getList(matchCriteria, tid);
                
                if (returnValue.status != 0) {
					//Error, hence remove callback entry from map
					asyncCallbackMap.remove(tid);
                    switch (returnValue.status) {
                        case error.INVALID_ARG_ERR:
                        case error.MISSING_ARG_ERR:
                        case error.NOT_SUPPORTED_ERR:
                            throw new DeviceException(returnValue.status, returnValue.message);
                        default:
                            if (errorCallback) {
                                setTimeout(function(){
                                    errorCallback(new DeviceException(returnValue.status, returnValue.message));
                                }, 1000);
                                return;
                            }
                            else {
                                throw new DeviceException(returnValue.status, returnValue.message);
                            }
                    }
                    
                    
                    
                }
                
                return tid;
            }
            
            
        },
        
        /**
         * Subscribe for Events  Notification.
         * This is an asynchronous method.
         *
         * @param {function} succesCallback A callback function with the signature
         *                     <i>function(errorCode, transId, result)</i>
         *
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * {@link DeviceError}
         * @return {void}
         * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR):
         *                              <ul>
         *                              <li>succesCallback  is not a function</li>
         *                              <li>errorCallback is not a function</li>
         *                              </ul>
         */
        setNotification: function(successCallback, errorCallback){
            //input validations..
            if (successCallback == "undefined") {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : setNotification : callback is missing");
            }
            else 
                if ((typeof successCallback) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : setNotification : callback is invalid");
                }
            
            if ((typeof errorCallback) == "undefined" || errorCallback == null) {
                errorCallback = null;
            }
            else 
                if (errorCallback && (typeof errorCallback) != "function") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog : setNotification : errorCallback is invalid");
                }
            
			//Remove previous callback entry
            if (notifyTid) {
                asyncCallbackMap.remove(notifyTid);
            }
			//Add new callback
            var tid = asyncCallbackMap.add(successCallback, errorCallback);
			//Store current transactionId			
            notifyTid = tid;
            var returnValue = qtCommlogIf.setNotification(tid);
            
            if (returnValue.status != 0) {
				//Error, hence remove callback entry from map
				asyncCallbackMap.remove(notifyTid);
				//Error, hence set to null
				notifyTid = null;
                switch (returnValue.status) {
                    case error.INVALID_ARG_ERR:
                    case error.MISSING_ARG_ERR:
                    case error.NOT_SUPPORTED_ERR:
                        throw new DeviceException(returnValue.status, returnValue.message);
                    default:
                        if (errorCallback) {
                            setTimeout(function(){
                                errorCallback(new DeviceException(returnValue.status, returnValue.message));
                            }, 1000);
                            return;
                        }
                        else {
                            throw new DeviceException(returnValue.status, returnValue.message);
                        }
                }
                
            }
        },
        
        /**
         * Cancel a call for getList.
         * This is synchronous API.
         *
         * @param {number} transactionId to cancel the notification
         * @return {void}
         * @exception {DeviceException}  Code 1 (MISSING_ARG_ERR): If transactionId is missing.<br>
         *                               Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
         *                               Code 101 (DATA_NOT_FOUND_ERR): If there are no active notification request corresponds to the specified trasactionid.
         */
        cancel: function(transId){
            if (!transId) {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : cancel : transactionId is missing");
            }
            
            else 
                if (typeof(transId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog: cancel: transaction id is invalid");
                }
            
            var returnValue = qtCommlogIf.cancel(transId);
            
			//Cancel, hence remove callback entry from map
            asyncCallbackMap.remove(transId);
            
            if (returnValue.status) {
                throw new DeviceException(returnValue.status, returnValue.message);
            }
        },
        
        /**
         * Cancels a request for notification.
         * This is synchronous API.
         *
         * @return {void}
         * @exception {DeviceException}  Code 101 (DATA_NOT_FOUND_ERR): If there are no active notification request corresponds to the specified trasactionid.
         */
        cancelNotification: function(){
        	
			qtCommlogIf.cancelNotification(notifyTid);
			//Check if setNotification was called. If running, then remove entry from map and set to null.
            if (notifyTid) {
                asyncCallbackMap.remove(notifyTid);
                notifyTid = null;
            }
            
           
        },
        
        /**
         * Deletes a log entry in the databse.
         * This is a synchronous API.
         *
         * @param {number} logId to delete the log
         * @return {void}
         * @exception {DeviceException}  Code 1 (MISSING_ARG_ERR): If logId is missing.<br>
         *                               Code 2 (INVALID_ARG_ERR): logId is not a number.<br>
         *                               Code 101 (DATA_NOT_FOUND_ERR): If a non-existent logId is passed.
         */
        deleteLogEntry: function(logId){
            if (!logId) {
                throw new DeviceException(error.MISSING_ARG_ERR, "CommLog : cancelNotification : transactionId is missing");
            }
            
            else 
                if (typeof(logId) != "number") {
                    throw new DeviceException(error.INVALID_ARG_ERR, "CommLog: cancelNotification: transaction id is invalid");
                }
            
            var returnValue = qtCommlogIf.deleteLogEntry(logId);
            
            if (returnValue.status) {
                throw new DeviceException(returnValue.status, returnValue.message);
            }
        }
    };
}
