#!/usr/local/bin/perl -w
use XML::Simple;
use File::Path;
use File::Copy;
use Data::Dumper;

my $path = "./";
my $file = "./config/config.xml";
my $config = XMLin($path . $file);

print "Trying to update the SVN directory...\n";
system "svn update";

if( -e "./wgtwidgets" )
    {
    rmtree("./wgtwidgets");
    }
if( -e "./wgzwidgets" )
    {
    rmtree("./wgzwidgets");
    }

if( -e "./temp" )
    {
    rmtree("./temp");
    }
if( -e "./release/platformservices.js" )
    {
    unlink("./release/platformservices.js");
    }
system "mkdir temp";

  #print Dumper($config);  
if( -e $config->{provider} ) 
    {
    print "Merging and generating platformservices.js file ...\n";
    $path = "./" . $config->{provider};
    if( -e $path ) 
        {
        @files = <$path/*>;
        
        open MODFILE, ">./temp/$config->{provider}.txt" or die $!; 
        foreach $file (@files) 
            {            
            print MODFILE "$file\n"; 
            }
        close MODFILE;
        
        system "java -jar ./tools/JsCombine.jar ./temp/$config->{provider}.txt ./release/$config->{provider}.js > ./temp/$config->{provider}.log";        
        }
        
    open DOMFILE, ">./temp/jsfiles.txt" or die $!; 
    print DOMFILE "./release/framework.js\n";
    @files = <./release/*.js>;
    foreach $file (@files) 
        {
        if( $file ne "./release/framework.js" )
            {
            print DOMFILE "$file\n";    
            }
        }
    close DOMFILE;
    
    system "java -jar ./tools/JsCombine.jar ./temp/jsfiles.txt ./temp/intermediate.js > ./temp/combinejs.log";
    system "java -jar ./tools/custom_rhino.jar -c ./temp/intermediate.js > ./release/platformservices.js";
    
    print "Finally generating widgets...\n";
    
    $path = "./testasset/" . $config->{provider} . "/tsrc";
    if( -e $path ) 
        {
        opendir($dir, $path) || die "can't opendir $path: $!";
        @widgets = readdir($dir); 
        foreach $widget (@widgets) 
            {
            next if ($widget =~ m/^\./);
            $widgetpath = $path . "/" . $widget;
            if( -d $widgetpath ) 
                {
                $zippedfiles = "";
                
                copy("./release/platformservices.js", "$widgetpath/platformservices.js") or die "File cannot be copied.";
                copy("./common/ctesttree.js", "$widgetpath/ctesttree.js") or die "File cannot be copied.";
                
                opendir($widdir, $widgetpath) || die "can't opendir $widgetpath: $!"; ;    
                @widfiles = readdir($widdir);
                
                foreach $widfile (@widfiles) 
                    {
                    next if ($widfile =~ m/^\./);
                    $zippedfiles = $zippedfiles . " " . $widgetpath . "/" . $widfile;
                
                    }
                system "7z a -tzip ./wgtwidgets/$widget.zip $zippedfiles > ./temp/wgt_$widget.log";
                rename "./wgtwidgets/$widget.zip", "./wgtwidgets/$widget.wgt";
                system "7z a -tzip -xr!*svn*  ./wgzwidgets/$widget.zip $widgetpath > ./temp/wgz_$widget.log";
                rename "./wgzwidgets/$widget.zip", "./wgzwidgets/$widget.wgz";
                }            
            
            }
        closedir($dir);
        }
    }
else
    {
    print "Merging and generating platformservices.js file ...\n";
    for($i = 0; $i < scalar(@{$config->{provider}}); $i++)
        {
        $path = "./" . $config->{provider}->[$i];
        if( -e $path ) 
            {
            @files = <$path/*>;
            
            open MODFILE, ">./temp/$config->{provider}->[$i].txt" or die $!; 
            foreach $file (@files) 
                {            
                print MODFILE "$file\n"; 
                }
            close MODFILE;
            
            system "java -jar ./tools/JsCombine.jar ./temp/$config->{provider}->[$i].txt ./release/$config->{provider}->[$i].js > ./temp/$config->{provider}->[$i].log";        
            }
        }
        
    open DOMFILE, ">./temp/jsfiles.txt" or die $!; 
    print DOMFILE "./release/framework.js\n";
    @files = <./release/*.js>;
    foreach $file (@files) 
        {
        if( $file ne "./release/framework.js" )
            {
            print DOMFILE "$file\n";    
            }
        }
    close DOMFILE;
    
    system "java -jar ./tools/JsCombine.jar ./temp/jsfiles.txt ./temp/intermediate.js > ./temp/combinejs.log";
    system "java -jar ./tools/custom_rhino.jar -c ./temp/intermediate.js > ./release/platformservices.js";
    
    print "Finally generating widgets...\n";
    for($i = 0; $i < scalar(@{$config->{provider}}); $i++)
        {
        $path = "./testasset/" . $config->{provider}->[$i] . "/tsrc";
        if( -e $path ) 
            {
            opendir($dir, $path) || die "can't opendir $path: $!";
            @widgets = readdir($dir); 
            foreach $widget (@widgets) 
                {
                next if ($widget =~ m/^\./);
                $widgetpath = $path . "/" . $widget;
                if( -d $widgetpath ) 
                    {
                    $zippedfiles = "";
                    
                    copy("./release/platformservices.js", "$widgetpath/platformservices.js") or die "File cannot be copied.";
                    copy("./common/ctesttree.js", "$widgetpath/ctesttree.js") or die "File cannot be copied.";
                    
                    opendir($widdir, $widgetpath) || die "can't opendir $widgetpath: $!"; ;    
                    @widfiles = readdir($widdir);
                    
                    foreach $widfile (@widfiles) 
                        {
                        next if ($widfile =~ m/^\./);
                        $zippedfiles = $zippedfiles . " " . $widgetpath . "/" . $widfile;
                    
                        }
                    system "7z a -tzip ./wgtwidgets/$widget.zip $zippedfiles > ./temp/wgt_$widget.log";
                    rename "./wgtwidgets/$widget.zip", "./wgtwidgets/$widget.wgt";
                    system "7z a -tzip -xr!*svn*  ./wgzwidgets/$widget.zip $widgetpath > ./temp/wgz_$widget.log";
                    rename "./wgzwidgets/$widget.zip", "./wgzwidgets/$widget.wgz";
                    }            
                
                }
            closedir($dir);
            }
        }
    }

