/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef SESSIONIDTABLE_H
#define SESSIONIDTABLE_H

namespace WRT
{
// CONSTANTS

const int SessionIdTableSize = 65536;

// CLASS DECLARATION

/*!
* Class for acquiring session Ids.
*
*/
class SessionIdTable
{

    public:

        SessionIdTable();

        int allocate();

        void release( int aSessionId );

    private: // Data

        bool m_data[SessionIdTableSize];

};
}
#endif // SESSIONIDTABLE_H
// End of file
