/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include "serviceipcserverfactory.h"
#ifndef __SYMBIAN32__
#include "serviceipcserverlocalsocket_p.h"
#else
#include "serviceipcserversymbianserver_p.h"
#endif // __SYMBIAN32__
namespace WRT
{

/*!
 \class ServiceFwIPCServerFactory
 Factory class to construct IPC server backend
 */

/*!
 Destructor
 */
ServiceFwIPCServerFactory::~ServiceFwIPCServerFactory()
{
}

/*!
 Constructor
 */
ServiceFwIPCServerFactory::ServiceFwIPCServerFactory()
{
}

/*!
 Construct a backend
 @param aBackend backend to construct
 @param aParent parent to this QObject
 */
ServiceFwIPCServerPrivate* ServiceFwIPCServerFactory::createBackend(QObject* aParent,
                                                                    TServiceIPCBackends aBackend)
{
    ServiceFwIPCServerPrivate* backend(NULL);

#ifndef __SYMBIAN32__
    // Local socket is default
    if ( aBackend == ELocalSocket || aBackend == EDefaultIPC )
    {
        backend = new ServiceFwIPCServerLocalSocket( aParent );
    }
#else
    // Symbian server is default
    if (aBackend == ESymbianServer || aBackend == EDefaultIPC) {
        TRAP_IGNORE( backend = CServiceSymbianServer::NewL(); );
    }
#endif
    return backend;
}
}
// END OF FILE
