/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceipclocalsocketsession_h
#define serviceipclocalsocketsession_h

#include "serviceipcserversession.h"
#include "serviceipcserverlocalsocket_p.h"

class MServiceIPCObserver;
class QLocalSocket;

namespace WRT {

    class MServiceIPCObserver;

    class LocalSocketSession : public ServiceIPCSession
    {
    Q_OBJECT
    public:

        virtual ~LocalSocketSession();

                        LocalSocketSession(QLocalSocket* aNewSocket,
                                           MServiceIPCObserver* aObserver);

        // From ServiceIPCSession

        bool write(const QByteArray& aData);

        bool completeRequest();

        void close();

        inline void releaseSessionId(int aSessionId)
        {
            ((ServiceFwIPCServerLocalSocket* )parent())->releaseSessionId(aSessionId);
        };

        inline void appendBroadcastList(int aSessionId, ServiceIPCSession * aSession)
        {
            ((ServiceFwIPCServerLocalSocket*) parent())->appendBroadcastList(aSessionId, aSession);
        };

    public slots:

        void handleRequest();

    private slots:

        void handleDisconnect();

    private:

        void doCancelRequest();

        signals:

        void disconnected(ServiceIPCSession* aSession);

    private:
        QLocalSocket* m_socket;
    };

}

#endif // serviceipclocalsocketsession_h
