/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WIDGETINSTALLERVIEW_H
#define WIDGETINSTALLERVIEW_H

#include <QObject>

#include "SuperWidget.h"

class WidgetManager;
class WgtWidget;

class WidgetInstallerView : public QObject {
        Q_OBJECT
    public:
        explicit WidgetInstallerView(WidgetManager* widgetMgr, QObject* parent = 0);
        ~WidgetInstallerView();

        /**
         * Returns a result code of installation.
         * @see Result codes are declared in enum SuperWidget::WidgetInstallError
         */
        int result() const;

        /** When set no dialogs will be shown even if an error occurs
          * during widget installation.
          * \param mode True if silent operation is wanted.
          */
        void setSilentMode(bool mode);

    private:
        WidgetManager* m_widgetMgr;
        int m_result;
        bool m_silentMode;

    public slots:
        void slotInstallationError(WidgetInstallError error);
        void slotAboutToReplaceExistingWidget();
        void slotAboutToInstallWidgetWithFeatures(QList<QString> capList);
        void slotInstallationSucceeded();
        void slotAboutToInstallUntrustedWidget(WidgetInstallError error);
};

#endif // WIDGETINSTALLERVIEW_H
