/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifdef Q_OS_MAEMO6
#include <DuiInfoBanner>
#include <DuiDialog>
#include <DuiSceneWindow>
#include <DuiLocale>
#endif

#ifdef Q_OS_MAEMO5
#include <QMaemo5InformationBox>
#endif

#include <QDebug>

#include "widgetinstallerview.h"
#include "WgtWidget.h"
#include "WidgetManager.h"

WidgetInstallerView::WidgetInstallerView(WidgetManager * widgetMgr, QObject * parent) :
        QObject(parent), m_widgetMgr(widgetMgr), m_result(0), m_silentMode(false) {
}


void WidgetInstallerView::slotInstallationError(WidgetInstallError error) {
    m_result = error;

    //Get the correct error message
    QString message;
    switch (error) {

    // Invalid package widgets
    case WidgetCorrupted:
    case WidgetUnZipBundleFailed: {
        message = qtTrId("Installation of application failed - invalid package.");
        break;
    }

    // Not valid W3C widget (wgt or not having config.xml)
    case WidgetTypeValidationFailed:
    case WidgetParseManifestFailed: {
        message = qtTrId("Installation of web application failed - not supported.");
        break;
    }

    case WidgetInsufficientDiskSpace: {
        message = qtTrId("Installation of web application failed - out of space.");
        break;
    }

    // All internal errors
    case WidgetStartFileNotFound:
    case WidgetPlatformSpecificInstallFailed:
    case WidgetCapabilityNotAllowed:
    case WidgetRmDirFailed:
    case WidgetReplaceFailed:
    case WidgetRegistrationFailed:
    case WidgetFindSignatureFailed:
    case WidgetInstallFailed:
    case WidgetSharedLibraryNotSigned: {
        message = qtTrId("Installation of web application failed.");
        break;
    }

    default: {
        qCritical() << "Unknown widget installation error code:" << error;
        break;
    }
    }
    if (!m_silentMode) {

#ifdef Q_OS_MAEMO6
        DuiInfoBanner* b = new DuiInfoBanner(DuiInfoBanner::Event);
        b->setIconID("Icon-music");
        b->setBodyText(message);
        b->appear(DuiSceneWindow::DestroyWhenDone);
#endif

#ifdef Q_OS_MAEMO5
        // TODO: localization
        QMaemo5InformationBox::information(0, message);
#endif
    }
    qWarning() <<"Widget installation error:"  <<  message;
}


void WidgetInstallerView::slotInstallationSucceeded() {
    m_result = WidgetInstallSuccess;
}

void WidgetInstallerView::slotAboutToReplaceExistingWidget() {
    m_widgetMgr->tryContinueInstallation();
}

void WidgetInstallerView::slotAboutToInstallWidgetWithFeatures(QList<QString> capList) {
    //TODO: if we need to show some UI control with list of granted features
    //      this is the place we
    m_widgetMgr->tryContinueInstallation();
}

void WidgetInstallerView::slotAboutToInstallUntrustedWidget(WidgetInstallError error) {
    //TODO: Switch to common method to convert "error" to a localized QString
    //      Add UI for end-user notification (e.g. info banners) if needed.
/*    QString message = "";
    switch (error) {
    case WidgetFindSignatureFailed:
        message = "Digital signatures not found.";
        break;
    case WidgetSignatureParsingFailed:
        message = "Digital signature parsing failed.";
        break;
    case WidgetSignatureOrSignedInfoMissing:
        message = "Signature or signed info missing";
        break;
    case WidgetSignatureRefExistFailed:
        message = "Reference check failed";
        break;
    case WidgetCertValidationFailed:
        message = "Certificate validation failed.";
        break;
    case WidgetSignatureValidationFailed:
        message = "Signature validation failed.";
        break;
    case WidgetSignatureRefValidationFailed:
        message = "Reference validation failed.";
        break;
    default:
        message = "Unknown error";
        break;
    }

    qWarning() << "Installing untrusted widget:"  <<  message;*/

    m_widgetMgr->tryContinueInstallation();
}

int WidgetInstallerView::result() const {
    return m_result;
}

void WidgetInstallerView::setSilentMode(bool mode) {
    m_silentMode = mode;
}

WidgetInstallerView::~WidgetInstallerView() {
}
