/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef STANDALONEVIEW_H
#define STANDALONEVIEW_H

#include <QGraphicsView>
#include <QGraphicsWebView>

class QMenuBar;

namespace WRT {

class WrtPage;
class JSContextMenu;

namespace Maemo {

class WebKineticScroller;
class ExitButton;
class WrtWebInspector;

class StandaloneView : public QGraphicsView
{
    Q_OBJECT

public:
    StandaloneView(QGraphicsWebView* webView, QWidget* parent = 0, bool enableInspector = false);
    ~StandaloneView();

    void restore();
    void setPage(WrtPage* page);
    void setContextMenu(WRT::JSContextMenu* contextMenu);
    void setMenu(QMenu* menu);
    void showFullScreen(bool windowedSupported);

public slots:
    void showInspector(bool show);

signals:
    void visibilityChanged(bool visible);
    void exitRequested();

protected:
    void closeEvent(QCloseEvent* event);
    void resizeEvent(QResizeEvent* event);
    void contextMenuEvent(QContextMenuEvent *event);
    void changeEvent(QEvent* event);

private:
    QMenuBar* m_menuBar;
    ExitButton* m_exitButton;
    QGraphicsWebView* m_webView;
    QGraphicsScene* m_scene;
    WRT::JSContextMenu* m_contextMenu;
    WebKineticScroller* m_scroller;
    WrtWebInspector* m_inspector;
    QAction* m_actWebInspector;
};

}
}

#endif // STANDALONEVIEW_H
