/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "floatingview.h"

#include "wrtpage.h"

#include <QApplication>
#include <QDesktopWidget>
#include <QGraphicsView>
#include <QGraphicsWebView>
#include <QWebFrame>

namespace WRT {
namespace Maemo {

FloatingView::FloatingView(QGraphicsWebView* webView, const QString& id, QWidget* parent)
    : HomeScreenView(id, parent)
    , m_view(new QGraphicsView(this))
    , m_scene(new QGraphicsScene)
    , m_webView(webView)
{
    m_view->setScene(m_scene);
    m_scene->addItem(m_webView);

    QPalette palette = m_view->viewport()->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    m_view->viewport()->setPalette(palette);

    // FIXME: QDesktopWidget::availableGeometry() would be a better choice.
    // However, it reports different geometries randomly, so we cannot rely
    // on it.
    // For now, we are using screenGeometry which always returns (0, 0, 800, 480)
    // and setting FloatingView maximum size to be same as desktop size, subtracting
    // top panel's height (56px) from height.
    QRect desktopGeometry = QApplication::desktop()->screenGeometry();
    QSize desktopSize(desktopGeometry.width(), desktopGeometry.height() - 56);
    setMaximumSize(desktopSize * 0.5);
}

FloatingView::~FloatingView()
{
    delete m_scene;
}

void FloatingView::resizeEvent(QResizeEvent* event)
{
    QWidget::resizeEvent(event);

    setUpdatesEnabled(false);

    QRect rect(QPoint(0, 0), event->size());
    m_scene->setSceneRect(rect);
    m_view->setGeometry(rect);
    m_webView->setGeometry(rect);

    if (m_webView->page())
        m_webView->page()->setViewportSize(event->size());

    setUpdatesEnabled(true);
}

void FloatingView::freeze()
{
    if (m_scene == m_webView->scene())
        m_scene->removeItem(m_webView);

    HomeScreenView::freeze();
}

void FloatingView::restore()
{
    HomeScreenView::restore();

    if (m_scene != m_webView->scene())
        m_scene->addItem(m_webView);

    QRect rect(QPoint(0, 0), size());
    m_webView->setGeometry(rect);
}

}
}
