// Copyright 2010 Ilkka Tengvall
//
// This file is part of Woller.
//
// Woller is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Woller is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Woller.  If not, see <http://www.gnu.org/licenses/>.

#ifndef WOLLER_H
#define WOLLER_H

#include <QtGui>
#include <QUdpSocket>
#include <QDebug>
#include <QWidget>
#include <QDialog>
#include <QHostAddress>
#include <QLabel>
#include <QPushButton>
#include <QComboBox>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLineEdit>

//class QLabel;
//class QPushButton;
//class QComboBox;
//class QVBoxLayout;
//class QHBoxLayout;
//class QLineEdit;

struct host_s
{
    QString hostname;
    QString mac;
    QHostAddress ip;
};


class HostWidget : public QWidget
{
    Q_OBJECT

public:
    HostWidget(QWidget *parent = 0, host_s *host = 0);
    ~HostWidget();
    QLineEdit *hostname;
    QLineEdit *mac;
    QLineEdit *ip;

public slots:
    void ok_sig();
    void cancel_sig();

signals:
    void change_host();

private:
    QVBoxLayout *vlayout;
    QHBoxLayout *host_row;
    QLabel *host_lbl;
    QLabel *mac_lbl;
    QHBoxLayout *mac_row;
    QLabel *ip_lbl;
    QHBoxLayout *ip_row;
    QPushButton *cancel;
    QPushButton *ok;
    QHBoxLayout *button_row;
    host_s *new_host;
};


class ConfigWidget : public QWidget
{
    Q_OBJECT

public:
    ConfigWidget(QWidget *parent = 0, QList<host_s> *hosts = 0);
    ~ConfigWidget();
    //QListWidget *lista(QWidget *parent = 0);
    //QListWidget *lista;

public slots:
    void add_sig();
    void edit_sig();
    void del_sig();
    void save_sig();
    void close_sig();
    void select_sig();
    void host_added();
    void host_edited();

signals:
    void hosts_changed();

private:
//    QPushButton *add_host;
    QListWidget *list;
    QVBoxLayout *button_layout;
    QHBoxLayout *layout;
    QPushButton *add_host;
    QPushButton *edit_host;
    QPushButton *del_host;
    QPushButton *save_btn;
    QPushButton *close_btn;
    HostWidget *host_widget;
    QList<host_s> *hosts_list;
    host_s host_tmp;
};


class wol_target
{

public:
    wol_target();
    ~wol_target();
    int wake_me();
    int get_mac( QString *gmac);
    int set_mac( const QString mac );
    int get_ip( QHostAddress *ip );
    int set_ip( const QHostAddress );

private:
#define WOL_MAGIC_MAC_CNT 16
#define WOL_MAGIC_UDP_PORT 9
    QString *mac;
    QHostAddress *ip;
    QByteArray *magic_pkt;
    int create_magic_pkt( const QString *mac );
};



#define MAX_MAC_LEN 12
#define MAX_IP_LEN 15


class Woller : public QWidget
{
    Q_OBJECT

#define WOLLER_RC_FILE ".wollerrc"


public:
    Woller(QWidget *parent = 0);
    ~Woller();
    QList<host_s> hosts;

public slots:
    void send_pkt();
    void targets_act(int);
    void add_new(host_s *host);
    void hosts_changed();
    void reset_status();

private:
    QTimer *status_timer;
    QLabel *status_lbl;
    QString *status_orig;
    QPushButton *fire_btn;
    QComboBox *targets_cb;
    QVBoxLayout *vlayout;
    QHBoxLayout *hlayout;
    wol_target *target;
    void config();
    ConfigWidget *config_win;
    void save_config();
    void load_config();

    QList<host_s> *hosts_list;
    QSettings *settings;
    void do_list();
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

protected:

private slots:

private:

    Woller *woller;
};

#endif
