#!/usr/bin/env python
# coding=UTF-8
#
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: win.py 2226 2010-02-11 23:44:56Z v13 $

from PyQt4 import QtGui
from PyQt4.QtCore import SIGNAL, Qt

import sys

import graph, wifi
#import portrait

win=None

class MainWin(QtGui.QMainWindow):
    def setupUi(self):
	self.centralwidget=QtGui.QWidget(self)
	self.centralwidget.setObjectName("centralwidget")

	self.l0=QtGui.QVBoxLayout(self.centralwidget)

	self.graph=graph.WifiGraph()
	self.graph.setObjectName("graph")
	self.l0.addWidget(self.graph)

	self.l1=QtGui.QHBoxLayout()
	self.buttonRefresh=QtGui.QPushButton(self.centralwidget)
	self.l1.addWidget(self.buttonRefresh)
	spacer=QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding,
	    QtGui.QSizePolicy.Minimum)
	self.l1.addItem(spacer)
	self.l0.addLayout(self.l1)

	self.setCentralWidget(self.centralwidget)

	self.retranslateUi()

	self.connect(self.buttonRefresh, SIGNAL('clicked()'), self.slotRefresh)

    def retranslateUi(self):
	self.setWindowTitle("Wifi Eye")
	self.buttonRefresh.setText("Refresh")

    def setData(self, dt):
	self.graph.setData(dt)

    def slotRefresh(self):
	dt=wifi.scan()
	self.setData(dt)
	self.repaint()


def init():
    global app, win, por
    app=QtGui.QApplication(sys.argv)
    #app.setAttribute(Qt.WA_Maemo5ForceLandscapeOrientation, True);
#    win0=QtGui.QMainWindow()
    win=MainWin()
    #por=portrait.FremantleRotation("wifieye", win, '1.0')

    win.setupUi()

def doit(dt):
    global app, win
    win.setData(dt)
    win.show()
    #label=QtGui.QLabel("test")

    #label.show()
    sys.exit(app.exec_())

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

