#!/usr/bin/env python
# coding=UTF-8
#
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: wifi.py 2226 2010-02-11 23:44:56Z v13 $

import pickle, subprocess
import os

import config

fakedata={'00:1D:7E:0D:41:99': {'bssid': '00:1D:7E:0D:41:99', 'rates': [[1000000, 2000000, 5500000, 11000000, 6000000, 9000000, 12000000, 18000000, 24000000, 36000000, 48000000, 54000000]], 'essid': 'V13-Home', 'freq': {'m': 2412, 'e': 6}, 'quality': {'signal': 210, 'noise': 165, 'quality': 75}, 'mode': 'Master'}, '00:14:BF:6F:C3:99': {'bssid': '00:14:BF:6F:C3:99', 'rates': [[1000000, 2000000, 5500000, 11000000, 22000000, 6000000, 9000000, 12000000, 18000000, 24000000, 36000000, 48000000, 54000000]], 'essid': 'MANOLAS-NET', 'freq': {'m': 2462, 'e': 6}, 'quality': {'signal': 169, 'noise': 166, 'quality': 12}, 'mode': 'Master'}, '00:05:59:0B:71:99': {'bssid': '00:05:59:0B:71:99', 'rates': [[1000000, 2000000, 5500000, 11000000, 22000000, 6000000, 9000000, 12000000, 18000000, 24000000, 36000000, 48000000, 54000000]], 'essid': 'NetFasteR IAD (PSTN)', 'freq': {'m': 2437, 'e': 6}, 'quality': {'signal': 167, 'noise': 164, 'quality': 9}, 'mode': 'Master'}}

def scan():
    if config.nosudo:
	dt=fakedata
    else:
	d=os.path.dirname(os.path.realpath(__file__))
	cmd=["sudo", d+"/wifi-su.py"]
	c0=subprocess.Popen(cmd, stdout=subprocess.PIPE)
	c=c0.communicate()[0]
	dt=pickle.loads(c)

    return(dt)

if __name__=="__main__":
    print scan()

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

