#!/usr/bin/env python
# coding=UTF-8
#
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: graph.py 2226 2010-02-11 23:44:56Z v13 $

from PyQt4 import QtCore
from PyQt4.QtCore import Qt
from PyQt4.QtGui import *

import sys

class WifiColors:
    def __init__(self):
	self.colors=[
	    Qt.green,
	    Qt.cyan,
	    Qt.magenta,
	    Qt.yellow,
	    Qt.red,
	    Qt.darkGreen,
	    Qt.darkCyan,
	    Qt.darkMagenta,
	    Qt.darkYellow,
	    Qt.darkRed,
	    Qt.blue,
	    Qt.darkBlue,
	    Qt.gray,
	    Qt.darkGray
	    ]
	
    def get(self, cnt):
	return(self.colors[cnt%len(self.colors)])

class WifiGraph(QWidget):
    def __init__(self):
	QWidget.__init__(self)
	
	self.padding_top=20	# This is fixed
	self.space_bottom=80	# This too

	self.width=780	    # Total width - This changes with resizes

	self.bar_x=80
	self.bar_y=350

	self.height=self.bar_y - self.padding_top

	# All channels:
	# Europe: First 11
	# USA: First 13
	# Japan: All 14
	self.channels=[
	    2412, 2417, 2422, 2427, 2432, 2437, 2442, 2447,
	    2452, 2457, 2462, 2467, 2472,
	    2484    # Japan only ?
	    ]
	self.channel_width=22	    # Width of each channel in MHz
	#self.channel_step=5

	self.dt={}

	self.colors=WifiColors()
    # End of __init__()

    def setData(self, dt):
	self.dt=dt

    def paintEvent(self, event):
	axes=QPen(Qt.white, 2, Qt.SolidLine)
	axestext=QPen(Qt.darkGray, 2, Qt.SolidLine)

	#axesdash=QPen(QColor(0x66, 0x66, 0x66), 2, Qt.DashLine)
	axesdash=QPen(QColor(0x66, 0x66, 0x66), 2, Qt.DotLine)

	colbg=QColor(0x33, 0x33, 0x33)

	painter=QPainter(self)
	font0=QFont(painter.font())

	font_ssid=QFont(font0)
	font_ssid.setPointSizeF(12)
	font_ssid_m=QFontMetrics(font_ssid)

	font_xaxis1=QFont(font0)
	font_xaxis1.setPointSizeF(12)
	font_xaxis1_m=QFontMetrics(font_xaxis1)
	font_yaxis1=font_xaxis1
	font_yaxis1_m=font_xaxis1_m

	font_xaxis2=QFont(font0)
	font_xaxis2.setPointSizeF(16)
	font_xaxis2_m=QFontMetrics(font_xaxis2)
	#font_xaxis2.setWeight(font_xaxis2.Bold)
	font_yaxis2=font_xaxis2
	font_yaxis2_m=font_xaxis2_m

	painter.setRenderHints(painter.Antialiasing | \
	    painter.TextAntialiasing | \
	    painter.HighQualityAntialiasing
	    )

	#painter.setBackgroundMode(Qt.OpaqueMode)
	#painter.setBackground(
	#    QBrush(Qt.white)
	#    )
	outerRect=QtCore.QRect(self.bar_x-1, self.padding_top,
		self.width - self.bar_x - 1, self.bar_y - self.padding_top)
	painter.fillRect(outerRect, QBrush(colbg))

	painter.setPen(axes)
	painter.drawRect(outerRect)

	painter.setBackgroundMode(Qt.TransparentMode)
	painter.setPen(axes)
	#painter.drawLine(self.bar_x, self.bar_y, self.width, self.bar_y)
	#painter.drawLine(self.bar_x, self.padding_top,self.bar_x, self.bar_y)

	# Frequency width in MHz
	freqw=(self.channels[len(self.channels)-1] - self.channels[0]) + \
	    self.channel_width

	ch0=self.channels[0]
	wx=self.width - self.bar_x
	painter.setFont(font_xaxis1)
	t_h=font_xaxis1_m.height()
	for ch in self.channels:
	    chanx=self.bar_x + \
		(wx * ((self.channel_width/2) + ch - ch0) / freqw)

	    painter.setPen(axes)
	    painter.drawLine(chanx, self.bar_y-10, chanx, self.bar_y+10)

	    painter.setPen(axestext)
	    painter.drawText(
		QtCore.QRect(chanx-30, self.bar_y+10, 60, t_h),
		Qt.AlignCenter,
		"%d" % (self.channels.index(ch)+1)
		)
	painter.setFont(font0)

	painter.setFont(font_xaxis2)
	t_h2=font_xaxis2_m.height()
	painter.drawText(
	    QtCore.QRect(self.bar_x, self.bar_y+t_h+(t_h*0.3)+10,
		self.width-self.bar_x, t_h2),
	    Qt.AlignCenter,
	    "Wifi Channel"
	    )

	dxch=self.channel_width * wx / (2*freqw)
	ystep=30
	cnt=0
	graphheight=self.height - self.padding_top - self.space_bottom
	#print "dxch:", dxch, "wx:", wx, "freqw:", freqw
	last_y=-1000
	painter.setFont(font_yaxis1)
	t_h=font_yaxis1_m.height()
	for i in xrange(0, 101, 10):
	    dy=1.0 * graphheight * i/100
	    y=self.padding_top + graphheight - dy
	    painter.setPen(axes)
	    painter.drawLine(self.bar_x-5, y, self.bar_x+5, y)

	    if abs(y - last_y) > 40:
		painter.setPen(axestext)
		font=QFont(font0)
		font.setPointSizeF(11)
		painter.setFont(font)
		painter.drawText(
		    QtCore.QRect(0, y-(t_h/2), self.bar_x-10, t_h),
		    Qt.AlignRight,
		    "%d%%" % i
		    )
		last_y=y
	    if i==0 or i==100:
		continue
	    painter.setPen(axesdash)
	    painter.drawLine(self.bar_x+5, y, self.width-2, y)
	painter.setFont(font0)

	for bssid in self.dt:
	    d=self.dt[bssid]
	    ch=d['freq']['m']
	    x=self.bar_x + \
		(wx * ((self.channel_width/2) + ch - ch0) / freqw)

	    # Calculate height
	    dy=1.0 * graphheight * d['quality']['quality']/100
	    y0=self.padding_top + graphheight - dy

	    height=2*dy

	    line=QPen(self.colors.get(cnt), 2, Qt.SolidLine)

#	    qcol2=QColor(self.colors.get(cnt))
#	    qcol2.setAlpha(128)

#	    line2=QPen(qcol2, 2, Qt.SolidLine)
#	    line=line2

	    painter.setPen(line)
	    painter.drawArc(
		QtCore.QRect(x-dxch, y0, 2*dxch, height),
		0, 180*16)

	    y0_line=self.padding_top+(ystep*cnt)
	    
#	    lx=x
#	    ly=y0_line+50


	    lx=x
	    ly=y0
	    y0_line=ly-50

	    painter.setFont(font_ssid)
	    painter.drawText(
		QtCore.QRect(x-100, y0_line, 200, 2*ystep),
		Qt.AlignCenter,
		d['essid']
		)
#	    painter.setPen(line2)
	    painter.drawLine(lx, ly, x, self.bar_y)

	    painter.drawEllipse(lx-5, ly-5, 10, 10)
	
#	    painter.end()
#
#	    painter=QPainter(self)
#	    painter.drawText(
#		QRect(
#
#	    painter2.

	    cnt+=1

	# Ouch. Rotated text is hard!
	painter.setPen(axestext)
	painter.setFont(font_yaxis2)
	painter.rotate(-90)
	painter.drawText(
	    QtCore.QRect(- self.bar_y, 0, self.bar_y - self.padding_top,
		font_yaxis2_m.height()),
	    Qt.AlignCenter,
	    "Quality"
	    )

    def resizeEvent(self, event):
	sz=event.size()
	w=sz.width()
	h=sz.height()

	self.height=h
	self.width=max(w, 0)
	self.bar_y=max(h - self.space_bottom, 0)
# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

