#!/bin/sh

kernel=$(uname -r)

# defaults
if [ "$kernel" == "2.6.28.10-power50" ]; then
DRIVERPATH="/opt/wifi-pwner/compat-wireless/kp"
else
if [ "$kernel" == "2.6.28.10-power49+pre50" ]; then
DRIVERPATH="/opt/wifi-pwner/compat-wireless/kp"
else
DRIVERPATH="/opt/wifi-pwner/compat-wireless/kp-old"
fi
fi
FILEPATH="/opt/wifi-pwner/.default-mac"

# Save mac address
MACADDR="`ifconfig wlan0 | sed -n 's/.*HWaddr \([0-9A-Fa-f:]\+\).*/\1/p'`"

if [ ! -f $FILEPATH/myMAC ]; then
   echo $MACADDR > $FILEPATH/myMAC
fi

# Unload wifi modules
rmmod wl1251_spi 2>/dev/null
rmmod wl1251 2>/dev/null
rmmod wl12xx 2>/dev/null
rmmod mac80211 2>/dev/null
rmmod cfg80211 2>/dev/null
rmmod rfkill_backport 2>/dev/null
rmmod compat_firmware_class 2>/dev/null
rmmod compat 2>/dev/null
# Load bleeding-edge wl1251
insmod $DRIVERPATH/compat.ko
insmod $DRIVERPATH/rfkill_backport.ko
insmod $DRIVERPATH/cfg80211.ko
insmod $DRIVERPATH/mac80211.ko
insmod $DRIVERPATH/wl1251.ko
insmod $DRIVERPATH/wl1251_spi.ko
# Restore mac address
ifconfig wlan0 down hw ether "$MACADDR"

echo "Custom wl1251 module loaded (with injection) :)"
