import unittest
from unit.pie import *

from wifi_assistant.gui.application_settings_dialog import ApplicationSettingsDialog 

class ApplicationSettingsDialogTest(unittest.TestCase):
    
    def setUp(self):
        self.parent_window = None
        self.save_callback = Mock()
        
        #given(self.save_callback).save().willReturn(None)
        self.save_callback.replay()
 
        self.testee = ApplicationSettingsDialog(self.parent_window, self.save_callback.save)
        

    def test_cancelButtonDoesntCallSaveCallback(self):
        self._makeRunDialogReturn(ApplicationSettingsDialog.CANCEL_BUTTON)
        self.testee.show(False, '')
        verify(self.save_callback, never()).save()


    def test_saveButtonCallsSaveCallback(self):
        self._makeRunDialogReturn(ApplicationSettingsDialog.SAVE_BUTTON)
        self.testee.show(True, 'http://url')
        verify(self.save_callback).save(True, 'http://url')


    def _makeRunDialogReturn(self, value):
        class method():
            def __init__(self, value_to_return):
                self._value_to_return = value_to_return
            def __call__(self, x):
                return self._value_to_return
        self.testee._runDialog = method(value)
    
if __name__ == '__main__':
    unittest.main()

