#!/usr/bin/python2.5

import gtk, gobject
from gnome import gconf
import hildon

import logging, sys

from wifi_assistant.daemon.launcher import Launcher
from wifi_assistant.settings.application_settings import ApplicationSettings
from wifi_assistant.settings.network_settings import NetworkSettings
from wifi_assistant.gui.config_gui import ConfigGui

def _(str):
    return str

if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG, stream=sys.__stdout__)
    
    gconf_client = gconf.client_get_default()
    gconf_root_dir = '/apps/maemo/wifi_assistant'
    network_settings = NetworkSettings(gconf_client, gconf_root_dir)
    application_settings = ApplicationSettings(gconf_client, gconf_root_dir)
    launcher = Launcher()
    list_store = network_settings.getListStore()
    hildon_program = hildon.Program.get_instance()
    hildon_window = hildon.StackableWindow()

    # put it all together
    gui = ConfigGui(launcher, application_settings, network_settings, hildon_program, hildon_window, list_store)
    gui.main()
    gtk.main()
