from gnome import gconf
from wifi_assistant.gui.popup_dialog import PopupDialog

import unittest
from unit.pie import *

ssid = 'Network Name'

class PopupDialogTest(unittest.TestCase):

    def setUp(self):
        self.parent_window = None
        self.launch_callback = Mock()
        
        #given(self.launch_callback).call().willReturn(None)
        self.launch_callback.replay()
 
        self.testee = PopupDialog(self.parent_window, self.launch_callback.call)


    def test_clickingYesButtonCallsCallback(self):
        self._makeRunDialogReturn(PopupDialog.YES_BUTTON)
        self.testee.show(ssid)
        verify(self.launch_callback).call(ssid, True, True)


    def test_clickingNoButtonCallsCallback(self):
        self._makeRunDialogReturn(PopupDialog.NO_BUTTON)
        self.testee.show(ssid)
        verify(self.launch_callback).call(ssid, False, True)


    def test_cancellingDialogDoesntCallCallback(self):
        self._makeRunDialogReturn(-1)
        self.testee.show(ssid)
        verify(self.launch_callback, never()).call()
    
    
    def test_clickingYesButWithoutRemembering(self):
        pass
        # FIXME


    def _makeRunDialogReturn(self, value):
        class method():
            def __init__(self, value_to_return):
                self._value_to_return = value_to_return
            def __call__(self, x):
                return self._value_to_return
        self.testee._runDialog = method(value)
        
    
if __name__ == '__main__':
    unittest.main()
