#!/usr/bin/python2.5
import gtk, hildon
import logging

def _(str):
    return str

log = logging.getLogger("PopupDialog")

class PopupDialog():
    
    YES_BUTTON = 1
    NO_BUTTON = 2
    
    def __init__(self, parent_window, callback):
        """self.callback(ssid, launch_browser, remember)"""
        self._parent_window = parent_window
        self._callback = callback


    def show(self, ssid):
        log.debug("_show(%s)", ssid)
        dialog = gtk.Dialog(ssid, self._parent_window)
        dialog.vbox.set_homogeneous(False)
        
        dialog.add_button(_('No'), PopupDialog.NO_BUTTON)
        dialog.add_button(_('Yes'), PopupDialog.YES_BUTTON)
        
        label = gtk.Label(_('New network connection established - do you wish to launch a browser?'))
        label.set_line_wrap(True)
        #label.set_justify(gtk.JUSTIFY_LEFT)
        #label.set_alignment(0, 0.5)
        dialog.vbox.add(label)
    
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Remember this decision'))
        checkbox.set_active(True)
        dialog.vbox.add(checkbox)
        
        dialog.show_all()
        result = self._runDialog(dialog)
        dialog.hide()
        
        launch_browser = None
        if result == PopupDialog.YES_BUTTON:
            launch_browser = True
        if result == PopupDialog.NO_BUTTON:
            launch_browser = False
        
        if launch_browser is not None:
            remember = checkbox.get_active()
            self._callback(ssid, launch_browser, remember)
    

    def _runDialog(self, dialog):
        result = dialog.run()
        return result
