#!/usr/bin/python2.5
import gtk, hildon

def _(str):
    return str

class DeleteNetworksDialog():
    
    TOOLBAR_DELETE_BUTTON_EVENT = "button-clicked"
    TOOLBAR_BACK_BUTTON_EVENT = "arrow-clicked" 
    
    def __init__(self, model, deleteCallback):
        """deleteCallback(model, [iter_path])"""
        
        self._model = model
        self._deleteCallback = deleteCallback


    def show(self):
        # TODO: if model is empty, show banner instead: "Nothing to remove"
        self._window = hildon.StackableWindow()
        self._window.set_border_width(6)
     
        area = hildon.PannableArea()
        tree_view = self._createDeleteView()
        area.add(tree_view)
        self._window.add(area)
     
        self._toolbar = hildon.EditToolbar(_("Choose network settings to delete"), _("Delete"))
        self._toolbar.connect(DeleteNetworksDialog.TOOLBAR_DELETE_BUTTON_EVENT, self._deleteButtonClicked, tree_view)
        self._toolbar.connect(DeleteNetworksDialog.TOOLBAR_BACK_BUTTON_EVENT, self._backButtonClicked)
        self._window.set_edit_toolbar(self._toolbar)
     
        self._window.show_all()
        self._window.fullscreen()
        
        self._runDialog()


    #self._toolbar.connect_object("arrow-clicked", gtk.Window.destroy, self._window)
    def _backButtonClicked(self, button):
        self._window.destroy()


    def _deleteButtonClicked(self, button, treeview):
        selection = treeview.get_selection()
     
        (model, selected_rows) = selection.get_selected_rows()
        
        # TODO: are you sure?
     
        row_references = []
        for path in selected_rows:
            ref = gtk.TreeRowReference(model, path)
            row_references.append(ref)
        
        self._deleteCallback(model, row_references)
        
        self._window.destroy() 


    def _createDeleteView(self):
        tv = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
        renderer = gtk.CellRendererText()
        col = gtk.TreeViewColumn(_("Networks"), renderer, text=0)
     
        tv.append_column(col)
     
        # Set multiple selection mode
        selection = tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
     
        tv.set_model(self._model)
     
        return tv


    def _runDialog(self):
        pass
