#!/usr/bin/python2.5
import gtk, hildon

from launcher import Launcher
from settings import Settings

def _(str):
    return str

class ConfigGui():
    
    def __init__(self, launcher, settings):
        self._launcher = launcher
        self._settings = settings
        self._program = hildon.Program.get_instance()
        self._win = hildon.StackableWindow()
        self._model= self._settings.getLaunchSettings()


    def main(self):
        self._win.set_title(_("Wifi Jail Breakout Assistant"))
        ssid_list = self._create_ssid_view(self._model)
        pannable_area= hildon.PannableArea()
        pannable_area.add(ssid_list)
        self._win.add(pannable_area)
        self._win.set_app_menu(self._create_menu())
        self._win.connect("destroy", gtk.main_quit, None)
        self._win.show_all()
        gtk.main()

     
     # FIXME: refactor out
    def _launch_browser(self, url):
        self._launcher.openUrl(url)
    
    
    def _show_about(self, x):
        dialog = gtk.Dialog(_('About'), self._win)
        text = "I got tired of not being able to connect easily to networks guarded by a login page, " + \
            "so I created this app to scratch that itch. It's free to use, inspect, adapt and share, " + \
            "licensed under a BSD type license.\nI hope you enjoy it!"
        about_label = gtk.Label(_(text))
        about_label.set_line_wrap(True)
        dialog.vbox.add(about_label)
        
        dialog.add_button(_('File a bug'), 1)
        dialog.add_button(_('Donate'), 2)
        dialog.add_button(_('Close'), 3)
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        
        if result == 1:
            self._launcher.openUrl(_('http://wifi-assistant.garage.maemo.org/bugs/'))
        if result == 2:
            self._launcher.openUrl(_('http://wifi-assistant.garage.maemo.org/donate/'))
    
        
    def _show_settings(self, x):
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Show popup when connected to a new SSID'))
        checkbox.set_active(self._settings.getUsePopup())
        
        url_label = gtk.Label(_('URL to open when launching browser:')) # IMPROVEMENT: caption?
        url_label.set_alignment(0, 0.5)
        url_label.set_padding(5, 5)
        url_field = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        url_field.set_text(self._settings.getUrlToOpen())
        
        dialog = gtk.Dialog(_('Settings'), self._win)
        dialog.vbox.set_homogeneous(False)
        
        dialog.vbox.add(checkbox)
        dialog.vbox.add(url_label)
        dialog.vbox.add(url_field)
        
        dialog.add_button(_('Cancel'), gtk.RESPONSE_CANCEL)
        dialog.add_button(_('Save'), gtk.RESPONSE_YES)
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        
        if result == gtk.RESPONSE_YES:
            self._settings.setUrlToOpen(url_field.get_text())
            self._settings.setUsePopup(checkbox.get_active())
    
    
    def _create_menu(self):
        menu = hildon.AppMenu()
        
        about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        about.set_label(_("About"))
        about.connect("clicked", self._show_about)
        menu.append(about)
     
        settings = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        settings.set_label(_("Settings"))
        settings.connect("clicked",self._show_settings)
        menu.append(settings)
        
        add = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        add.set_label(_("Add network"))
        add.connect("clicked", self._add_ssid)
        menu.append(add)
        
        delete = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        delete.set_label(_("Delete networks"))
        delete.connect("clicked", self._delete_ssid)
        menu.append(delete)
        
        menu.show_all()
        return menu
    

    def _edit_ssid(self, ssid, model, iter):
        dialog = gtk.Dialog(ssid, self._win)
        dialog.vbox.set_homogeneous(False)
        
        dialog.add_button(_('No'), gtk.RESPONSE_NO)
        dialog.add_button(_('Yes'), gtk.RESPONSE_YES)
        
        label = gtk.Label(_('After being connected to ' + ssid + ' do you wish to launch a browser?')) #FIXME: l10n
        label.set_line_wrap(True)
        label.set_justify(gtk.JUSTIFY_LEFT)
        label.set_alignment(0, 0.5)
        dialog.vbox.add(label)
    
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        
        launchBrowser = None
        if result == gtk.RESPONSE_YES:
            launchBrowser = True
        elif result == gtk.RESPONSE_NO:
            launchBrowser = False
        
        if launchBrowser is not None:
            self._settings.setLaunchSetting(ssid, launchBrowser)
            model.set(iter, 1, launchBrowser)
    
    
    def _add_ssid(self, x):
        checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        checkbox.set_label(_('Launch browser when connected'))
        checkbox.set_active(True)
        
        url_label = gtk.Label(_('Name of the network:')) # IMPROVEMENT: caption?
        url_label.set_alignment(0, 0.5)
        url_label.set_padding(5, 5)
        url_field = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        url_field.set_text(_('MyNetwork'))
        
        dialog = gtk.Dialog(_('Add network'), self._win)
        dialog.vbox.set_homogeneous(False)
        
        dialog.vbox.add(url_label)
        dialog.vbox.add(url_field)
        dialog.vbox.add(checkbox)
        
        dialog.add_button(_('Cancel'), gtk.RESPONSE_CANCEL)
        dialog.add_button(_('Save'), gtk.RESPONSE_YES)
        
        dialog.show_all()
        result = dialog.run()
        dialog.hide()
        

        if result == gtk.RESPONSE_YES:
            launchBrowser = checkbox.get_active()
            ssid = url_field.get_text()
            self._settings.setLaunchSetting(ssid, launchBrowser)
            self._model.append([ssid, launchBrowser])
    

    def _delete_ssid(self, x):
        window = hildon.StackableWindow()
        window.set_border_width(6)
        toolbar = hildon.EditToolbar(_("Choose network settings to delete"), _("Delete"))
        window.set_edit_toolbar(toolbar)
     
        area = hildon.PannableArea()
        tree_view = self._create_delete_view()
        area.add(tree_view)
        window.add(area)
     
        toolbar.connect("button-clicked", self._delete_button_clicked, tree_view)
        toolbar.connect_object("arrow-clicked", gtk.Window.destroy, window)
     
        window.show_all()
        window.fullscreen()


    def _delete_button_clicked(self, button, treeview):
        selection = treeview.get_selection()
     
        (model, selected_rows) = selection.get_selected_rows()
        
        # TODO: are you sure?
     
        row_references = []
        for path in selected_rows:
            ref = gtk.TreeRowReference(model, path)
            row_references.append(ref)
     
        for ref in row_references:
            path = ref.get_path()
            iter = model.get_iter(path)
            ssid, x = model.get(iter, 0, 1)  
            self._settings.deleteLaunchSetting(ssid)
            model.remove(iter)

        # TODO: close delete window?

        
    def _create_delete_view(self):
        tv = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
        renderer = gtk.CellRendererText()
        col = gtk.TreeViewColumn("Title", renderer, text=0)
     
        tv.append_column(col)
     
        # Set multiple selection mode
        selection = tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE)
     
        tv.set_model(self._model)
     
        return tv


    def _create_ssid_view(self, model):
#        view = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL, model)
#        view = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL, model)

        if len(model) == 0:
            return gtk.Label(_('There are no launch settings saved for any network'))

        view = gtk.TreeView(model)
        view.set_border_width(5)
        
        def boolean_func(column, cell, model, iter):
            if model.get_value(iter, 1):
                stock_id = 'gtk-yes'
            else:
                stock_id = 'gtk-no'
            cell.set_property('stock-id', stock_id)
        
        launch_cell = gtk.CellRendererPixbuf()
        launch_cell.set_fixed_size(100, 50)
        view.insert_column_with_data_func(1, _('Launch'), launch_cell, boolean_func)
#        toggle_cell = gtk.CellRendererToggle()
#        toggle_cell.set_fixed_size(100, 50)
#        view.append_column( gtk.TreeViewColumn( '', toggle_cell, active=1))
         
        tvcolumn = gtk.TreeViewColumn(_('SSID'), gtk.CellRendererText(), text = 0)
        tvcolumn.set_expand(True)
        view.append_column(tvcolumn)
    
        view.connect('row-activated', self._row_activated)
        view.set_search_column(0)
        tvcolumn.set_sort_column_id(0)
        
        return view


    def _row_activated(self, treeview, path, view_column):
        model = treeview.get_model()
        iter = model.get_iter(path)
        ssid = model.get_value(iter, 0)
        self._edit_ssid(ssid, model, iter)
        

if __name__ == "__main__":
    gui = ConfigGui(Launcher(), Settings())
    gui.main()
