#include "findipkwindow.h"
#include "ui_findipkwindow.h"
#include <QDesktopServices>
#include <QUrl>
#include <QFileDialog>

#include "config.h"

FindIpkWindow::FindIpkWindow(QWidget *parent, GameInfo * game) :
    QDialog(parent),
    ui(new Ui::FindIpkWindow),
    _game(game),
    _urlLaunched(false)
{
    ui->setupUi(this);
    ui->mainLabel->setText(tr("You have to download original game file with name ")
                           + _game->IPKFile() +
                           tr(" and save it into the"
                           "/Downloads folder."));
}

FindIpkWindow::~FindIpkWindow()
{
    delete ui;
}

void FindIpkWindow::on_urlButton_clicked()
{
    // Return if pressed after URL launched and
    // user returned to this button(which renamed to
    // "Done" already).
    if (_urlLaunched)
    {
        done(0);
        return;
    }

    QDesktopServices::openUrl(QUrl("http://www.google.com.ua/search?q="
                                   + _game->IPKFile()));
    _urlLaunched = true;
    ui->mainLabel->setText(tr("If you're sure that you downloaded right .ipk "
                              "file to MyDocs/Downloads directory, then "
                              "click \"Done\""));
    ui->urlButton->setText(tr("Done"));
    ui->locateButton->hide();
}

void FindIpkWindow::on_locateButton_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this,
         tr("Locate IPK File"),
         MYDOCS_DIR,
         tr("IPK (*.ipk)"));
    if (!fileName.isEmpty())
        _game->SetIPKPath(fileName);
    done(0);
    return;
}
