#include "mainwindow.h"
#include <QtGui>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>

#endif

/****************************************************************************
**
** Copyright (C) 2009 Alvaro Manera.
** Contact: alblurrow@yute.com
**
** This file is part of weiight program
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 or 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    QPalette pallete;
    
    //    pallete.setColor(QPalette::Text, QColor(255,255,255));
    //    pallete.setColor(QPalette::Window, QColor(255,255,255));
    
    setWindowTitle(QLatin1String("Weiight - Are you fat?"));
    buttonsLayout = new QHBoxLayout();
    connectButton = new QPushButton(tr("Connect"));
    connectButton->setMinimumHeight(60);
    connectButton->setFont(QFont("Helvetica", 18, QFont::Bold));
    
    weightButton =  new QPushButton(tr("Weight"));
    weightButton->setMinimumHeight(60);
    weightButton->setEnabled(false);
    weightButton->setFont(QFont("Helvetica", 18, QFont::Bold));
    
    disconnectButton = new QPushButton(tr("Disconnect"));
    disconnectButton->setMinimumHeight(60);
    disconnectButton->setEnabled(false);
    disconnectButton->setFont(QFont("Helvetica", 18, QFont::Bold));
    
    msgLabel = new QLabel();
    //    msgLabel->setPalette(pallete);
    msgLabel->setMaximumHeight(20);
    msgLabel->setFont(QFont("Helvetica", 14, QFont::Bold));
    msgLabel->setAlignment(Qt::AlignCenter);
    
    buttonsLayout->addWidget(connectButton);
    buttonsLayout->addWidget(weightButton);
    buttonsLayout->addWidget(disconnectButton);
    
    digitsLayout = new QHBoxLayout();
    integer = new Digits(this);
    //    tenths->resize(100,150);
    decimal = new Digits(this);
    digitsLayout->addWidget(integer);
    digitsLayout->addWidget(decimal);
    
    
    globalLayout = new QVBoxLayout();
    globalLayout->addItem(digitsLayout);
    //    globalLayout->addWidget(msgLabel);
    globalLayout->addItem(buttonsLayout);
    
    QWidget* widget = new QWidget(this);
    widget->setLayout(globalLayout);
    setCentralWidget(widget);
    connect(connectButton, SIGNAL(clicked()), this, SLOT(connectClicked()));
    connect(weightButton, SIGNAL(clicked()), this, SLOT(weightClicked()));
    connect(disconnectButton, SIGNAL(clicked()), this, SLOT(disconnectClicked()));
    
    connect(&board, SIGNAL(initDone()), this, SLOT(initDone()));
    connect(&board, SIGNAL(closeDone()), this, SLOT(closeDone()));
    connect(&board, SIGNAL(error(int)), this, SLOT(error(int)));
    connect(&board, SIGNAL(weightDone(float)), this, SLOT(weightDone(float)));
    
    
    QAction *aboutAction = new QAction(tr("About"), this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(about()));
    menuBar()->addAction(aboutAction);
    
    //    tenths = new Digits(this);
    //    tenths->resize(100,300);
    //    units = new Digits(this);
    //    units->resize(100,300);
    //    units->show();
    //    units->show();
    //    tenths->flipTo(34);
    
}

MainWindow::~MainWindow()
{
    
}

void MainWindow::connectClicked() {
    
    //    msgLabel->setText(tr("Searching..."));
    toggleBusy(Qt::Checked);
    QMaemo5InformationBox::information(this, tr("Press the red button next to the batteries on the Balance Board"));
    board.init();
    
}

void MainWindow::weightClicked() {
    
    //    msgLabel->setText(tr("Measuring..."));
    toggleBusy(Qt::Checked);
    board.weight();
    
}

void MainWindow::disconnectClicked() {
    
    toggleBusy(Qt::Unchecked);
    board.close();
}

void MainWindow::weightDone(float w)
{
    //    msgLabel->setText("");
    toggleBusy(Qt::Unchecked);
    if (w > 0) {
        int ent = w;
        int dec = (w-ent)*10;
        integer->flipTo(ent);
        decimal->flipTo(dec);
    } else {
        if (w == ERR_NOT_BALANCE_BOARD){
            QMaemo5InformationBox::information(this, tr("Only Balance Board supported"));
        } else {
            QMaemo5InformationBox::information(this, tr("Error trying to get the weight"));
        }
    }
    
    
}

void MainWindow::initDone()
{
    
    //    msgLabel->setText(tr("Connected"));
    toggleBusy(Qt::Unchecked);
    weightButton->setEnabled(true);
    disconnectButton->setEnabled(true);
    
}

void MainWindow::closeDone()
{
    toggleBusy(Qt::Unchecked);
    disconnectButton->setEnabled(false);
    weightButton->setEnabled(false);
    //    msgLabel->setText("");
    
}

void MainWindow::error(int error) {
    
    toggleBusy(Qt::Unchecked);
    qDebug() << "Error emited" << error;
    //    msgLabel->setText(tr("Error"));
    if (error == 1)
        QMaemo5InformationBox::information(this, tr("Turn on the bluetooth!"));
    else
        QMaemo5InformationBox::information(this, tr("Some kind of Error happened"));
    
}

void MainWindow::toggleBusy(int checkState)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, checkState == Qt::Checked);
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About this app"),
                       tr("Author: <a href=mailto:alblurrow@yute.com>Alvaro Manera</a><br> \
                          No responsability if the weight is not accurate. \
                          In fact I think it is like 1 Kg extra. So far only \
                          up to 99.99 Kg is shown, and only Kg. Sorry \
                          Imperial guys."));
}
