#ifndef BALANCEBOARD_H
#define BALANCEBOARD_H

/****************************************************************************
**
** Copyright (C) 2009 Alvaro Manera.
** Contact: alblurrow@yute.com
**
** This file is part of weiight program
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 or 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QString>
#include <QThread>

#include <cwiid.h>

#define ERR_OK 0
#define ERR_NO_CONNECTION 1
#define ERR_SET_RPT_MODE  2
#define ERR_SET_LED 3
#define ERR_GET_CALIBRATION 4
#define ERR_DISCONNECT 5
#define ERR_GET_STATE -1
#define ERR_NOT_BALANCE_BOARD -2

class BalanceBoard : public QThread
{
    Q_OBJECT

public:
    BalanceBoard();
    /**
      Init the connection with the Balance Board
      To find the BB it needs to be in the
      discover mode. (Press sync)
      @return 0 if OK, number with the error code
      */
    bool init(QString addr = "");
    /**
      Give the weight from the balance board
      @return The weight in kg. If negative there was an error
      */
    bool weight();
    /**
      Close the connection with the Balance board
      */
    bool close();

    /** Entry point of the thread */

    void run();

signals:
    void initDone();
    void error(int error);
    void weightDone(float weight);
    void closeDone();

private:
    struct balance_cal   bal;
    cwiid_wiimote_t *wiimote;	/* wiimote handle */

    float weight_interpolate(uint16_t value, uint16_t *cal);
    float calculate_weight(struct cwiid_state *state, struct balance_cal *calibration);

    enum stateType {
        STOP,
        INIT,
        STATE,
        CLOSE
    };
    stateType mState;

    bdaddr_t bdaddr;

    void init_run();
    void weight_run();
    void close_run();

};

#endif // BALANCEBOARD_H
