/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Util.h"

#include <Lum/Base/String.h>

#include <Lum/Model/String.h>

bool StringToValue(const std::wstring& string, Value& value)
{
  if (string.length()==0)  {
    return false;
  }

  bool   negative=false;
  size_t pos;

  value=0;

  pos=0;

  if (string[pos]==L'-') {
    negative=true;
    pos++;
  }

  while (pos<string.length() && string[pos]>=L'0' && string[pos]<=L'9') {
    value=value*10+string[pos]-L'0';
    pos++;
  }

  value*=10;

  if (negative) {
    value=-value;
  }

  if (pos==string.length()) {
    return true;
  }

  if (string[pos]!=Lum::Base::GetDecimalPointWChar()) {
    return false;
  }

  pos++;

  size_t digit=1;

  while (pos<string.length() && string[pos]>=L'0' && string[pos]<=L'9') {
    if (digit==1) {
      value+=string[pos]-L'0';
    }
    else {
      return false;
    }

    digit++;
    pos++;
  }

  return pos==string.length();
}

std::wstring ValueToString(Value value)
{
  std::wstring result;
  result=Lum::Base::NumberToWString(value/10);

  if (value%10!=0) {
    result+=Lum::Base::GetDecimalPointWString()+
            Lum::Base::NumberToWString(value%10);
  }

  return result;
}

bool StringToAmount(const std::wstring& string, size_t & amount)
{
  if (string.length()==0)  {
    return false;
  }

  size_t pos;

  amount=0;

  pos=0;
  while (pos<string.length() && string[pos]>=L'0' && string[pos]<=L'9') {
    amount=amount*10+string[pos]-L'0';
    pos++;
  }

  amount*=10;

  if (pos==string.length()) {
    return true;
  }

  if (string[pos]!=Lum::Base::GetDecimalPointWChar()) {
    return false;
  }

  pos++;

  size_t digit=1;

  while (pos<string.length() && string[pos]>=L'0' && string[pos]<=L'9') {
    if (digit==1) {
      amount+=string[pos]-L'0';
    }
    else {
      return false;
    }

    digit++;
    pos++;
  }

  return pos==string.length();
}

std::wstring AmountToString(size_t amount)
{
  std::wstring result;
  result=Lum::Base::NumberToWString(amount/10);

  if (amount%10!=0) {
    result+=Lum::Base::GetDecimalPointWString()+
            Lum::Base::NumberToWString(amount%10);
  }

  return result;
}

bool AmountValidator::IsValid(Lum::Base::Model* value) const
{
  if (value==NULL || value->IsNull() || dynamic_cast<Lum::Model::String*>(value)==NULL) {
    return false;
  }

  size_t amount;

  return StringToAmount(dynamic_cast<Lum::Model::String*>(value)->Get(),amount);
}

bool ValueValidator::IsValid(Lum::Base::Model* value) const
{
  if (value==NULL || value->IsNull() || dynamic_cast<Lum::Model::String*>(value)==NULL) {
    return false;
  }

  Value v;

  return StringToValue(dynamic_cast<Lum::Model::String*>(value)->Get(),v);
}
