#ifndef FOODINPUT_H
#define FOODINPUT_H

/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>
#include <Lum/Model/Time.h>

#include "Configuration.h"

typedef Lum::Model::StdTable<const Food*> FoodModel;
typedef Lum::Base::Reference<FoodModel>   FoodModelRef;

class FoodInput : public Lum::Component
{
private:
  Lum::Model::ActionRef              addFoodEntryAction;
  Lum::Model::ActionRef              removeFoodEntryAction;
  Lum::Model::ActionRef              editFoodEntryAction;
  Lum::Model::ActionRef              registerFoodAction;

  Lum::Model::StringRef              foodSearch;
  FoodModelRef                       foods;
  Lum::Model::SingleLineSelectionRef foodSelection;
  std::wstring                       lastFoodSearchFilter;
  Lum::Model::ActionRef              searchTimerAction;

private:
  void AddFoodEntry();
  void EditFoodEntry();
  void RemoveFoodEntry();
  void RegisterFood();

  void AddWeight();
  void RemoveItem();
  void EditItem();

public:
  FoodInput();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  void InitializeGUI();
  void UpdateFoods();
};

#endif
