/*
 * mainwindow.h - main window class.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef _MAINWINDOW_H_
#define _MAINWINDOW_H_

#include <QtGui>

#include "authdbusadaptor.h"
#include "authparams.h"


class QWebView;
class QLineEdit;


class MainWindow : public QMainWindow
{
    Q_OBJECT

    public:
        MainWindow(const int ID);
        virtual ~MainWindow();

        void setURL(const QString &url);

        void startAuth(const QString &url);
        void startAuth(const QString &url, const QStringList &params);

        int getWindowID();

    protected:
        virtual void closeEvent(QCloseEvent *event);

    protected slots:
        void adjustLocation();
        void changeLocation();
        void adjustTitle();
        void setProgress(int p);
        void finishLoading(bool);

    private:
        QString jQuery;
        QString url;

        QLabel *authTitle;
        QAction *rotateAction;
        QWebView *view;
        QLineEdit *locationEdit;

        AuthParams authParams;

        bool isAuthSimple;
        bool isClosedByUser;
        int progress;
        const int windowID;

        void setToolBars(bool withAuthTitle = false);
        bool isAuthComplete();
        void sendAuthResult(const QString & authResult, bool withReturnParams);

    Q_SIGNALS:
        void closed(const int windowID);
}; 

#endif
