/*
 * mainwindow.cpp - mainwindow class implementation.
 *
 * Copyright (C) 2011 - Nikita S. Artemov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 */

#include <QtGui>
#include <QFileDialog>

#include "mainwindow.h"

using namespace std;

const char* connectionName = "org.lomalan.AuthManager";
const char* serviceName = "org.lomalan.AuthManager";
const char* pathName = "/AuthManager";


MainWindow::MainWindow( ) : authInterface(serviceName, QString("/AuthManager"), connectionName)
{
    vbox = new QVBoxLayout;
    hbox1 = new QHBoxLayout;
    hbox2 = new QHBoxLayout;
    hbox3 = new QHBoxLayout;
    window = new QWidget(this);
    view = new QLabel;
    info = new QLabel;
    lblFile = new QLabel("Filename:");
    lblClient = new QLabel("Client ID: ");
    editClientID = new QLineEdit;

    editFileName = new QLineEdit;
    connect(editFileName, SIGNAL(returnPressed()), SLOT(choose()));

    choiceButton = new QPushButton("Select");
    connect(choiceButton,SIGNAL(clicked()), SLOT(choose()));

    sendButton = new QPushButton("Send");
    connect(sendButton, SIGNAL(clicked()), SLOT(send()));


    vbox->addWidget(view);
    vbox->addLayout(hbox1);
    hbox1->addWidget(lblFile);
    hbox1->addWidget(editFileName);
    hbox1->addWidget(choiceButton);
    vbox->addLayout(hbox2);
    hbox2->addWidget(lblClient);
    hbox2->addWidget(editClientID);
    vbox->addLayout(hbox3);
    hbox3->addWidget(sendButton);
    vbox->addWidget(info);

    window->setLayout(vbox);
    setCentralWidget(window);
}


void MainWindow::choose()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Open test CAPTCHA image"), QDir::currentPath(), tr("Image files(*.png *.gif *.jpg);;All files (*.*)"));

    if (!filename.isNull())
    {
        this->editFileName->setText(filename);
    }

    if(editFileName->text().isEmpty()){
        view->setText("Enter a file name");
        encoded.clear();
        return;
    }

    loadFile(editFileName->text());
    editFileName->selectAll();
}

void MainWindow::send()
{
    if(editFileName->isReadOnly()){
       return;
    }

    clientID = editClientID->text();
    if(editFileName->text().isEmpty() && encoded.isEmpty()){
        qsrand(QTime(0,0,0).secsTo(QTime::currentTime()));
        editFileName->setText(QString::number(qrand()%(COUNT_OF_IMAGE),10) + ".gif");
        choose();
    }
    sendImage(encoded);

    if(editClientID->text().isEmpty()){
        clientID = "captchamsg";
    }
    QDBusConnection::sessionBus().connect(QString(), QString(), connectionName, clientID,
                                           (QObject*)this, SLOT(messageSlot(QStringList)));

    editFileName->setReadOnly(true);
    editClientID->setReadOnly(true);
}

void MainWindow::messageSlot(const QStringList &result)
{
    if("captchaResult" == result[0]){
        if("closed" == result[1]){
            info->setText("Window of captcha was closed");
            editFileName->setReadOnly(false);
            editClientID->setReadOnly(false);
            return;
        }

        info->setText("Return value: " + result[1]);
        editFileName->setReadOnly(false);
        editClientID->setReadOnly(false);
    }

   // QCoreApplication::exit(0);
}

void MainWindow::sendImage(const QString &strBase64)
{
    info->setText("Request..");
    QDBusReply<QString> repl = authInterface.call("Captcha", strBase64, clientID);

    if (repl.isValid() == false) {
        cout << "\nCan't send auth data...(" << repl.error().message().toAscii().constData() << ")\n";
    }
}

void MainWindow::loadFile(const QString &fileName){

    QFile* file = new QFile(fileName);
    if(false == file->open(QIODevice::ReadOnly)){
        view->setText("File not found");
        encoded.clear();
        return;
    }

    QByteArray data = file->readAll();
    encoded = QString(data.toBase64());
    QPixmap image;
    image.loadFromData(data);
    view->setPixmap(image);
    view->setAlignment(Qt::AlignCenter);
    editFileName->setReadOnly(false);
}


void MainWindow::closeEvent(QCloseEvent *)
{
    QDBusMessage msg = QDBusMessage::createSignal(QString(pathName),QString(connectionName), "shutdown");
    QDBusConnection::sessionBus().send(msg);
}



