/*
 * main.cpp - main file of dbus auth client.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#include <QtDebug>
#include <QtCore>
#include <QtDBus>
#include <iostream>

#include "client.h"

using namespace std;



namespace {
    const QString dbusAppPath = "org.lomalan.AuthManager";
    const QString dbusAppName = "/AuthManager";
    //const QString authUrl = "http://vkontakte.ru/login.php?app=1899304&layout=popup&type=touch";
    const QString authUrl1 = "http://vkontakte.ru/login.php?app=1899304&layout=popup&type=touch";
    const QString authUrl2 = "https://graph.facebook.com/oauth/authorize?client_id=133410120012716&redirect_uri=http://www.facebook.com/connect/login_success.html&type=user_agent&display=popup";
    
    const QString regexpParamName = "RegExp";
    const QString titleParamName = "Title";
    const QString titleParamNameRET = "Title_RET";
    const QString clientIDParamName = "ClientID";
    const QString clientIDParamNameRET = "ClientID_RET";
    
    const char* proxyIP = NULL;
    const char* proxyPort = NULL;
    const char* username = NULL;
    const char* password = NULL;
}


#define EXT

int main(int argc, char **argv)
{
    QCoreApplication app(argc, argv);

    QStringList list1;



    list1.append(regexpParamName);
    list1.append("^https://www\\.facebook\\.com/connect/login_success\\.html.*");
    list1.append(regexpParamName);
    list1.append("^http://www\\.facebook\\.com/connect/login_success\\.html.*");
    list1.append(regexpParamName);
    list1.append(".*access_denied.*");
    list1.append(regexpParamName);
    list1.append("http://vkontakte.ru/api/login_failure.html");
    list1.append(regexpParamName);
    list1.append("^http://vkontakte\\.ru/api/login_success\\.html#session.*");

    list1.append(titleParamNameRET);
    list1.append("YO-ho-ho, bastards. Copyright  \"Die Hadr.\"");

    QStringList list2(list1);
    QStringList list3(list1);
    QStringList list4(list1);

    list1.append(clientIDParamNameRET);
    list1.append("client1");

    list2.append(clientIDParamNameRET);
    list2.append("client2");
    list2.append("test_RET");
    list2.append("Testing par");


    list3.append(clientIDParamNameRET);
    list3.append("client3");
    list3.append("test3_RET");
    list3.append("Testing par3");


    //list4.append(clientIDParamNameRET);
   // list4.append("!!!");
    list4.append("test4_RET");
    list4.append("Testing par4");
    list4.insert(0,titleParamNameRET);
    list4.insert(1,"It's Testing...");


#ifdef EXT
    Client client1("message");
    Client client2("client2");
    Client client3("client3");
    Client client4("message");
#else
    Client client1("message");
    Client client2("message");
#endif

    client1.setProxy(proxyIP, proxyPort, username, password);

#ifdef EXT
    client1.sendAuth(authUrl1);
//    client2.sendAuth(authUrl2, list2);
//    client3.sendAuth(authUrl1, list3);
//    client4.sendAuth(authUrl2, list4);
#else
    client1.sendAuth(authUrl1);
    client2.sendAuth(authUrl1);
#endif
sleep(3);
    app.exec();
    QDBusMessage msg = QDBusMessage::createSignal(dbusAppName, dbusAppPath, "shutdown");
   // qDebug("Send %i", QDBusConnection::sessionBus().send(msg));
//    QDBusMessage msg = QDBusMessage::createSignal(dbusAppName, dbusAppPath, "shutdown");
//    qDebug("Send %i", QDBusConnection::sessionBus().send(msg));
    return 0;

}

