/*
 * client.cpp - clent class implementation.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#include "client.h"

const char* connectionName = "org.lomalan.AuthManager";
const char* serviceName = "org.lomalan.AuthManager";
const char* objectName = "/AuthManager";


using namespace std;


Client::Client(QString clientID) : authInterface(serviceName, QString("/AuthManager"), connectionName)
{
    this->clientID =clientID;
    QDBusConnection::sessionBus().connect(QString(), QString(), connectionName, clientID,
                                           (QObject*)this, SLOT(messageSlot(QStringList)));
}


Client::~Client()
{
}


void Client::messageSlot(const QStringList &result)
{
    cout << "\nMessage received: ";

    int len = result.length() - 1;

    for (int i = 0; i < len; i += 2) {
        cout << "Name: " << result[i].toAscii().constData()
            << " Value: " << result[i + 1].toAscii().constData() << endl;
    }


    //QCoreApplication::exit(0);
}


void Client::setProxy(const QString &proxyIP, const QString &proxyPort, 
        const QString &username, const QString &password)
{
    authInterface.call("SetProxy", proxyIP, proxyPort, username, password);
}


void Client::sendAuth(const QString &url)
{
    QDBusReply<QString> repl = authInterface.call("Auth", url);

    if (repl.isValid() == true) {
        cout << "\nAuth data send...\n";
    } else {
        cout << "\nCan't send auth data...(" << repl.error().message().toAscii().constData() << ")\n";
    }
}


void Client::sendAuth(const QString &url, QStringList &params)
{
    QDBusReply<QString> repl = authInterface.call("Auth", url, params);

    if (repl.isValid() == true) {
        cout << "\nAuth data send...\n";
    } else {
        cout << "\nCan't send auth data...(" << repl.error().message().toAscii().constData() << ")\n";
    }
}
