/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "contacts.h"

// Global includes
#include <QtCore/QRegExp>
#include <QtCore/QLocale>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

bool PROVIDERS_API isInternationalNumber(const QString& number)
{
  // Accepted versions (complete international)
  return ( number.startsWith("00") || number.startsWith(QLatin1Char('+')) );
}

//////////////////////////////////////////////////////////////////////////

bool PROVIDERS_API make_number_international(const QString& prefix, QString* number, bool* wasPrefixed)
{
  if ( wasPrefixed )
    *wasPrefixed = false;

  /// ### Convert a number to international format.
  /// ### TODO: Detect the country prefix where the mobile phone is (or the provider?)
  /// 004989xxxx stays
  /// +4989      stays
  /// 089        becomes +4989
  /// 123456     is invalid (we don't know the region, same network as the mobile could be)

  // Accepted versions (complete international)
  if ( isInternationalNumber(*number) )
    return true;

  // Country-local
  if ( number->startsWith("0") )
  {
    if ( wasPrefixed )
      *wasPrefixed = true;

    // Insert country code instead of the first zero
    number->replace(QRegExp("^0"), prefix);
    return true;
  }

  return false;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
