/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SETTINGSDIALOG_HPP
#define SETTINGSDIALOG_HPP

// Local includes
#include "settings.hpp"

// Global includes
#include <QtGui/QDialog>

// Forward declarations
class SettingsDialogPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/**
 * The global settings dialog
 */
class SettingsDialog : public QDialog
{
  Q_OBJECT

public:
  SettingsDialog(QWidget* parent = 0, Qt::WindowFlags f = 0);
  ~SettingsDialog();

  /// Get/Set the settings
  void setSettings(const Settings& settings);
  Settings settings() const;

protected:
  SettingsDialogPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // SETTINGSDIALOG_HPP
