#
#
#  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
#
#  This file is part of Web2SMS.
#
#  Web2SMS is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Web2SMS is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
#
#

from PyQt4 import QtCore, QtGui
import web2sms

myProviderUuid = QtCore.QUuid('ffd7247b-a53b-4bc5-854c-eee1a89b1f7d')

# The provider instance
class MyPythonProvider(web2sms.ProviderInterface):
    userName = str()
    password = str()
    
    def __init__(self, parent):
        web2sms.ProviderInterface.__init__(self, parent)

    def loadSettings(self, data):
        stream = QtCore.QDataStream(data, QtCore.QIODevice.ReadOnly)
        stream.__rshift__(self.userName)
        stream.__rshift__(self.password)
    
    def saveSettings(self):
        data = QtCore.QByteArray()
        stream = QtCore.QDataStream(data, QtCore.QIODevice.WriteOnly)
        stream.__lshift__(self.userName)
        stream.__lshift__(self.password)
        return data
        
    def messageTypes(self):
        return [ web2sms.MessageType('Standard', 'standard', QtGui.QIcon(), '', 160, 160, 1) ]
                         
    def showAccountSettingsDialog(self, parent):
        dialog = web2sms.AccountSettingsDialog()
        dialog.setWindowTitle('Python Account Options')
                
        if dialog.exec_() == QtGui.QDialog.Accepted:
            self.userName = dialog.userName()
            self.password = dialog.password()
            print 'Settings changed'    
        return True
				
    def sendMessage(self, message):
        #print 'Text: %s', message.text()        
        self.sendMessageReply.emit(True, message) # Message has been successfully sent			        

# The Plugin instance
class MyPythonProviderPlugin(web2sms.ProviderPlugin):
    safetyObject = QtCore.QObject() # Makes sure that the Provider exists until the Plugin dies
    
    def info(self):
        return [ web2sms.ProviderInfo('Visible python name', myProviderUuid, QtGui.QIcon(), QtCore.QLocale.Germany) ]            

    def createProvider(self, uuid):   
        if uuid == myProviderUuid:
            return MyPythonProvider(self.safetyObject) # The provider must live as long as the Plugin lives         
    
        return None
        
# Entry point function
def qt_plugin_instance():
    return MyPythonProviderPlugin() # The returned class gets owned by c++
    
