/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "bitesmsaccountsettingsdialog.hpp"
#include "ui_bitesmsaccountsettingsdialog.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct biteSMSAccountSettingsDialogPrivate
{
  Ui_biteSMSAccountSettingsDialog ui;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

biteSMSAccountSettingsDialog::biteSMSAccountSettingsDialog(QWidget* parent /* = 0 */)
: QDialog(parent)
, d(new biteSMSAccountSettingsDialogPrivate)
{
  // Setup the ui
  d->ui.setupUi(this);
}

//////////////////////////////////////////////////////////////////////////

biteSMSAccountSettingsDialog::~biteSMSAccountSettingsDialog()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void biteSMSAccountSettingsDialog::setToken(const QString& token)
{
  d->ui.tokenEdit->setText(token);
}

//////////////////////////////////////////////////////////////////////////

QString biteSMSAccountSettingsDialog::token() const
{
  return d->ui.tokenEdit->text();
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
