/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "messagetypemodel.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct MessageTypeModelPrivate
{
  QList<MessageType> messageTypes;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

MessageTypeModel::MessageTypeModel(QObject* parent)
: QAbstractListModel(parent)
, d(new MessageTypeModelPrivate)
{
}

//////////////////////////////////////////////////////////////////////////

MessageTypeModel::~MessageTypeModel()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void MessageTypeModel::setMessageTypes(const QList<MessageType>& messageTypes)
{
  d->messageTypes = messageTypes;
  reset();
}

//////////////////////////////////////////////////////////////////////////

QList<MessageType> MessageTypeModel::messageTypes() const
{
  return d->messageTypes;
}

//////////////////////////////////////////////////////////////////////////

QModelIndex MessageTypeModel::indexFromMessageType(const MessageType& messageType) const
{
  int idx = d->messageTypes.indexOf(messageType); // Get the index - slow but who cares ..
  if ( idx != -1 )
    return createIndex(idx, 0);
  else
    return QModelIndex();
}

//////////////////////////////////////////////////////////////////////////

int MessageTypeModel::rowCount(const QModelIndex& parent /* = QModelIndex */) const
{
  if ( parent.isValid() )
    return 0;

  return d->messageTypes.size();
}

//////////////////////////////////////////////////////////////////////////

QVariant MessageTypeModel::data(const QModelIndex& index, int role /* = Qt::DisplayRole */) const
{
  int row = index.row();
  if ( row < 0 || row >= d->messageTypes.size() )
    return QVariant();

  const MessageType& messageType = d->messageTypes.at(row);

  switch(role)
  {
  case Qt::DisplayRole:
    if ( messageType.information().isEmpty() )
      return messageType.visibleName();
    else
      return QString("%1 (%2/SMS)").arg(messageType.visibleName()).arg(messageType.information());

  case Qt::DecorationRole:
    return messageType.icon();

  case MessageTypeRole:
    return QVariant::fromValue(messageType);

  default:
    return QVariant();
  }
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
